/*
 * Decompiled with CFR 0.152.
 */
package syntaxhighlight;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import syntaxhighlight.JTextComponentRowHeader;
import syntaxhighlight.Parser;
import syntaxhighlight.SyntaxHighlighterPane;
import syntaxhighlight.Theme;

public class SyntaxHighlighter
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    protected SyntaxHighlighterPane highlighter;
    protected JTextComponentRowHeader highlighterRowHeader;
    protected Theme theme;
    protected Parser parser;
    protected String content;

    public SyntaxHighlighter(Parser parser, Theme theme) {
        this(parser, theme, new SyntaxHighlighterPane());
    }

    public SyntaxHighlighter(Parser parser, Theme theme, SyntaxHighlighterPane highlighterPane) {
        if (theme == null) {
            throw new NullPointerException("argument 'theme' cannot be null");
        }
        if (highlighterPane == null) {
            throw new NullPointerException("argument 'highlighterPane' cannot be null");
        }
        this.theme = theme;
        this.parser = parser;
        this.setBorder(null);
        this.highlighter = highlighterPane;
        this.highlighter.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.highlighter.setTheme(theme);
        this.setViewportView(this.highlighter);
        this.highlighterRowHeader = new JTextComponentRowHeader(this, this.highlighter);
        theme.setTheme(this.highlighterRowHeader);
        this.setRowHeaderView(this.highlighterRowHeader);
    }

    protected void render() {
        if (this.content != null) {
            this.highlighterRowHeader.setListenToDocumentUpdate(false);
            this.highlighter.setStyle(this.parser.parse(null, this.content));
            this.highlighterRowHeader.setListenToDocumentUpdate(true);
            this.highlighterRowHeader.checkPanelSize();
        }
    }

    public SyntaxHighlighterPane getHighlighter() {
        return this.highlighter;
    }

    public JTextComponentRowHeader getHighlighterRowHeader() {
        return this.highlighterRowHeader;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        if (theme == null) {
            throw new NullPointerException("argument 'theme' cannot be null");
        }
        if (!this.theme.equals(theme)) {
            this.theme = theme;
            this.highlighter.setTheme(theme);
            theme.setTheme(this.highlighterRowHeader);
        }
    }

    public void setFirstLine(int firstLine) {
        this.highlighterRowHeader.setLineNumberOffset(firstLine - 1);
        this.highlighter.setLineNumberOffset(firstLine - 1);
    }

    public List<Integer> getHighlightedLineList() {
        return this.highlighter.getHighlightedLineList();
    }

    public void setHighlightedLineList(List<Integer> highlightedLineList) {
        this.highlighterRowHeader.setHighlightedLineList(highlightedLineList);
        this.highlighter.setHighlightedLineList(highlightedLineList);
    }

    public void addHighlightedLine(int lineNumber) {
        this.highlighterRowHeader.addHighlightedLine(lineNumber);
        this.highlighter.addHighlightedLine(lineNumber);
    }

    public boolean isGutterVisible() {
        return this.getRowHeader() != null && this.getRowHeader().getView() != null;
    }

    public void setGutterVisible(boolean visible) {
        if (visible) {
            this.setRowHeaderView(this.highlighterRowHeader);
            this.highlighter.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        } else {
            this.setRowHeaderView(null);
            this.highlighter.setBorder(null);
        }
    }

    public boolean isHighlightOnMouseOver() {
        return this.highlighter.isHighlightOnMouseOver();
    }

    public void setHighlightOnMouseOver(boolean highlightWhenMouseOver) {
        this.highlighter.setHighlightOnMouseOver(highlightWhenMouseOver);
    }

    public void setContent(File file) throws IOException {
        this.setContent(SyntaxHighlighter.readFile(file));
    }

    public void setContent(String content) {
        this.content = content;
        this.highlighter.setContent(content);
        this.render();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readFile(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("argument 'file' cannot be null");
        }
        byte[] buffer = new byte[(int)file.length()];
        FileInputStream fileIn = null;
        try {
            fileIn = new FileInputStream(file);
            fileIn.read(buffer);
        }
        finally {
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new String(buffer);
    }
}

