/*
 * Decompiled with CFR 0.152.
 */
package syntaxhighlight;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.text.SimpleAttributeSet;
import syntaxhighlight.JTextComponentRowHeader;
import syntaxhighlight.Style;

public class Theme {
    private static final Logger LOG = Logger.getLogger(Theme.class.getName());
    protected Font font = new Font("Consolas", 0, 12);
    protected Color background = Color.white;
    protected Color highlightedBackground = Color.gray;
    protected Color gutterText = Color.black;
    protected Color gutterBorderColor = new Color(184, 184, 184);
    protected int gutterBorderWidth = 3;
    protected Font gutterTextFont = new Font("Consolas", 0, 12);
    protected int gutterTextPaddingLeft = 7;
    protected int gutterTextPaddingRight = 7;
    protected Style plain = new Style();
    protected Map<String, Style> styles = new HashMap<String, Style>();

    public void setTheme(JTextComponentRowHeader rowHeader) {
        rowHeader.setBackground(this.background);
        rowHeader.setHighlightedColor(this.background);
        rowHeader.setForeground(this.gutterText);
        rowHeader.setBorderColor(this.gutterBorderColor);
        rowHeader.setBorderWidth(this.gutterBorderWidth);
        rowHeader.setFont(this.gutterTextFont);
        rowHeader.setPaddingLeft(this.gutterTextPaddingLeft);
        rowHeader.setPaddingRight(this.gutterTextPaddingRight);
    }

    public void setPlain(Style plain) {
        if (plain == null) {
            throw new NullPointerException("argument 'plain' cannot be null");
        }
        this.plain = plain;
    }

    public Style getPlain() {
        return this.plain;
    }

    public SimpleAttributeSet getStylesAttributeSet(String styleKeys) {
        if (styleKeys.indexOf(32) != -1) {
            String[] _keys;
            SimpleAttributeSet returnAttributeSet = new SimpleAttributeSet();
            for (String _key : _keys = styleKeys.split(" ")) {
                returnAttributeSet.addAttributes(this.getStyle(_key).getAttributeSet());
            }
            return returnAttributeSet;
        }
        return this.getStyle(styleKeys).getAttributeSet();
    }

    public Style addStyle(String styleKey, Style style) {
        return this.styles.put(styleKey, style);
    }

    public Style removeStyle(String styleKey) {
        return this.styles.remove(styleKey);
    }

    public Style getStyle(String key) {
        Style returnStyle = this.styles.get(key);
        return returnStyle != null ? returnStyle : this.plain;
    }

    public Map<String, Style> getStyles() {
        return new HashMap<String, Style>(this.styles);
    }

    public void clearStyles() {
        this.styles.clear();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new NullPointerException("argument 'font' cannot be null");
        }
        this.font = font;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        if (background == null) {
            throw new NullPointerException("argument 'background' cannot be null");
        }
        this.background = background;
    }

    public Color getHighlightedBackground() {
        return this.highlightedBackground;
    }

    public void setHighlightedBackground(Color highlightedBackground) {
        if (highlightedBackground == null) {
            throw new NullPointerException("argument 'highlightedBackground' cannot be null");
        }
        this.highlightedBackground = highlightedBackground;
    }

    public Color getGutterText() {
        return this.gutterText;
    }

    public void setGutterText(Color gutterText) {
        if (gutterText == null) {
            throw new NullPointerException("argument 'gutterText' cannot be null");
        }
        this.gutterText = gutterText;
    }

    public Color getGutterBorderColor() {
        return this.gutterBorderColor;
    }

    public void setGutterBorderColor(Color gutterBorderColor) {
        if (gutterBorderColor == null) {
            throw new NullPointerException("argument 'gutterBorderColor' cannot be null");
        }
        this.gutterBorderColor = gutterBorderColor;
    }

    public int getGutterBorderWidth() {
        return this.gutterBorderWidth;
    }

    public void setGutterBorderWidth(int gutterBorderWidth) {
        this.gutterBorderWidth = gutterBorderWidth;
    }

    public Font getGutterTextFont() {
        return this.gutterTextFont;
    }

    public void setGutterTextFont(Font gutterTextFont) {
        if (gutterTextFont == null) {
            throw new NullPointerException("argument 'gutterTextFont' cannot be null");
        }
        this.gutterTextFont = gutterTextFont;
    }

    public int getGutterTextPaddingLeft() {
        return this.gutterTextPaddingLeft;
    }

    public void setGutterTextPaddingLeft(int gutterTextPaddingLeft) {
        this.gutterTextPaddingLeft = gutterTextPaddingLeft;
    }

    public int getGutterTextPaddingRight() {
        return this.gutterTextPaddingRight;
    }

    public void setGutterTextPaddingRight(int gutterTextPaddingRight) {
        this.gutterTextPaddingRight = gutterTextPaddingRight;
    }

    public Theme clone() {
        Theme object = null;
        try {
            object = (Theme)super.clone();
            object.styles = new HashMap<String, Style>();
            for (String key : this.styles.keySet()) {
                object.styles.put(key, this.styles.get(key).clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.getClass().getName());
        sb.append(": ");
        sb.append("font: ").append(this.getFont());
        sb.append("; ");
        sb.append("background: ").append(this.getBackground());
        sb.append("; ");
        sb.append("highlightedBackground: ").append(this.getHighlightedBackground());
        sb.append("; ");
        sb.append("gutterText: ").append(this.getGutterText());
        sb.append("; ");
        sb.append("gutterBorderColor: ").append(this.getGutterBorderColor());
        sb.append(", ");
        sb.append("gutterBorderWidth: ").append(this.getGutterBorderWidth());
        sb.append(", ");
        sb.append("gutterTextFont: ").append(this.getGutterTextFont());
        sb.append(", ");
        sb.append("gutterTextPaddingLeft: ").append(this.getGutterTextPaddingLeft());
        sb.append(", ");
        sb.append("gutterTextPaddingRight: ").append(this.getGutterTextPaddingRight());
        sb.append(", ");
        sb.append("styles: ");
        for (String _key : this.styles.keySet()) {
            sb.append(_key).append(":").append(this.styles.get(_key));
        }
        sb.append("]");
        return sb.toString();
    }
}

