/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.github.philippheuer.credentialmanager.CredentialManager;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.credentialmanager.identityprovider.OAuth2IdentityProvider;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.twitch4j.auth.providers.TwitchIdentityProvider;
import com.github.twitch4j.chat.ITwitchChat;
import com.github.twitch4j.chat.enums.CommandSource;
import com.github.twitch4j.chat.enums.NoticeTag;
import com.github.twitch4j.chat.enums.TMIConnectionState;
import com.github.twitch4j.chat.events.AbstractChannelEvent;
import com.github.twitch4j.chat.events.CommandEvent;
import com.github.twitch4j.chat.events.IRCEventHandler;
import com.github.twitch4j.chat.events.channel.ChannelJoinFailureEvent;
import com.github.twitch4j.chat.events.channel.ChannelMessageEvent;
import com.github.twitch4j.chat.events.channel.ChannelNoticeEvent;
import com.github.twitch4j.chat.events.channel.ChannelStateEvent;
import com.github.twitch4j.chat.events.channel.IRCMessageEvent;
import com.github.twitch4j.chat.events.channel.UserStateEvent;
import com.github.twitch4j.client.websocket.WebsocketConnection;
import com.github.twitch4j.client.websocket.domain.WebsocketConnectionState;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.util.BucketUtils;
import com.github.twitch4j.common.util.CryptoUtils;
import com.github.twitch4j.common.util.EscapeUtils;
import com.github.twitch4j.util.IBackoffStrategy;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchChat
implements ITwitchChat {
    private static final Logger log = LoggerFactory.getLogger(TwitchChat.class);
    public static final int REQUIRED_THREAD_COUNT = 2;
    private final EventManager eventManager;
    private final CredentialManager credentialManager;
    private final WebsocketConnection connection;
    private OAuth2Credential chatCredential;
    public static final String TWITCH_WEB_SOCKET_SERVER = "wss://irc-ws.chat.twitch.tv:443";
    public static final String FDGT_TEST_SOCKET_SERVER = "wss://irc.fdgt.dev";
    protected final boolean sendCredentialToThirdPartyHost;
    private final ReentrantLock channelCacheLock = new ReentrantLock();
    protected final Set<String> currentChannels = ConcurrentHashMap.newKeySet();
    protected final Map<String, String> channelIdToChannelName = new ConcurrentHashMap<String, String>();
    protected final Map<String, String> channelNameToChannelId = new ConcurrentHashMap<String, String>();
    protected final Bucket ircMessageBucket;
    protected final Bucket ircWhisperBucket;
    protected final Bucket ircJoinBucket;
    protected final Bucket ircAuthBucket;
    protected final Bandwidth perChannelRateLimit;
    protected final BlockingQueue<String> ircCommandQueue;
    protected final ScheduledFuture<?> queueThread;
    private final AtomicBoolean flushing = new AtomicBoolean();
    private final AtomicBoolean flushRequested = new AtomicBoolean();
    private final Runnable flushCommand;
    protected volatile boolean stopQueueThread = false;
    protected final Collection<String> botOwnerIds;
    protected final List<String> commandPrefixes;
    protected final ScheduledExecutorService taskExecutor;
    protected final long chatQueueTimeout;
    protected final boolean autoJoinOwnChannel;
    protected final boolean removeChannelOnJoinFailure;
    protected final boolean enableMembershipEvents;
    protected final int maxJoinRetries;
    protected final long chatJoinTimeout;
    protected final Cache<String, Integer> joinAttemptsByChannelName;
    protected final Cache<String, Bucket> bucketByChannelName;

    public TwitchChat(WebsocketConnection websocketConnection, EventManager eventManager, CredentialManager credentialManager, OAuth2Credential chatCredential, String baseUrl, boolean sendCredentialToThirdPartyHost, Collection<String> commandPrefixes, Integer chatQueueSize, Bucket ircMessageBucket, Bucket ircWhisperBucket, Bucket ircJoinBucket, Bucket ircAuthBucket, ScheduledThreadPoolExecutor taskExecutor, long chatQueueTimeout, ProxyConfig proxyConfig, boolean autoJoinOwnChannel, boolean enableMembershipEvents, Collection<String> botOwnerIds, boolean removeChannelOnJoinFailure, int maxJoinRetries, long chatJoinTimeout, int wsPingPeriod, IBackoffStrategy connectionBackoffStrategy, Bandwidth perChannelRateLimit) {
        this.eventManager = eventManager;
        this.credentialManager = credentialManager;
        this.chatCredential = chatCredential;
        this.sendCredentialToThirdPartyHost = sendCredentialToThirdPartyHost;
        this.commandPrefixes = new ArrayList<String>(commandPrefixes);
        this.botOwnerIds = botOwnerIds;
        this.ircCommandQueue = new ArrayBlockingQueue<String>(chatQueueSize, true);
        this.ircMessageBucket = ircMessageBucket;
        this.ircWhisperBucket = ircWhisperBucket;
        this.ircJoinBucket = ircJoinBucket;
        this.ircAuthBucket = ircAuthBucket;
        this.taskExecutor = taskExecutor;
        this.chatQueueTimeout = chatQueueTimeout;
        this.autoJoinOwnChannel = autoJoinOwnChannel;
        this.enableMembershipEvents = enableMembershipEvents;
        this.removeChannelOnJoinFailure = removeChannelOnJoinFailure;
        this.maxJoinRetries = maxJoinRetries;
        this.chatJoinTimeout = chatJoinTimeout;
        this.perChannelRateLimit = perChannelRateLimit;
        this.bucketByChannelName = Caffeine.newBuilder().expireAfterAccess(Math.max(perChannelRateLimit.getRefillPeriodNanos(), Duration.ofSeconds(30L).toNanos()), TimeUnit.NANOSECONDS).build();
        this.connection = websocketConnection == null ? new WebsocketConnection(spec -> {
            spec.baseUrl(baseUrl);
            spec.wsPingPeriod(wsPingPeriod);
            spec.onConnected(this::onConnected);
            spec.onTextMessage(this::onTextMessage);
            spec.onDisconnecting(this::onDisconnecting);
            spec.taskExecutor((ScheduledExecutorService)taskExecutor);
            spec.proxyConfig(proxyConfig);
            if (connectionBackoffStrategy != null) {
                spec.backoffStrategy(connectionBackoffStrategy);
            }
        }) : websocketConnection;
        if (this.chatCredential == null) {
            log.info("TwitchChat: No ChatAccount provided, Chat will be joined anonymously! Please look at the docs Twitch4J -> Chat if this is unintentional");
        } else if (this.chatCredential.getUserName() == null) {
            log.debug("TwitchChat: AccessToken does not contain any user information, fetching using the CredentialManager ...");
            Optional credential = ((OAuth2IdentityProvider)credentialManager.getOAuth2IdentityProviderByName("twitch").orElse(new TwitchIdentityProvider(null, null, null))).getAdditionalCredentialInformation(this.chatCredential);
            if (credential.isPresent()) {
                this.chatCredential = (OAuth2Credential)credential.get();
            } else {
                log.error("TwitchChat: Failed to get AccessToken Information, the token is probably not valid. Please check the docs Twitch4J -> Chat on how to obtain a valid token.");
            }
        }
        this.eventManager.getServiceMediator().addService("twitch4j-chat", (Object)this);
        IRCEventHandler ircEventHandler = new IRCEventHandler(this);
        this.connection.connect();
        this.flushCommand = () -> {
            if (this.flushing.getAndSet(true)) {
                return;
            }
            while (!this.stopQueueThread && this.connection.getConnectionState() == WebsocketConnectionState.CONNECTED) {
                String command = null;
                try {
                    command = (String)this.ircCommandQueue.poll();
                    if (command == null) break;
                    this.sendTextToWebSocket(command, false);
                    log.debug("Processed command from queue: [{}].", (Object)(command.startsWith("PASS") ? "***OAUTH TOKEN HIDDEN***" : command));
                }
                catch (Exception ex) {
                    log.error("Chat: Unexpected error in worker thread", (Throwable)ex);
                    if (command == null) break;
                    try {
                        this.ircCommandQueue.offer(command, this.chatQueueTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        log.error("Failed to reschedule command", (Throwable)e);
                    }
                    break;
                }
            }
            this.flushRequested.set(false);
            this.flushing.set(false);
        };
        this.queueThread = taskExecutor.scheduleAtFixedRate(this.flushCommand, 0L, this.chatQueueTimeout, TimeUnit.MILLISECONDS);
        log.debug("Started IRC Queue Worker");
        log.debug("Registering the following command triggers: {}", commandPrefixes);
        eventManager.onEvent("twitch4j-chat-command-trigger", ChannelMessageEvent.class, this::onChannelMessage);
        eventManager.onEvent(IRCMessageEvent.class, event -> {
            if ("ROOMSTATE".equalsIgnoreCase(event.getCommandType()) && event.getChannelId() != null) {
                this.channelCacheLock.lock();
                try {
                    event.getChannelName().map(String::toLowerCase).filter(this.currentChannels::contains).ifPresent(name -> {
                        String oldName = this.channelIdToChannelName.put(event.getChannelId(), (String)name);
                        if (!name.equals(oldName)) {
                            if (oldName != null) {
                                this.channelNameToChannelId.remove(oldName, event.getChannelId());
                            }
                            this.channelNameToChannelId.put((String)name, event.getChannelId());
                        }
                    });
                }
                finally {
                    this.channelCacheLock.unlock();
                }
            }
        });
        if (maxJoinRetries > 0) {
            long initialWait = Math.max(chatJoinTimeout, 0L);
            this.joinAttemptsByChannelName = Caffeine.newBuilder().expireAfterWrite(initialWait, TimeUnit.MILLISECONDS).scheduler(Scheduler.forScheduledExecutorService((ScheduledExecutorService)taskExecutor)).evictionListener((name, attempts, cause) -> {
                if (cause == RemovalCause.EXPIRED && name != null && attempts != null) {
                    if (attempts < maxJoinRetries) {
                        taskExecutor.schedule(() -> {
                            if (this.currentChannels.contains(name)) {
                                this.issueJoin((String)name, attempts + 1);
                            }
                        }, initialWait * (1L << Math.min(attempts, 16) + 1), TimeUnit.MILLISECONDS);
                    } else if (removeChannelOnJoinFailure && this.removeCurrentChannel((String)name)) {
                        eventManager.publish((Object)new ChannelJoinFailureEvent((String)name, ChannelJoinFailureEvent.Reason.RETRIES_EXHAUSTED));
                    } else {
                        log.warn("Chat connection exhausted retries when attempting to join channel: {}", name);
                    }
                }
            }).build();
        } else {
            this.joinAttemptsByChannelName = Caffeine.newBuilder().maximumSize(0L).build();
        }
        Consumer<AbstractChannelEvent> joinListener = e -> this.joinAttemptsByChannelName.invalidate((Object)e.getChannel().getName().toLowerCase());
        eventManager.onEvent(ChannelStateEvent.class, joinListener::accept);
        eventManager.onEvent(ChannelNoticeEvent.class, joinListener::accept);
        eventManager.onEvent(UserStateEvent.class, joinListener::accept);
        EnumSet<NoticeTag> banNotices = EnumSet.of(NoticeTag.MSG_BANNED, NoticeTag.MSG_CHANNEL_SUSPENDED, NoticeTag.TOS_BAN);
        eventManager.onEvent(ChannelNoticeEvent.class, e -> {
            String name = e.getChannel().getName();
            NoticeTag type = e.getType();
            if (removeChannelOnJoinFailure && banNotices.contains((Object)type) && this.removeCurrentChannel(name)) {
                ChannelJoinFailureEvent.Reason reason = type == NoticeTag.MSG_BANNED ? ChannelJoinFailureEvent.Reason.USER_BANNED : ChannelJoinFailureEvent.Reason.CHANNEL_SUSPENDED;
                eventManager.publish((Object)new ChannelJoinFailureEvent(name, reason));
            }
        });
    }

    protected void onConnected() {
        String userName;
        String baseUrl = this.connection.getConfig().baseUrl();
        log.info("Connecting to Twitch IRC {}", (Object)baseUrl);
        this.sendTextToWebSocket("CAP REQ :twitch.tv/tags twitch.tv/commands" + (this.enableMembershipEvents ? " twitch.tv/membership" : ""), true);
        this.sendTextToWebSocket("CAP END", true);
        if (this.chatCredential != null) {
            boolean sendRealPass = this.sendCredentialToThirdPartyHost || baseUrl.equalsIgnoreCase(TWITCH_WEB_SOCKET_SERVER) || baseUrl.equalsIgnoreCase(TWITCH_WEB_SOCKET_SERVER.substring(0, TWITCH_WEB_SOCKET_SERVER.length() - 4));
            this.sendTextToWebSocket(String.format("pass oauth:%s", sendRealPass ? this.chatCredential.getAccessToken() : CryptoUtils.generateNonce((int)30)), true);
            userName = String.valueOf(this.chatCredential.getUserName()).toLowerCase();
        } else {
            userName = "justinfan" + ThreadLocalRandom.current().nextInt(100000);
        }
        this.sendTextToWebSocket(String.format("nick %s", userName), true);
        for (String channel : this.currentChannels) {
            this.issueJoin(channel);
        }
        if (this.chatCredential != null && this.chatCredential.getUserName() != null) {
            if (this.autoJoinOwnChannel && !this.currentChannels.contains(userName)) {
                this.joinChannel(userName);
            }
        } else {
            log.warn("Chat: The whispers feature is currently not available because the provided credential does not hold information about the user. Please check the documentation on how to pass the token to the credentialManager where it will be enriched with the required information.");
        }
    }

    protected void onTextMessage(String text) {
        Arrays.asList(text.replace("\n\r", "\n").replace("\r", "\n").split("\n")).forEach(message -> {
            if (!message.equals("")) {
                log.trace("Received WebSocketMessage: " + message);
                if (message.startsWith(":tmi.twitch.tv 410") || message.startsWith(":tmi.twitch.tv CAP * NAK")) {
                    log.error("Failed to acquire requested IRC capabilities!");
                } else if (message.startsWith(":tmi.twitch.tv CAP * ACK :")) {
                    List<String> capabilities = Arrays.asList(message.substring(":tmi.twitch.tv CAP * ACK :".length()).split(" "));
                    capabilities.forEach(cap -> log.debug("Acquired chat capability: " + cap));
                } else if (message.equalsIgnoreCase("PING :tmi.twitch.tv")) {
                    this.sendTextToWebSocket("PONG :tmi.twitch.tv", true);
                    log.debug("Responding to PING request!");
                } else if (message.equalsIgnoreCase(":tmi.twitch.tv NOTICE * :Login authentication failed")) {
                    log.error("Invalid IRC Credentials. Login failed!");
                } else {
                    try {
                        IRCMessageEvent event = new IRCMessageEvent((String)message, this.channelIdToChannelName, this.channelNameToChannelId, this.botOwnerIds);
                        if (event.isValid().booleanValue()) {
                            this.eventManager.publish((Object)event);
                        } else {
                            log.trace("Can't parse {}", (Object)event.getRawMessage());
                        }
                    }
                    catch (Exception ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        });
    }

    protected void onDisconnecting() {
        this.sendTextToWebSocket("QUIT", true);
    }

    public void connect() {
        if ((WebsocketConnectionState.DISCONNECTED.equals((Object)this.connection.getConnectionState()) || WebsocketConnectionState.RECONNECTING.equals((Object)this.connection.getConnectionState())) && this.chatCredential != null) {
            this.ircAuthBucket.asBlocking().consumeUninterruptibly(1L);
        }
        this.connection.connect();
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public void reconnect() {
        this.connection.reconnect();
    }

    protected void sendCommand(String command, String ... args) {
        this.sendRaw(String.format("%s %s", command.toUpperCase(), String.join((CharSequence)" ", args)));
    }

    public boolean sendRaw(String command) {
        return BucketUtils.scheduleAgainstBucket((Bucket)this.ircMessageBucket, (ScheduledExecutorService)this.taskExecutor, () -> this.queueCommand(command)) != null;
    }

    private void queueCommand(String command) {
        if (!this.ircCommandQueue.offer(command)) {
            try {
                this.ircCommandQueue.offer(command, this.chatQueueTimeout, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                log.warn("Chat: unable to add command to full queue", (Throwable)e);
                return;
            }
        }
        if (!this.flushing.get() && !this.flushRequested.getAndSet(true)) {
            this.taskExecutor.schedule(this.flushCommand, this.chatQueueTimeout / 20L, TimeUnit.MILLISECONDS);
        }
    }

    private boolean sendTextToWebSocket(String command, Boolean consumeToken) {
        if (!this.connection.getConnectionState().equals((Object)WebsocketConnectionState.CONNECTED) && !this.connection.getConnectionState().equals((Object)WebsocketConnectionState.CONNECTING)) {
            return false;
        }
        if (consumeToken.booleanValue()) {
            this.ircMessageBucket.tryConsume(1L);
        }
        this.connection.sendText(command);
        return true;
    }

    @Override
    public void joinChannel(String channelName) {
        String lowerChannelName = channelName.toLowerCase();
        this.channelCacheLock.lock();
        try {
            if (this.currentChannels.add(lowerChannelName)) {
                this.issueJoin(lowerChannelName);
                log.debug("Joining Channel [{}].", (Object)lowerChannelName);
            } else {
                log.warn("Already joined channel {}", (Object)channelName);
            }
        }
        finally {
            this.channelCacheLock.unlock();
        }
    }

    private void issueJoin(String channelName) {
        this.issueJoin(channelName, 0);
    }

    protected void issueJoin(String channelName, int attempts) {
        BucketUtils.scheduleAgainstBucket((Bucket)this.ircJoinBucket, (ScheduledExecutorService)this.taskExecutor, () -> {
            String name = channelName.toLowerCase();
            this.queueCommand("JOIN #" + name);
            this.joinAttemptsByChannelName.asMap().merge(name, attempts, Math::max);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean leaveChannel(String channelName) {
        String lowerChannelName = channelName.toLowerCase();
        this.channelCacheLock.lock();
        try {
            if (this.currentChannels.remove(lowerChannelName)) {
                this.issuePart(lowerChannelName);
                log.debug("Leaving Channel [{}].", (Object)lowerChannelName);
                String cachedId = this.channelNameToChannelId.remove(lowerChannelName);
                if (cachedId != null) {
                    this.channelIdToChannelName.remove(cachedId);
                }
                boolean bl = true;
                return bl;
            }
            log.warn("Already left channel {}", (Object)channelName);
            boolean bl = false;
            return bl;
        }
        finally {
            this.channelCacheLock.unlock();
        }
    }

    private void issuePart(String channelName) {
        BucketUtils.scheduleAgainstBucket((Bucket)this.ircJoinBucket, (ScheduledExecutorService)this.taskExecutor, () -> this.queueCommand("PART #" + channelName.toLowerCase()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeCurrentChannel(String channelName) {
        this.channelCacheLock.lock();
        try {
            if (this.currentChannels.remove(channelName)) {
                String id = this.channelNameToChannelId.remove(channelName);
                if (id != null) {
                    this.channelIdToChannelName.remove(id);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.channelCacheLock.unlock();
        }
    }

    @Override
    public boolean sendMessage(String channel, String message, Map<String, Object> tags) {
        StringBuilder sb = new StringBuilder();
        if (tags != null && !tags.isEmpty()) {
            sb.append('@');
            tags.forEach((k, v) -> sb.append((String)k).append('=').append(EscapeUtils.escapeTagValue((Object)v)).append(';'));
            sb.setCharAt(sb.length() - 1, ' ');
        }
        sb.append("PRIVMSG #").append(channel.toLowerCase()).append(" :").append(message);
        log.debug("Adding message for channel [{}] with content [{}] to the queue.", (Object)channel.toLowerCase(), (Object)message);
        return BucketUtils.scheduleAgainstBucket((Bucket)this.getChannelMessageBucket(channel), (ScheduledExecutorService)this.taskExecutor, () -> this.sendRaw(sb.toString())) != null;
    }

    public void sendPrivateMessage(String targetUser, String message) {
        log.debug("Adding private message for user [{}] with content [{}] to the queue.", (Object)targetUser, (Object)message);
        BucketUtils.scheduleAgainstBucket((Bucket)this.ircWhisperBucket, (ScheduledExecutorService)this.taskExecutor, () -> this.queueCommand(String.format("PRIVMSG #%s :/w %s %s", this.chatCredential.getUserName().toLowerCase(), targetUser, message)));
    }

    private void onChannelMessage(ChannelMessageEvent event) {
        Optional<Object> prefix = Optional.empty();
        Optional<Object> commandWithoutPrefix = Optional.empty();
        for (String commandPrefix : this.commandPrefixes) {
            if (!event.getMessage().startsWith(commandPrefix)) continue;
            prefix = Optional.of(commandPrefix);
            commandWithoutPrefix = Optional.of(event.getMessage().substring(commandPrefix.length()));
            break;
        }
        if (commandWithoutPrefix.isPresent()) {
            log.debug("Detected a command in channel {} with content: {}", (Object)event.getChannel().getName(), commandWithoutPrefix.get());
            this.eventManager.publish((Object)new CommandEvent(CommandSource.CHANNEL, event.getChannel().getName(), event.getUser(), (String)prefix.get(), (String)commandWithoutPrefix.get(), event.getPermissions()));
        }
    }

    @Override
    public void close() {
        this.stopQueueThread = true;
        this.queueThread.cancel(false);
        this.disconnect();
    }

    @Override
    public boolean isChannelJoined(String channelName) {
        return this.currentChannels.contains(channelName.toLowerCase());
    }

    @Deprecated
    public List<String> getCurrentChannels() {
        return Collections.unmodifiableList(new ArrayList<String>(this.currentChannels));
    }

    @Override
    public Set<String> getChannels() {
        return Collections.unmodifiableSet(this.currentChannels);
    }

    @Override
    public Map<String, String> getChannelIdToChannelName() {
        return Collections.unmodifiableMap(this.channelIdToChannelName);
    }

    @Override
    public Map<String, String> getChannelNameToChannelId() {
        return Collections.unmodifiableMap(this.channelNameToChannelId);
    }

    @Override
    public long getLatency() {
        return this.connection.getLatency();
    }

    public WebsocketConnectionState getState() {
        return this.connection.getConnectionState();
    }

    @Deprecated
    public TMIConnectionState getConnectionState() {
        switch (this.connection.getConnectionState()) {
            case DISCONNECTING: {
                return TMIConnectionState.DISCONNECTING;
            }
            case RECONNECTING: {
                return TMIConnectionState.RECONNECTING;
            }
            case CONNECTING: {
                return TMIConnectionState.CONNECTING;
            }
            case CONNECTED: {
                return TMIConnectionState.CONNECTED;
            }
        }
        return TMIConnectionState.DISCONNECTED;
    }

    private Bucket getChannelMessageBucket(@NotNull String channelName) {
        return (Bucket)this.bucketByChannelName.get((Object)channelName.toLowerCase(), k -> BucketUtils.createBucket((Bandwidth)this.perChannelRateLimit));
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    public CredentialManager getCredentialManager() {
        return this.credentialManager;
    }
}

