/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat;

import com.github.philippheuer.credentialmanager.CredentialManager;
import com.github.philippheuer.credentialmanager.CredentialManagerBuilder;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.credentialmanager.identityprovider.OAuth2IdentityProvider;
import com.github.philippheuer.events4j.api.service.IEventHandler;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.philippheuer.events4j.simple.SimpleEventHandler;
import com.github.twitch4j.auth.providers.TwitchIdentityProvider;
import com.github.twitch4j.chat.TwitchChat;
import com.github.twitch4j.chat.util.TwitchChatLimitHelper;
import com.github.twitch4j.client.websocket.WebsocketConnection;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.config.Twitch4JGlobal;
import com.github.twitch4j.common.enums.TwitchLimitType;
import com.github.twitch4j.common.util.BucketUtils;
import com.github.twitch4j.common.util.EventManagerUtils;
import com.github.twitch4j.common.util.ThreadUtils;
import com.github.twitch4j.common.util.TwitchLimitRegistry;
import com.github.twitch4j.util.IBackoffStrategy;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchChatBuilder {
    private static final Logger log = LoggerFactory.getLogger(TwitchChatBuilder.class);
    private WebsocketConnection websocketConnection = null;
    private String clientId = Twitch4JGlobal.clientId;
    private String clientSecret = Twitch4JGlobal.clientSecret;
    private Integer requestQueueSize = -1;
    private EventManager eventManager;
    private Class<? extends IEventHandler> defaultEventHandler = SimpleEventHandler.class;
    private CredentialManager credentialManager = CredentialManagerBuilder.builder().build();
    private OAuth2Credential chatAccount;
    private String baseUrl = "wss://irc-ws.chat.twitch.tv:443";
    private boolean sendCredentialToThirdPartyHost = false;
    protected Collection<String> botOwnerIds = new HashSet<String>();
    protected Set<String> commandPrefixes = new HashSet<String>();
    protected Integer chatQueueSize = 200;
    protected Bandwidth chatRateLimit = TwitchChatLimitHelper.USER_MESSAGE_LIMIT;
    protected Bandwidth[] whisperRateLimit = TwitchChatLimitHelper.USER_WHISPER_LIMIT.toArray(new Bandwidth[2]);
    protected Bandwidth joinRateLimit = TwitchChatLimitHelper.USER_JOIN_LIMIT;
    protected Bandwidth authRateLimit = TwitchChatLimitHelper.USER_AUTH_LIMIT;
    protected Bandwidth perChannelRateLimit = TwitchChatLimitHelper.MOD_MESSAGE_LIMIT.withId("per-channel-limit");
    protected Bucket ircMessageBucket = null;
    protected Bucket ircWhisperBucket = null;
    protected Bucket ircJoinBucket = null;
    protected Bucket ircAuthBucket = null;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = null;
    private long chatQueueTimeout = 1000L;
    private ProxyConfig proxyConfig = null;
    private boolean autoJoinOwnChannel = true;
    private boolean enableMembershipEvents = true;
    private boolean removeChannelOnJoinFailure = false;
    private int maxJoinRetries = 7;
    private long chatJoinTimeout = 2000L;
    private int wsPingPeriod = 15000;
    private IBackoffStrategy connectionBackoffStrategy = null;

    public static TwitchChatBuilder builder() {
        return new TwitchChatBuilder();
    }

    public TwitchChat build() {
        String userId;
        log.debug("TwitchChat: Initializing ErrorTracking ...");
        if (this.scheduledThreadPoolExecutor == null) {
            this.scheduledThreadPoolExecutor = ThreadUtils.getDefaultScheduledThreadPoolExecutor((String)("twitch4j-chat-" + RandomStringUtils.random((int)4, (boolean)true, (boolean)true)), (Integer)2);
        }
        this.eventManager = EventManagerUtils.validateOrInitializeEventManager((EventManager)this.eventManager, this.defaultEventHandler);
        if (this.credentialManager == null) {
            this.credentialManager = CredentialManagerBuilder.builder().build();
        }
        if (this.chatAccount == null) {
            userId = null;
        } else {
            if (StringUtils.isEmpty((CharSequence)this.chatAccount.getUserId())) {
                this.chatAccount = ((OAuth2IdentityProvider)this.credentialManager.getOAuth2IdentityProviderByName("twitch").orElse(new TwitchIdentityProvider(null, null, null))).getAdditionalCredentialInformation(this.chatAccount).orElse(this.chatAccount);
            }
            userId = (String)StringUtils.defaultIfEmpty((CharSequence)this.chatAccount.getUserId(), null);
        }
        if (this.ircMessageBucket == null) {
            Bucket bucket = this.ircMessageBucket = userId == null ? BucketUtils.createBucket((Bandwidth)this.chatRateLimit) : TwitchLimitRegistry.getInstance().getOrInitializeBucket(userId, TwitchLimitType.CHAT_MESSAGE_LIMIT, Collections.singletonList(this.chatRateLimit));
        }
        if (this.ircWhisperBucket == null) {
            Bucket bucket = this.ircWhisperBucket = userId == null ? BucketUtils.createBucket((Bandwidth[])this.whisperRateLimit) : TwitchLimitRegistry.getInstance().getOrInitializeBucket(userId, TwitchLimitType.CHAT_WHISPER_LIMIT, Arrays.asList(this.whisperRateLimit));
        }
        if (this.ircJoinBucket == null) {
            Bucket bucket = this.ircJoinBucket = userId == null ? BucketUtils.createBucket((Bandwidth)this.joinRateLimit) : TwitchLimitRegistry.getInstance().getOrInitializeBucket(userId, TwitchLimitType.CHAT_JOIN_LIMIT, Collections.singletonList(this.joinRateLimit));
        }
        if (this.ircAuthBucket == null) {
            Bucket bucket = this.ircAuthBucket = userId == null ? BucketUtils.createBucket((Bandwidth)this.authRateLimit) : TwitchLimitRegistry.getInstance().getOrInitializeBucket(userId, TwitchLimitType.CHAT_AUTH_LIMIT, Collections.singletonList(this.authRateLimit));
        }
        if (this.perChannelRateLimit == null) {
            this.perChannelRateLimit = this.chatRateLimit;
        }
        log.debug("TwitchChat: Initializing Module ...");
        return new TwitchChat(this.websocketConnection, this.eventManager, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.commandPrefixes, this.chatQueueSize, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.botOwnerIds, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy, this.perChannelRateLimit);
    }

    public TwitchChatBuilder withCommandTrigger(String commandTrigger) {
        this.commandPrefixes.add(commandTrigger);
        return this;
    }

    public TwitchChatBuilder withCommandTriggers(Collection<String> commandTrigger) {
        this.commandPrefixes.addAll(commandTrigger);
        return this;
    }

    public TwitchChatBuilder withBotOwnerId(String userId) {
        this.botOwnerIds.add(userId);
        return this;
    }

    public TwitchChatBuilder withBotOwnerIds(Collection<String> botOwnerIds) {
        this.botOwnerIds.addAll(botOwnerIds);
        return this;
    }

    public WebsocketConnection getWebsocketConnection() {
        return this.websocketConnection;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Integer getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public Class<? extends IEventHandler> getDefaultEventHandler() {
        return this.defaultEventHandler;
    }

    public CredentialManager getCredentialManager() {
        return this.credentialManager;
    }

    public OAuth2Credential getChatAccount() {
        return this.chatAccount;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isSendCredentialToThirdPartyHost() {
        return this.sendCredentialToThirdPartyHost;
    }

    public Collection<String> getBotOwnerIds() {
        return this.botOwnerIds;
    }

    public Set<String> getCommandPrefixes() {
        return this.commandPrefixes;
    }

    public Integer getChatQueueSize() {
        return this.chatQueueSize;
    }

    public Bandwidth getChatRateLimit() {
        return this.chatRateLimit;
    }

    public Bandwidth[] getWhisperRateLimit() {
        return this.whisperRateLimit;
    }

    public Bandwidth getJoinRateLimit() {
        return this.joinRateLimit;
    }

    public Bandwidth getAuthRateLimit() {
        return this.authRateLimit;
    }

    public Bandwidth getPerChannelRateLimit() {
        return this.perChannelRateLimit;
    }

    public Bucket getIrcMessageBucket() {
        return this.ircMessageBucket;
    }

    public Bucket getIrcWhisperBucket() {
        return this.ircWhisperBucket;
    }

    public Bucket getIrcJoinBucket() {
        return this.ircJoinBucket;
    }

    public Bucket getIrcAuthBucket() {
        return this.ircAuthBucket;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    public long getChatQueueTimeout() {
        return this.chatQueueTimeout;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public boolean isAutoJoinOwnChannel() {
        return this.autoJoinOwnChannel;
    }

    public boolean isEnableMembershipEvents() {
        return this.enableMembershipEvents;
    }

    public boolean isRemoveChannelOnJoinFailure() {
        return this.removeChannelOnJoinFailure;
    }

    public int getMaxJoinRetries() {
        return this.maxJoinRetries;
    }

    public long getChatJoinTimeout() {
        return this.chatJoinTimeout;
    }

    public int getWsPingPeriod() {
        return this.wsPingPeriod;
    }

    public IBackoffStrategy getConnectionBackoffStrategy() {
        return this.connectionBackoffStrategy;
    }

    private TwitchChatBuilder() {
    }

    private TwitchChatBuilder(WebsocketConnection websocketConnection, String clientId, String clientSecret, Integer requestQueueSize, EventManager eventManager, Class<? extends IEventHandler> defaultEventHandler, CredentialManager credentialManager, OAuth2Credential chatAccount, String baseUrl, boolean sendCredentialToThirdPartyHost, Collection<String> botOwnerIds, Set<String> commandPrefixes, Integer chatQueueSize, Bandwidth chatRateLimit, Bandwidth[] whisperRateLimit, Bandwidth joinRateLimit, Bandwidth authRateLimit, Bandwidth perChannelRateLimit, Bucket ircMessageBucket, Bucket ircWhisperBucket, Bucket ircJoinBucket, Bucket ircAuthBucket, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long chatQueueTimeout, ProxyConfig proxyConfig, boolean autoJoinOwnChannel, boolean enableMembershipEvents, boolean removeChannelOnJoinFailure, int maxJoinRetries, long chatJoinTimeout, int wsPingPeriod, IBackoffStrategy connectionBackoffStrategy) {
        this.websocketConnection = websocketConnection;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.requestQueueSize = requestQueueSize;
        this.eventManager = eventManager;
        this.defaultEventHandler = defaultEventHandler;
        this.credentialManager = credentialManager;
        this.chatAccount = chatAccount;
        this.baseUrl = baseUrl;
        this.sendCredentialToThirdPartyHost = sendCredentialToThirdPartyHost;
        this.botOwnerIds = botOwnerIds;
        this.commandPrefixes = commandPrefixes;
        this.chatQueueSize = chatQueueSize;
        this.chatRateLimit = chatRateLimit;
        this.whisperRateLimit = whisperRateLimit;
        this.joinRateLimit = joinRateLimit;
        this.authRateLimit = authRateLimit;
        this.perChannelRateLimit = perChannelRateLimit;
        this.ircMessageBucket = ircMessageBucket;
        this.ircWhisperBucket = ircWhisperBucket;
        this.ircJoinBucket = ircJoinBucket;
        this.ircAuthBucket = ircAuthBucket;
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        this.chatQueueTimeout = chatQueueTimeout;
        this.proxyConfig = proxyConfig;
        this.autoJoinOwnChannel = autoJoinOwnChannel;
        this.enableMembershipEvents = enableMembershipEvents;
        this.removeChannelOnJoinFailure = removeChannelOnJoinFailure;
        this.maxJoinRetries = maxJoinRetries;
        this.chatJoinTimeout = chatJoinTimeout;
        this.wsPingPeriod = wsPingPeriod;
        this.connectionBackoffStrategy = connectionBackoffStrategy;
    }

    protected TwitchChatBuilder withWebsocketConnection(WebsocketConnection websocketConnection) {
        return this.websocketConnection == websocketConnection ? this : new TwitchChatBuilder(websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withClientId(String clientId) {
        return this.clientId == clientId ? this : new TwitchChatBuilder(this.websocketConnection, clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withClientSecret(String clientSecret) {
        return this.clientSecret == clientSecret ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withRequestQueueSize(Integer requestQueueSize) {
        return this.requestQueueSize == requestQueueSize ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withEventManager(EventManager eventManager) {
        return this.eventManager == eventManager ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withDefaultEventHandler(Class<? extends IEventHandler> defaultEventHandler) {
        return this.defaultEventHandler == defaultEventHandler ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withCredentialManager(CredentialManager credentialManager) {
        return this.credentialManager == credentialManager ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withChatAccount(OAuth2Credential chatAccount) {
        return this.chatAccount == chatAccount ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withBaseUrl(String baseUrl) {
        return this.baseUrl == baseUrl ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withSendCredentialToThirdPartyHost(boolean sendCredentialToThirdPartyHost) {
        return this.sendCredentialToThirdPartyHost == sendCredentialToThirdPartyHost ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder setBotOwnerIds(Collection<String> botOwnerIds) {
        this.botOwnerIds = botOwnerIds;
        return this;
    }

    public TwitchChatBuilder setCommandPrefixes(Set<String> commandPrefixes) {
        this.commandPrefixes = commandPrefixes;
        return this;
    }

    public TwitchChatBuilder withChatQueueSize(Integer chatQueueSize) {
        return this.chatQueueSize == chatQueueSize ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withChatRateLimit(Bandwidth chatRateLimit) {
        return this.chatRateLimit == chatRateLimit ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withWhisperRateLimit(Bandwidth[] whisperRateLimit) {
        return this.whisperRateLimit == whisperRateLimit ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withJoinRateLimit(Bandwidth joinRateLimit) {
        return this.joinRateLimit == joinRateLimit ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withAuthRateLimit(Bandwidth authRateLimit) {
        return this.authRateLimit == authRateLimit ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withPerChannelRateLimit(Bandwidth perChannelRateLimit) {
        return this.perChannelRateLimit == perChannelRateLimit ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withIrcMessageBucket(Bucket ircMessageBucket) {
        return this.ircMessageBucket == ircMessageBucket ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withIrcWhisperBucket(Bucket ircWhisperBucket) {
        return this.ircWhisperBucket == ircWhisperBucket ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withIrcJoinBucket(Bucket ircJoinBucket) {
        return this.ircJoinBucket == ircJoinBucket ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withIrcAuthBucket(Bucket ircAuthBucket) {
        return this.ircAuthBucket == ircAuthBucket ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        return this.scheduledThreadPoolExecutor == scheduledThreadPoolExecutor ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withChatQueueTimeout(long chatQueueTimeout) {
        return this.chatQueueTimeout == chatQueueTimeout ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withProxyConfig(ProxyConfig proxyConfig) {
        return this.proxyConfig == proxyConfig ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withAutoJoinOwnChannel(boolean autoJoinOwnChannel) {
        return this.autoJoinOwnChannel == autoJoinOwnChannel ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withEnableMembershipEvents(boolean enableMembershipEvents) {
        return this.enableMembershipEvents == enableMembershipEvents ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withRemoveChannelOnJoinFailure(boolean removeChannelOnJoinFailure) {
        return this.removeChannelOnJoinFailure == removeChannelOnJoinFailure ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withMaxJoinRetries(int maxJoinRetries) {
        return this.maxJoinRetries == maxJoinRetries ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withChatJoinTimeout(long chatJoinTimeout) {
        return this.chatJoinTimeout == chatJoinTimeout ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withWsPingPeriod(int wsPingPeriod) {
        return this.wsPingPeriod == wsPingPeriod ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, wsPingPeriod, this.connectionBackoffStrategy);
    }

    public TwitchChatBuilder withConnectionBackoffStrategy(IBackoffStrategy connectionBackoffStrategy) {
        return this.connectionBackoffStrategy == connectionBackoffStrategy ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, connectionBackoffStrategy);
    }
}

