/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events.channel;

import com.github.twitch4j.chat.events.AbstractChannelEvent;
import com.github.twitch4j.chat.events.channel.IRCMessageEvent;
import com.github.twitch4j.common.enums.CommandPermission;
import com.github.twitch4j.common.events.domain.EventUser;
import com.github.twitch4j.common.util.DonationAmount;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CharityDonationEvent
extends AbstractChannelEvent {
    @NotNull
    private final IRCMessageEvent messageEvent;
    private final String userId;
    private final String userLogin;
    private final String userName;
    private final Set<CommandPermission> badges;
    private final String charityName;
    private final DonationAmount amount;
    private final String systemMessage;

    public CharityDonationEvent(@NotNull IRCMessageEvent rawEvent) {
        super(rawEvent.getChannel());
        this.messageEvent = rawEvent;
        this.userId = rawEvent.getTagValue("user-id").orElse(null);
        this.userLogin = rawEvent.getTagValue("login").orElse(null);
        this.userName = rawEvent.getTagValue("display-name").orElse(this.userLogin);
        this.badges = rawEvent.getClientPermissions();
        this.charityName = rawEvent.getTagValue("msg-param-charity-name").orElse(null);
        Long amount = Long.parseLong(rawEvent.getTags().get("msg-param-donation-amount"));
        String currency = rawEvent.getTagValue("msg-param-donation-currency").orElse("USD");
        Integer decimals = Integer.parseInt(rawEvent.getTags().getOrDefault("msg-param-exponent", "2"));
        this.amount = new DonationAmount(amount, decimals, currency);
        this.systemMessage = rawEvent.getTagValue("system-msg").orElseGet(() -> String.format("%s donated %s %s to support %s", this.userName, currency, this.amount.getParsedValue().toPlainString(), this.charityName));
    }

    public EventUser getUser() {
        return new EventUser(this.userId, this.userLogin);
    }

    @NotNull
    public IRCMessageEvent getMessageEvent() {
        return this.messageEvent;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserLogin() {
        return this.userLogin;
    }

    public String getUserName() {
        return this.userName;
    }

    public Set<CommandPermission> getBadges() {
        return this.badges;
    }

    public String getCharityName() {
        return this.charityName;
    }

    public DonationAmount getAmount() {
        return this.amount;
    }

    public String getSystemMessage() {
        return this.systemMessage;
    }

    @Override
    public String toString() {
        return "CharityDonationEvent(messageEvent=" + (Object)((Object)this.getMessageEvent()) + ", userId=" + this.getUserId() + ", userLogin=" + this.getUserLogin() + ", userName=" + this.getUserName() + ", badges=" + this.getBadges() + ", charityName=" + this.getCharityName() + ", amount=" + this.getAmount() + ", systemMessage=" + this.getSystemMessage() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CharityDonationEvent)) {
            return false;
        }
        CharityDonationEvent other = (CharityDonationEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$userLogin = this.getUserLogin();
        String other$userLogin = other.getUserLogin();
        if (this$userLogin == null ? other$userLogin != null : !this$userLogin.equals(other$userLogin)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        Set<CommandPermission> this$badges = this.getBadges();
        Set<CommandPermission> other$badges = other.getBadges();
        if (this$badges == null ? other$badges != null : !((Object)this$badges).equals(other$badges)) {
            return false;
        }
        String this$charityName = this.getCharityName();
        String other$charityName = other.getCharityName();
        if (this$charityName == null ? other$charityName != null : !this$charityName.equals(other$charityName)) {
            return false;
        }
        DonationAmount this$amount = this.getAmount();
        DonationAmount other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        String this$systemMessage = this.getSystemMessage();
        String other$systemMessage = other.getSystemMessage();
        return !(this$systemMessage == null ? other$systemMessage != null : !this$systemMessage.equals(other$systemMessage));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CharityDonationEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $userLogin = this.getUserLogin();
        result = result * 59 + ($userLogin == null ? 43 : $userLogin.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        Set<CommandPermission> $badges = this.getBadges();
        result = result * 59 + ($badges == null ? 43 : ((Object)$badges).hashCode());
        String $charityName = this.getCharityName();
        result = result * 59 + ($charityName == null ? 43 : $charityName.hashCode());
        DonationAmount $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        String $systemMessage = this.getSystemMessage();
        result = result * 59 + ($systemMessage == null ? 43 : $systemMessage.hashCode());
        return result;
    }
}

