/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.chat.ITwitchChat;
import com.github.twitch4j.chat.TwitchChat;
import com.github.twitch4j.chat.TwitchChatBuilder;
import com.github.twitch4j.chat.events.channel.ChannelNoticeEvent;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.pool.TwitchModuleConnectionPool;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.commons.lang3.RandomStringUtils;

public class TwitchChatConnectionPool
extends TwitchModuleConnectionPool<TwitchChat, String, String, Boolean, TwitchChatBuilder>
implements ITwitchChat {
    private final String threadPrefix = "twitch4j-pool-" + RandomStringUtils.random((int)4, (boolean)true, (boolean)true) + "-chat-";
    @NonNull
    protected final Supplier<OAuth2Credential> chatAccount;
    protected final boolean automaticallyPartOnBan;

    @Override
    public boolean sendMessage(String channel, String message) {
        return this.sendMessage(channel, channel, message);
    }

    public boolean sendMessage(String channelToIdentifyChatInstance, String targetChannel, String message) {
        if (channelToIdentifyChatInstance == null) {
            return false;
        }
        TwitchChat chat = (TwitchChat)this.subscriptions.get(channelToIdentifyChatInstance.toLowerCase());
        if (chat == null) {
            return false;
        }
        if (targetChannel != null) {
            chat.sendMessage(targetChannel, message);
        } else {
            chat.sendRaw(message);
        }
        return true;
    }

    public boolean sendPrivateMessage(String channelToIdentifyChatInstance, String toChannel, String message) {
        TwitchChat chat;
        if (channelToIdentifyChatInstance == null || (chat = (TwitchChat)this.subscriptions.get(channelToIdentifyChatInstance.toLowerCase())) == null) {
            return false;
        }
        chat.sendPrivateMessage(toChannel, message);
        return true;
    }

    public String subscribe(String s) {
        return s != null ? (String)super.subscribe((Object)s.toLowerCase()) : null;
    }

    @Override
    public void joinChannel(String channelName) {
        this.subscribe(channelName);
    }

    public Boolean unsubscribe(String s) {
        return (Boolean)super.unsubscribe((Object)(s != null ? s.toLowerCase() : null));
    }

    @Override
    public boolean leaveChannel(String channelName) {
        Boolean b = this.unsubscribe(channelName);
        return b != null && b != false;
    }

    @Override
    public boolean isChannelJoined(String channelName) {
        return this.subscriptions.containsKey(channelName.toLowerCase());
    }

    @Override
    public Set<String> getChannels() {
        return Collections.unmodifiableSet(this.subscriptions.keySet());
    }

    protected String handleSubscription(TwitchChat twitchChat, String s) {
        if (twitchChat == null) {
            return null;
        }
        twitchChat.joinChannel(s);
        return s;
    }

    protected String handleDuplicateSubscription(TwitchChat twitchChat, TwitchChat old, String s) {
        return twitchChat != null && twitchChat != old && twitchChat.leaveChannel(s) ? s : null;
    }

    protected Boolean handleUnsubscription(TwitchChat twitchChat, String s) {
        return twitchChat != null ? Boolean.valueOf(twitchChat.leaveChannel(s)) : null;
    }

    protected String getRequestFromSubscription(String s) {
        return s;
    }

    protected int getSubscriptionSize(String s) {
        return 1;
    }

    protected TwitchChat createConnection() {
        TwitchChat chat = ((TwitchChatBuilder)this.advancedConfiguration.apply(TwitchChatBuilder.builder().withChatAccount(this.chatAccount.get()).withEventManager(this.getConnectionEventManager()).withScheduledThreadPoolExecutor(this.getExecutor(this.threadPrefix + RandomStringUtils.random((int)4, (boolean)true, (boolean)true), 2)).withProxyConfig((ProxyConfig)this.proxyConfig.get()).withAutoJoinOwnChannel(false))).build();
        chat.getEventManager().onEvent("twitch4j-chat-pool-ban-tracker", ChannelNoticeEvent.class, e -> {
            if (this.automaticallyPartOnBan && "msg_banned".equals(e.getMsgId())) {
                this.unsubscribe(e.getChannel().getName());
            }
        });
        return chat;
    }

    protected void disposeConnection(TwitchChat connection) {
        connection.close();
    }

    private static Supplier<OAuth2Credential> $default$chatAccount() {
        return () -> null;
    }

    private static boolean $default$automaticallyPartOnBan() {
        return false;
    }

    protected TwitchChatConnectionPool(TwitchChatConnectionPoolBuilder<?, ?> b) {
        super(b);
        this.chatAccount = ((TwitchChatConnectionPoolBuilder)b).chatAccount$set ? ((TwitchChatConnectionPoolBuilder)b).chatAccount$value : TwitchChatConnectionPool.$default$chatAccount();
        if (this.chatAccount == null) {
            throw new NullPointerException("chatAccount is marked non-null but is null");
        }
        this.automaticallyPartOnBan = ((TwitchChatConnectionPoolBuilder)b).automaticallyPartOnBan$set ? ((TwitchChatConnectionPoolBuilder)b).automaticallyPartOnBan$value : TwitchChatConnectionPool.$default$automaticallyPartOnBan();
    }

    public static TwitchChatConnectionPoolBuilder<?, ?> builder() {
        return new TwitchChatConnectionPoolBuilderImpl();
    }

    private static final class TwitchChatConnectionPoolBuilderImpl
    extends TwitchChatConnectionPoolBuilder<TwitchChatConnectionPool, TwitchChatConnectionPoolBuilderImpl> {
        private TwitchChatConnectionPoolBuilderImpl() {
        }

        @Override
        protected TwitchChatConnectionPoolBuilderImpl self() {
            return this;
        }

        @Override
        public TwitchChatConnectionPool build() {
            return new TwitchChatConnectionPool(this);
        }
    }

    public static abstract class TwitchChatConnectionPoolBuilder<C extends TwitchChatConnectionPool, B extends TwitchChatConnectionPoolBuilder<C, B>>
    extends TwitchModuleConnectionPool.TwitchModuleConnectionPoolBuilder<TwitchChat, String, String, Boolean, TwitchChatBuilder, C, B> {
        private boolean chatAccount$set;
        private Supplier<OAuth2Credential> chatAccount$value;
        private boolean automaticallyPartOnBan$set;
        private boolean automaticallyPartOnBan$value;

        protected abstract B self();

        public abstract C build();

        public B chatAccount(@NonNull Supplier<OAuth2Credential> chatAccount) {
            if (chatAccount == null) {
                throw new NullPointerException("chatAccount is marked non-null but is null");
            }
            this.chatAccount$value = chatAccount;
            this.chatAccount$set = true;
            return (B)this.self();
        }

        public B automaticallyPartOnBan(boolean automaticallyPartOnBan) {
            this.automaticallyPartOnBan$value = automaticallyPartOnBan;
            this.automaticallyPartOnBan$set = true;
            return (B)this.self();
        }

        public String toString() {
            return "TwitchChatConnectionPool.TwitchChatConnectionPoolBuilder(super=" + super.toString() + ", chatAccount$value=" + this.chatAccount$value + ", automaticallyPartOnBan$value=" + this.automaticallyPartOnBan$value + ")";
        }
    }
}

