/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events.channel;

import com.github.twitch4j.chat.events.TwitchEvent;
import com.github.twitch4j.chat.flag.AutoModFlag;
import com.github.twitch4j.chat.flag.FlagParser;
import com.github.twitch4j.common.enums.CommandPermission;
import com.github.twitch4j.common.events.domain.EventChannel;
import com.github.twitch4j.common.events.domain.EventUser;
import com.github.twitch4j.common.util.EscapeUtils;
import com.github.twitch4j.common.util.TwitchUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class IRCMessageEvent
extends TwitchEvent {
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("^(?:@(?<tags>.+?) )?(?<clientName>.+?)(?: (?<command>[A-Z0-9]+) )(?:#(?<channel>.*?) ?)?(?<payload>[:\\-\\+](?<message>.+))?$");
    private static final Pattern WHISPER_PATTERN = Pattern.compile("^(?:@(?<tags>.+?) )?:(?<clientName>.+?)!.+?(?: (?<command>[A-Z0-9]+) )(?:(?<channel>.*?) ?)??(?<payload>[:\\-\\+](?<message>.+))$");
    private static final Pattern CLIENT_PATTERN = Pattern.compile("^:(.*?)!(.*?)@(.*?).tmi.twitch.tv$");
    public static final String NONCE_TAG_NAME = "client-nonce";
    private Map<String, String> tags = new HashMap<String, String>();
    private Map<String, Object> rawTags = new HashMap<String, Object>();
    private Map<String, String> badges = new HashMap<String, String>();
    private Map<String, String> badgeInfo = new HashMap<String, String>();
    private Optional<String> clientName = Optional.empty();
    private String commandType = "UNKNOWN";
    private String channelId;
    private Optional<String> channelName = Optional.empty();
    private Optional<String> message = Optional.empty();
    private Optional<String> payload = Optional.empty();
    private final Set<CommandPermission> clientPermissions = EnumSet.noneOf(CommandPermission.class);
    private final AtomicReference<Object> flags = new AtomicReference();
    private final String rawMessage;

    public IRCMessageEvent(String rawMessage, Map<String, String> channelIdToChannelName, Map<String, String> channelNameToChannelId, Collection<String> botOwnerIds) {
        this.rawMessage = rawMessage;
        this.parseRawMessage();
        if (this.tags.containsKey("room-id")) {
            this.channelId = this.tags.get("room-id");
        }
        if (!this.channelName.isPresent() && this.channelId != null) {
            this.channelName = Optional.ofNullable(channelIdToChannelName.get(this.channelId));
        } else if (this.channelName.isPresent() && this.channelId == null) {
            this.channelId = channelNameToChannelId.get(this.channelName.get());
        }
        this.getClientPermissions().addAll(TwitchUtils.getPermissionsFromTags(this.getRawTags(), this.badges, (String)(botOwnerIds != null ? this.getUserId() : null), botOwnerIds));
        this.getTagValue("badge-info").map(TwitchUtils::parseBadges).ifPresent(map -> this.badgeInfo.putAll((Map<String, String>)map));
    }

    public Boolean isValid() {
        return !this.getCommandType().equals("UNKNOWN");
    }

    private void parseRawMessage() {
        Matcher matcher = MESSAGE_PATTERN.matcher(this.rawMessage);
        if (matcher.matches()) {
            this.tags = this.parseTags(matcher.group("tags"));
            this.rawTags = this.parseTags(matcher.group("tags"));
            this.clientName = this.parseClientName(matcher.group("clientName"));
            this.commandType = matcher.group("command");
            this.channelName = Optional.ofNullable(matcher.group("channel"));
            this.message = Optional.ofNullable(matcher.group("message"));
            this.payload = Optional.ofNullable(matcher.group("payload"));
            return;
        }
        Matcher matcherPM = WHISPER_PATTERN.matcher(this.rawMessage);
        if (matcherPM.matches()) {
            this.tags = this.parseTags(matcherPM.group("tags"));
            this.rawTags = this.parseTags(matcherPM.group("tags"));
            this.clientName = this.parseClientName(matcherPM.group("clientName"));
            this.commandType = matcherPM.group("command");
            this.channelName = Optional.ofNullable(matcherPM.group("channel"));
            this.message = Optional.ofNullable(matcherPM.group("message"));
            this.payload = Optional.ofNullable(matcherPM.group("payload"));
        }
    }

    public Map parseTags(String raw) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)raw)) {
            return map;
        }
        for (String tag : raw.split(";")) {
            String[] val = tag.split("=");
            String key = val[0];
            String value = val.length > 1 ? val[1] : null;
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }

    public Optional<String> parseClientName(String raw) {
        if (raw.equals(":tmi.twitch.tv") || raw.equals(":jtv")) {
            return Optional.empty();
        }
        Matcher matcher = CLIENT_PATTERN.matcher(raw);
        if (matcher.matches()) {
            return Optional.ofNullable(matcher.group(1));
        }
        return Optional.ofNullable(raw);
    }

    public String getUserId() {
        if (this.tags.containsKey("user-id")) {
            return this.tags.get("user-id");
        }
        return null;
    }

    public String getUserName() {
        if (this.tags.containsKey("login")) {
            return this.tags.get("login");
        }
        return this.getClientName().orElse(null);
    }

    public String getTargetUserId() {
        if (this.tags.containsKey("target-user-id")) {
            return this.tags.get("target-user-id");
        }
        return null;
    }

    public Optional<String> getMessageId() {
        return this.getTagValue("id");
    }

    public Optional<String> getNonce() {
        return this.getTagValue(NONCE_TAG_NAME);
    }

    public OptionalInt getSubscriberMonths() {
        String monthsStr = this.badgeInfo.get("subscriber");
        if (monthsStr != null) {
            try {
                return OptionalInt.of(Integer.parseInt(monthsStr));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return OptionalInt.empty();
    }

    public OptionalInt getSubscriptionTier() {
        String subscriber = this.badges.get("subscriber");
        if (subscriber != null) {
            try {
                return OptionalInt.of(Math.max(Integer.parseInt(subscriber) / 1000, 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return OptionalInt.empty();
    }

    public Optional<String> getTagValue(String tagName) {
        return Optional.ofNullable(this.tags.get(tagName)).filter(StringUtils::isNotBlank).map(EscapeUtils::unescapeTagValue);
    }

    public EventUser getUser() {
        if (this.getUserId() != null || this.getUserName() != null) {
            return new EventUser(this.getUserId(), this.getUserName());
        }
        return null;
    }

    public EventUser getTargetUser() {
        return new EventUser(this.getTargetUserId(), this.getCommandType().equalsIgnoreCase("CLEARCHAT") ? this.getMessage().get() : null);
    }

    public EventChannel getChannel() {
        return new EventChannel(this.getChannelId(), this.getChannelName().get());
    }

    @Override
    public String toString() {
        return "IRCMessageEvent(tags=" + this.getTags() + ", rawTags=" + this.getRawTags() + ", badges=" + this.getBadges() + ", badgeInfo=" + this.getBadgeInfo() + ", clientName=" + this.getClientName() + ", commandType=" + this.getCommandType() + ", channelId=" + this.getChannelId() + ", channelName=" + this.getChannelName() + ", message=" + this.getMessage() + ", payload=" + this.getPayload() + ", clientPermissions=" + this.getClientPermissions() + ", flags=" + this.getFlags() + ", rawMessage=" + this.getRawMessage() + ")";
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Map<String, Object> getRawTags() {
        return this.rawTags;
    }

    public Map<String, String> getBadges() {
        return this.badges;
    }

    public Map<String, String> getBadgeInfo() {
        return this.badgeInfo;
    }

    public Optional<String> getClientName() {
        return this.clientName;
    }

    public String getCommandType() {
        return this.commandType;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public Optional<String> getChannelName() {
        return this.channelName;
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    public Optional<String> getPayload() {
        return this.payload;
    }

    public Set<CommandPermission> getClientPermissions() {
        return this.clientPermissions;
    }

    public String getRawMessage() {
        return this.rawMessage;
    }

    private void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    private void setRawTags(Map<String, Object> rawTags) {
        this.rawTags = rawTags;
    }

    private void setBadges(Map<String, String> badges) {
        this.badges = badges;
    }

    private void setBadgeInfo(Map<String, String> badgeInfo) {
        this.badgeInfo = badgeInfo;
    }

    private void setClientName(Optional<String> clientName) {
        this.clientName = clientName;
    }

    private void setCommandType(String commandType) {
        this.commandType = commandType;
    }

    private void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    private void setChannelName(Optional<String> channelName) {
        this.channelName = channelName;
    }

    private void setMessage(Optional<String> message) {
        this.message = message;
    }

    private void setPayload(Optional<String> payload) {
        this.payload = payload;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IRCMessageEvent)) {
            return false;
        }
        IRCMessageEvent other = (IRCMessageEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Map<String, Object> this$rawTags = this.getRawTags();
        Map<String, Object> other$rawTags = other.getRawTags();
        if (this$rawTags == null ? other$rawTags != null : !((Object)this$rawTags).equals(other$rawTags)) {
            return false;
        }
        Map<String, String> this$badges = this.getBadges();
        Map<String, String> other$badges = other.getBadges();
        if (this$badges == null ? other$badges != null : !((Object)this$badges).equals(other$badges)) {
            return false;
        }
        Map<String, String> this$badgeInfo = this.getBadgeInfo();
        Map<String, String> other$badgeInfo = other.getBadgeInfo();
        if (this$badgeInfo == null ? other$badgeInfo != null : !((Object)this$badgeInfo).equals(other$badgeInfo)) {
            return false;
        }
        Optional<String> this$clientName = this.getClientName();
        Optional<String> other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !((Object)this$clientName).equals(other$clientName)) {
            return false;
        }
        String this$commandType = this.getCommandType();
        String other$commandType = other.getCommandType();
        if (this$commandType == null ? other$commandType != null : !this$commandType.equals(other$commandType)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        Optional<String> this$channelName = this.getChannelName();
        Optional<String> other$channelName = other.getChannelName();
        if (this$channelName == null ? other$channelName != null : !((Object)this$channelName).equals(other$channelName)) {
            return false;
        }
        Optional<String> this$message = this.getMessage();
        Optional<String> other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        Optional<String> this$payload = this.getPayload();
        Optional<String> other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload)) {
            return false;
        }
        Set<CommandPermission> this$clientPermissions = this.getClientPermissions();
        Set<CommandPermission> other$clientPermissions = other.getClientPermissions();
        if (this$clientPermissions == null ? other$clientPermissions != null : !((Object)this$clientPermissions).equals(other$clientPermissions)) {
            return false;
        }
        List<AutoModFlag> this$flags = this.getFlags();
        List<AutoModFlag> other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        String this$rawMessage = this.getRawMessage();
        String other$rawMessage = other.getRawMessage();
        return !(this$rawMessage == null ? other$rawMessage != null : !this$rawMessage.equals(other$rawMessage));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IRCMessageEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Map<String, Object> $rawTags = this.getRawTags();
        result = result * 59 + ($rawTags == null ? 43 : ((Object)$rawTags).hashCode());
        Map<String, String> $badges = this.getBadges();
        result = result * 59 + ($badges == null ? 43 : ((Object)$badges).hashCode());
        Map<String, String> $badgeInfo = this.getBadgeInfo();
        result = result * 59 + ($badgeInfo == null ? 43 : ((Object)$badgeInfo).hashCode());
        Optional<String> $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : ((Object)$clientName).hashCode());
        String $commandType = this.getCommandType();
        result = result * 59 + ($commandType == null ? 43 : $commandType.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        Optional<String> $channelName = this.getChannelName();
        result = result * 59 + ($channelName == null ? 43 : ((Object)$channelName).hashCode());
        Optional<String> $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        Optional<String> $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
        Set<CommandPermission> $clientPermissions = this.getClientPermissions();
        result = result * 59 + ($clientPermissions == null ? 43 : ((Object)$clientPermissions).hashCode());
        List<AutoModFlag> $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        String $rawMessage = this.getRawMessage();
        result = result * 59 + ($rawMessage == null ? 43 : $rawMessage.hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AutoModFlag> getFlags() {
        Object value = this.flags.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.flags;
            synchronized (atomicReference) {
                value = this.flags.get();
                if (value == null) {
                    List<AutoModFlag> actualValue = FlagParser.parseFlags(this);
                    value = actualValue == null ? this.flags : actualValue;
                    this.flags.set(value);
                }
            }
        }
        return (List)(value == this.flags ? null : value);
    }
}

