/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events;

import com.github.twitch4j.chat.events.AbstractChannelEvent;
import com.github.twitch4j.chat.events.channel.IRCMessageEvent;
import com.github.twitch4j.chat.events.channel.MirrorableEvent;
import com.github.twitch4j.chat.events.channel.ReplyableEvent;
import com.github.twitch4j.chat.flag.AutoModFlag;
import com.github.twitch4j.common.enums.CommandPermission;
import com.github.twitch4j.common.events.domain.EventChannel;
import com.github.twitch4j.common.events.domain.EventUser;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;

public abstract class AbstractChannelMessageEvent
extends AbstractChannelEvent
implements ReplyableEvent,
MirrorableEvent {
    private IRCMessageEvent messageEvent;
    private EventUser user;
    private String message;
    private int subscriberMonths;
    private int subscriptionTier;
    private final AtomicReference<Object> nonce = new AtomicReference();

    @ApiStatus.Internal
    public AbstractChannelMessageEvent(EventChannel channel, IRCMessageEvent messageEvent, EventUser user, String message) {
        super(channel);
        this.messageEvent = messageEvent;
        this.user = user;
        this.message = message;
        this.subscriberMonths = messageEvent.getSubscriberMonths().orElse(0);
        this.subscriptionTier = messageEvent.getSubscriptionTier().orElse(0);
    }

    public Set<CommandPermission> getPermissions() {
        return this.messageEvent.getClientPermissions();
    }

    public List<AutoModFlag> getFlags() {
        return this.getMessageEvent().getFlags();
    }

    @Override
    @Generated
    public IRCMessageEvent getMessageEvent() {
        return this.messageEvent;
    }

    @Generated
    public EventUser getUser() {
        return this.user;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public int getSubscriberMonths() {
        return this.subscriberMonths;
    }

    @Generated
    public int getSubscriptionTier() {
        return this.subscriptionTier;
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractChannelMessageEvent(messageEvent=" + (Object)((Object)this.getMessageEvent()) + ", user=" + this.getUser() + ", message=" + this.getMessage() + ", subscriberMonths=" + this.getSubscriberMonths() + ", subscriptionTier=" + this.getSubscriptionTier() + ", nonce=" + this.getNonce() + ")";
    }

    @Generated
    private void setMessageEvent(IRCMessageEvent messageEvent) {
        this.messageEvent = messageEvent;
    }

    @Generated
    private void setUser(EventUser user) {
        this.user = user;
    }

    @Generated
    private void setMessage(String message) {
        this.message = message;
    }

    @Generated
    private void setSubscriberMonths(int subscriberMonths) {
        this.subscriberMonths = subscriberMonths;
    }

    @Generated
    private void setSubscriptionTier(int subscriptionTier) {
        this.subscriptionTier = subscriptionTier;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractChannelMessageEvent)) {
            return false;
        }
        AbstractChannelMessageEvent other = (AbstractChannelMessageEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSubscriberMonths() != other.getSubscriberMonths()) {
            return false;
        }
        if (this.getSubscriptionTier() != other.getSubscriptionTier()) {
            return false;
        }
        IRCMessageEvent this$messageEvent = this.getMessageEvent();
        IRCMessageEvent other$messageEvent = other.getMessageEvent();
        if (this$messageEvent == null ? other$messageEvent != null : !((Object)((Object)this$messageEvent)).equals((Object)other$messageEvent)) {
            return false;
        }
        EventUser this$user = this.getUser();
        EventUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$nonce = this.getNonce();
        String other$nonce = other.getNonce();
        return !(this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractChannelMessageEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSubscriberMonths();
        result = result * 59 + this.getSubscriptionTier();
        IRCMessageEvent $messageEvent = this.getMessageEvent();
        result = result * 59 + ($messageEvent == null ? 43 : ((Object)((Object)$messageEvent)).hashCode());
        EventUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public String getNonce() {
        Object $value = this.nonce.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.nonce;
            synchronized (atomicReference) {
                $value = this.nonce.get();
                if ($value == null) {
                    String actualValue = this.getMessageEvent().getNonce().orElse(null);
                    $value = actualValue == null ? this.nonce : actualValue;
                    this.nonce.set($value);
                }
            }
        }
        return (String)($value == this.nonce ? null : $value);
    }
}

