/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.util;

import com.github.twitch4j.common.enums.CommandPermission;
import com.github.twitch4j.common.events.domain.EventUser;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class TwitchUtils {
    public static final EventUser ANONYMOUS_GIFTER = new EventUser("274598607", "ananonymousgifter");
    public static final EventUser ANONYMOUS_CHEERER = new EventUser("407665396", "ananonymouscheerer");

    public static Set<CommandPermission> getPermissionsFromTags(Map<String, Object> tags) {
        return TwitchUtils.getPermissionsFromTags(tags, new HashMap<String, String>());
    }

    public static Set<CommandPermission> getPermissionsFromTags(@NonNull Map<String, Object> tags, @NonNull Map<String, String> badges) {
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (badges == null) {
            throw new NullPointerException("badges is marked non-null but is null");
        }
        return TwitchUtils.getPermissionsFromTags(tags, badges, null, null);
    }

    public static Set<CommandPermission> getPermissionsFromTags(@NonNull Map<String, Object> tags, @NonNull Map<String, String> badges, String userId, Collection<String> botOwnerIds) {
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (badges == null) {
            throw new NullPointerException("badges is marked non-null but is null");
        }
        EnumSet<CommandPermission> permissionSet = EnumSet.of(CommandPermission.EVERYONE);
        if (tags.containsKey("badges")) {
            String hypeBadge;
            if (tags.get("badges") instanceof String) {
                badges.putAll(TwitchUtils.parseBadges((String)tags.get("badges")));
            } else {
                List badgeList = (List)tags.get("badges");
                if (badgeList != null) {
                    badgeList.forEach(badge -> badges.put((String)badge.get("id"), "1"));
                }
            }
            if (badges.containsKey("broadcaster")) {
                permissionSet.add(CommandPermission.BROADCASTER);
                permissionSet.add(CommandPermission.MODERATOR);
            }
            if (badges.containsKey("premium") || badges.containsKey("turbo")) {
                permissionSet.add(CommandPermission.PRIME_TURBO);
            }
            if (badges.containsKey("moderator")) {
                permissionSet.add(CommandPermission.MODERATOR);
            }
            if (badges.containsKey("partner") || badges.containsKey("ambassador")) {
                permissionSet.add(CommandPermission.PARTNER);
            }
            if (badges.containsKey("vip")) {
                permissionSet.add(CommandPermission.VIP);
            }
            if (badges.containsKey("turbo")) {
                permissionSet.add(CommandPermission.PRIME_TURBO);
            }
            if (badges.containsKey("staff") || badges.containsKey("admin")) {
                permissionSet.add(CommandPermission.TWITCHSTAFF);
            }
            if (badges.containsKey("subscriber")) {
                permissionSet.add(CommandPermission.SUBSCRIBER);
            }
            if (badges.containsKey("sub-gifter") || badges.containsKey("sub-gift-leader")) {
                permissionSet.add(CommandPermission.SUBGIFTER);
            }
            if (badges.containsKey("bits") || badges.containsKey("bits-leader") || badges.containsKey("anonymous-cheerer")) {
                permissionSet.add(CommandPermission.BITS_CHEERER);
            }
            if (badges.containsKey("founder")) {
                permissionSet.add(CommandPermission.FOUNDER);
                permissionSet.add(CommandPermission.SUBSCRIBER);
            }
            if ("1".equals(hypeBadge = badges.get("hype-train"))) {
                permissionSet.add(CommandPermission.CURRENT_HYPE_TRAIN_CONDUCTOR);
            } else if ("2".equals(hypeBadge)) {
                permissionSet.add(CommandPermission.FORMER_HYPE_TRAIN_CONDUCTOR);
            }
            String predictionBadge = badges.get("predictions");
            if (StringUtils.isNotEmpty((CharSequence)predictionBadge)) {
                char first = predictionBadge.charAt(0);
                if (first == 'b') {
                    permissionSet.add(CommandPermission.PREDICTIONS_BLUE);
                } else if (first == 'p') {
                    permissionSet.add(CommandPermission.PREDICTIONS_PINK);
                }
            }
            if (badges.containsKey("no_audio")) {
                permissionSet.add(CommandPermission.NO_AUDIO);
            }
            if (badges.containsKey("no_video")) {
                permissionSet.add(CommandPermission.NO_VIDEO);
            }
            if (badges.containsKey("moments")) {
                permissionSet.add(CommandPermission.MOMENTS);
            }
            if (badges.containsKey("artist-badge")) {
                permissionSet.add(CommandPermission.ARTIST);
            }
        }
        if (userId != null && botOwnerIds != null && botOwnerIds.contains(userId)) {
            permissionSet.add(CommandPermission.OWNER);
        }
        return permissionSet;
    }

    public static Map<String, String> parseBadges(String raw) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)raw)) {
            return map;
        }
        raw = raw.replace("\\s", " ");
        for (String tag : raw.split(",")) {
            String[] val = tag.split("/");
            String key = val[0];
            String value = val.length > 1 ? val[1] : null;
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }
}

