/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.util;

import com.github.twitch4j.common.enums.TwitchLimitType;
import com.github.twitch4j.common.util.BucketUtils;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.TokensInheritanceStrategy;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public enum TwitchLimitRegistry {
    INSTANCE;

    private final Map<String, Map<TwitchLimitType, Bucket>> limits = new ConcurrentHashMap<String, Map<TwitchLimitType, Bucket>>();

    public void setLimit(@NonNull String userId, @NonNull TwitchLimitType limitType, @NonNull List<Bandwidth> limit) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (limitType == null) {
            throw new NullPointerException("limitType is marked non-null but is null");
        }
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        this.getBucketsByUser(userId).compute(limitType, (l, bucket) -> {
            if (bucket != null) {
                bucket.replaceConfiguration(new BucketConfiguration(limit), TokensInheritanceStrategy.AS_IS);
                return bucket;
            }
            return BucketUtils.createBucket(limit);
        });
    }

    public boolean invalidateLimitsByUserId(String userId) {
        return this.limits.remove(userId) != null;
    }

    public boolean invalidateLimit(String userId, TwitchLimitType limitType) {
        return this.limits.getOrDefault(userId, Collections.emptyMap()).remove((Object)limitType) != null;
    }

    @NonNull
    public Optional<Bucket> getBucket(@NonNull String userId, @NonNull TwitchLimitType limitType) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (limitType == null) {
            throw new NullPointerException("limitType is marked non-null but is null");
        }
        return Optional.ofNullable(this.limits.get(userId)).map(buckets -> (Bucket)buckets.get((Object)limitType));
    }

    @NonNull
    public Bucket getOrInitializeBucket(@NonNull String userId, @NonNull TwitchLimitType limitType, @NonNull List<Bandwidth> limit) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (limitType == null) {
            throw new NullPointerException("limitType is marked non-null but is null");
        }
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.getBucketsByUser(userId).computeIfAbsent(limitType, l -> BucketUtils.createBucket(limit));
    }

    private Map<TwitchLimitType, Bucket> getBucketsByUser(String userId) {
        return this.limits.computeIfAbsent(userId, s -> Collections.synchronizedMap(new EnumMap(TwitchLimitType.class)));
    }

    @NonNull
    public static TwitchLimitRegistry getInstance() {
        return INSTANCE;
    }
}

