/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.feign.interceptor;

import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonContentTypeHeaderInterceptor
implements RequestInterceptor {
    private static final Set<String> methodsWithBody = Stream.of(Request.HttpMethod.POST.name(), Request.HttpMethod.PATCH.name(), Request.HttpMethod.PUT.name()).collect(Collectors.toSet());

    public void apply(RequestTemplate t) {
        if (!t.headers().containsKey("Content-Type") && !t.headers().containsKey("content-type") && methodsWithBody.contains(t.method())) {
            t.header("Content-Type", new String[]{"application/json"});
        }
    }
}

