/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.util;

import com.github.twitch4j.common.util.SneakySupplier;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BandwidthBuilder;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.local.LocalBucketBuilder;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.jetbrains.annotations.NotNull;

public class BucketUtils {
    public static Bandwidth simple(long capacity, Duration greedyRefillPeriod) {
        return BucketUtils.simple(capacity, greedyRefillPeriod, Bandwidth.UNDEFINED_ID);
    }

    public static Bandwidth simple(long capacity, Duration greedyRefillPeriod, String id) {
        return BandwidthBuilder.builder().capacity(capacity).refillGreedy(capacity, greedyRefillPeriod).id(id).build();
    }

    @NotNull
    public static Bucket createBucket(@NotNull Bandwidth limit) {
        return Bucket.builder().addLimit(limit).build();
    }

    @NotNull
    public static Bucket createBucket(Bandwidth ... limits) {
        LocalBucketBuilder builder = Bucket.builder();
        for (Bandwidth limit : limits) {
            builder.addLimit(limit);
        }
        return builder.build();
    }

    @NotNull
    public static Bucket createBucket(@NotNull Iterable<Bandwidth> limits) {
        LocalBucketBuilder builder = Bucket.builder();
        for (Bandwidth limit : limits) {
            builder.addLimit(limit);
        }
        return builder.build();
    }

    @NotNull
    public static <T> CompletableFuture<T> scheduleAgainstBucket(@NotNull Bucket bucket, @NotNull ScheduledExecutorService executor, @NotNull Callable<T> call) {
        if (bucket.tryConsume(1L)) {
            return CompletableFuture.supplyAsync(new SneakySupplier<T>(call));
        }
        return bucket.asScheduler().consume(1L, executor).thenApplyAsync(v -> new SneakySupplier(call).get());
    }

    @NotNull
    public static CompletableFuture<Void> scheduleAgainstBucket(@NotNull Bucket bucket, @NotNull ScheduledExecutorService executor, @NotNull Runnable action) {
        if (bucket.tryConsume(1L)) {
            return CompletableFuture.runAsync(action);
        }
        return bucket.asScheduler().consume(1L, executor).thenRunAsync(action);
    }
}

