/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.util;

import com.github.twitch4j.common.util.EscapeUtils;
import java.util.Map;
import lombok.NonNull;

public final class ChatReply {
    public static final String REPLY_MSG_ID_TAG_NAME = "reply-parent-msg-id";
    @NonNull
    private final String messageId;
    private final String messageBody;
    private final String userId;
    private final String userLogin;
    private final String displayName;

    public static ChatReply parse(Map<String, String> tags) {
        String msgId;
        if (tags == null || (msgId = tags.get(REPLY_MSG_ID_TAG_NAME)) == null || msgId.isEmpty()) {
            return null;
        }
        return new ChatReply(msgId, EscapeUtils.unescapeTagValue(tags.get("reply-parent-msg-body")), tags.get("reply-parent-user-id"), tags.get("reply-parent-user-login"), EscapeUtils.unescapeTagValue(tags.get("reply-parent-display-name")));
    }

    public ChatReply(@NonNull String messageId, String messageBody, String userId, String userLogin, String displayName) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.messageId = messageId;
        this.messageBody = messageBody;
        this.userId = userId;
        this.userLogin = userLogin;
        this.displayName = displayName;
    }

    @NonNull
    public String getMessageId() {
        return this.messageId;
    }

    public String getMessageBody() {
        return this.messageBody;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserLogin() {
        return this.userLogin;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatReply)) {
            return false;
        }
        ChatReply other = (ChatReply)o;
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$messageBody = this.getMessageBody();
        String other$messageBody = other.getMessageBody();
        if (this$messageBody == null ? other$messageBody != null : !this$messageBody.equals(other$messageBody)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$userLogin = this.getUserLogin();
        String other$userLogin = other.getUserLogin();
        if (this$userLogin == null ? other$userLogin != null : !this$userLogin.equals(other$userLogin)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $messageBody = this.getMessageBody();
        result = result * 59 + ($messageBody == null ? 43 : $messageBody.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $userLogin = this.getUserLogin();
        result = result * 59 + ($userLogin == null ? 43 : $userLogin.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        return result;
    }

    public String toString() {
        return "ChatReply(messageId=" + this.getMessageId() + ", messageBody=" + this.getMessageBody() + ", userId=" + this.getUserId() + ", userLogin=" + this.getUserLogin() + ", displayName=" + this.getDisplayName() + ")";
    }
}

