/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.util;

import org.apache.commons.lang3.StringUtils;

public class EscapeUtils {
    public static String escapeTagValue(Object value) {
        String unescapedString;
        if (value == null || (unescapedString = value.toString()) == null) {
            return "";
        }
        char[] unescaped = unescapedString.toCharArray();
        int n = unescaped.length;
        int firstReplacement = -1;
        for (int i = 0; i < n; ++i) {
            char c = unescaped[i];
            if (c != ';' && c != ' ' && c != '\\' && c != '\r' && c != '\n') continue;
            firstReplacement = i;
            break;
        }
        if (firstReplacement < 0) {
            return unescapedString;
        }
        StringBuilder sb = new StringBuilder(n + 1);
        sb.append(unescaped, 0, firstReplacement);
        block8: for (int i = firstReplacement; i < n; ++i) {
            char c = unescaped[i];
            switch (c) {
                case ';': {
                    sb.append("\\:");
                    continue block8;
                }
                case ' ': {
                    sb.append("\\s");
                    continue block8;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String unescapeTagValue(String value) {
        return StringUtils.replaceEach((String)value, (String[])new String[]{"\\:", "\\s", "\\\\", "\\r", "\\n"}, (String[])new String[]{";", " ", "\\", "\r", "\n"});
    }
}

