/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.eventsub.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.github.twitch4j.eventsub.domain.PredictionColor;
import com.github.twitch4j.eventsub.domain.Predictor;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=PredictionOutcomeBuilder.class)
public class PredictionOutcome {
    private String id;
    private String title;
    private PredictionColor color;
    private Integer users;
    private Long channelPoints;
    @Nullable
    private List<Predictor> topPredictors;

    public static PredictionOutcomeBuilder builder() {
        return new PredictionOutcomeBuilder();
    }

    public PredictionOutcomeBuilder toBuilder() {
        return new PredictionOutcomeBuilder().id(this.id).title(this.title).color(this.color).users(this.users).channelPoints(this.channelPoints).topPredictors(this.topPredictors);
    }

    public PredictionOutcome withId(String id) {
        return this.id == id ? this : new PredictionOutcome(id, this.title, this.color, this.users, this.channelPoints, this.topPredictors);
    }

    public PredictionOutcome withTitle(String title) {
        return this.title == title ? this : new PredictionOutcome(this.id, title, this.color, this.users, this.channelPoints, this.topPredictors);
    }

    public PredictionOutcome withColor(PredictionColor color) {
        return this.color == color ? this : new PredictionOutcome(this.id, this.title, color, this.users, this.channelPoints, this.topPredictors);
    }

    public PredictionOutcome withUsers(Integer users) {
        return this.users == users ? this : new PredictionOutcome(this.id, this.title, this.color, users, this.channelPoints, this.topPredictors);
    }

    public PredictionOutcome withChannelPoints(Long channelPoints) {
        return this.channelPoints == channelPoints ? this : new PredictionOutcome(this.id, this.title, this.color, this.users, channelPoints, this.topPredictors);
    }

    public PredictionOutcome withTopPredictors(@Nullable List<Predictor> topPredictors) {
        return this.topPredictors == topPredictors ? this : new PredictionOutcome(this.id, this.title, this.color, this.users, this.channelPoints, topPredictors);
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public PredictionColor getColor() {
        return this.color;
    }

    public Integer getUsers() {
        return this.users;
    }

    public Long getChannelPoints() {
        return this.channelPoints;
    }

    @Nullable
    public List<Predictor> getTopPredictors() {
        return this.topPredictors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PredictionOutcome)) {
            return false;
        }
        PredictionOutcome other = (PredictionOutcome)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$users = this.getUsers();
        Integer other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        Long this$channelPoints = this.getChannelPoints();
        Long other$channelPoints = other.getChannelPoints();
        if (this$channelPoints == null ? other$channelPoints != null : !((Object)this$channelPoints).equals(other$channelPoints)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        PredictionColor this$color = this.getColor();
        PredictionColor other$color = other.getColor();
        if (this$color == null ? other$color != null : !((Object)((Object)this$color)).equals((Object)other$color)) {
            return false;
        }
        List<Predictor> this$topPredictors = this.getTopPredictors();
        List<Predictor> other$topPredictors = other.getTopPredictors();
        return !(this$topPredictors == null ? other$topPredictors != null : !((Object)this$topPredictors).equals(other$topPredictors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PredictionOutcome;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        Long $channelPoints = this.getChannelPoints();
        result = result * 59 + ($channelPoints == null ? 43 : ((Object)$channelPoints).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        PredictionColor $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)((Object)$color)).hashCode());
        List<Predictor> $topPredictors = this.getTopPredictors();
        result = result * 59 + ($topPredictors == null ? 43 : ((Object)$topPredictors).hashCode());
        return result;
    }

    public String toString() {
        return "PredictionOutcome(id=" + this.getId() + ", title=" + this.getTitle() + ", color=" + (Object)((Object)this.getColor()) + ", users=" + this.getUsers() + ", channelPoints=" + this.getChannelPoints() + ", topPredictors=" + this.getTopPredictors() + ")";
    }

    private void setId(String id) {
        this.id = id;
    }

    private void setTitle(String title) {
        this.title = title;
    }

    private void setColor(PredictionColor color) {
        this.color = color;
    }

    private void setUsers(Integer users) {
        this.users = users;
    }

    private void setChannelPoints(Long channelPoints) {
        this.channelPoints = channelPoints;
    }

    private void setTopPredictors(@Nullable List<Predictor> topPredictors) {
        this.topPredictors = topPredictors;
    }

    public PredictionOutcome() {
    }

    public PredictionOutcome(String id, String title, PredictionColor color, Integer users, Long channelPoints, @Nullable List<Predictor> topPredictors) {
        this.id = id;
        this.title = title;
        this.color = color;
        this.users = users;
        this.channelPoints = channelPoints;
        this.topPredictors = topPredictors;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class PredictionOutcomeBuilder {
        private String id;
        private String title;
        private PredictionColor color;
        private Integer users;
        private Long channelPoints;
        private List<Predictor> topPredictors;

        PredictionOutcomeBuilder() {
        }

        public PredictionOutcomeBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PredictionOutcomeBuilder title(String title) {
            this.title = title;
            return this;
        }

        public PredictionOutcomeBuilder color(PredictionColor color) {
            this.color = color;
            return this;
        }

        public PredictionOutcomeBuilder users(Integer users) {
            this.users = users;
            return this;
        }

        public PredictionOutcomeBuilder channelPoints(Long channelPoints) {
            this.channelPoints = channelPoints;
            return this;
        }

        public PredictionOutcomeBuilder topPredictors(@Nullable List<Predictor> topPredictors) {
            this.topPredictors = topPredictors;
            return this;
        }

        public PredictionOutcome build() {
            return new PredictionOutcome(this.id, this.title, this.color, this.users, this.channelPoints, this.topPredictors);
        }

        public String toString() {
            return "PredictionOutcome.PredictionOutcomeBuilder(id=" + this.id + ", title=" + this.title + ", color=" + (Object)((Object)this.color) + ", users=" + this.users + ", channelPoints=" + this.channelPoints + ", topPredictors=" + this.topPredictors + ")";
        }
    }
}

