/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.eventsub;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.github.twitch4j.eventsub.EventSubTransportMethod;
import java.time.Instant;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=EventSubTransportBuilder.class)
public class EventSubTransport {
    @NotNull
    private EventSubTransportMethod method;
    @Nullable
    private String callback;
    @Nullable
    private String secret;
    @Nullable
    private String sessionId;
    @Nullable
    private Instant connectedAt;
    @Nullable
    private Instant disconnectedAt;

    public static EventSubTransportBuilder builder() {
        return new EventSubTransportBuilder();
    }

    @NotNull
    public EventSubTransportMethod getMethod() {
        return this.method;
    }

    @Nullable
    public String getCallback() {
        return this.callback;
    }

    @Nullable
    public String getSecret() {
        return this.secret;
    }

    @Nullable
    public String getSessionId() {
        return this.sessionId;
    }

    @Nullable
    public Instant getConnectedAt() {
        return this.connectedAt;
    }

    @Nullable
    public Instant getDisconnectedAt() {
        return this.disconnectedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventSubTransport)) {
            return false;
        }
        EventSubTransport other = (EventSubTransport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventSubTransportMethod this$method = this.getMethod();
        EventSubTransportMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        String this$callback = this.getCallback();
        String other$callback = other.getCallback();
        if (this$callback == null ? other$callback != null : !this$callback.equals(other$callback)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        Instant this$connectedAt = this.getConnectedAt();
        Instant other$connectedAt = other.getConnectedAt();
        if (this$connectedAt == null ? other$connectedAt != null : !((Object)this$connectedAt).equals(other$connectedAt)) {
            return false;
        }
        Instant this$disconnectedAt = this.getDisconnectedAt();
        Instant other$disconnectedAt = other.getDisconnectedAt();
        return !(this$disconnectedAt == null ? other$disconnectedAt != null : !((Object)this$disconnectedAt).equals(other$disconnectedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventSubTransport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventSubTransportMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        String $callback = this.getCallback();
        result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        Instant $connectedAt = this.getConnectedAt();
        result = result * 59 + ($connectedAt == null ? 43 : ((Object)$connectedAt).hashCode());
        Instant $disconnectedAt = this.getDisconnectedAt();
        result = result * 59 + ($disconnectedAt == null ? 43 : ((Object)$disconnectedAt).hashCode());
        return result;
    }

    public String toString() {
        return "EventSubTransport(method=" + (Object)((Object)this.getMethod()) + ", callback=" + this.getCallback() + ", secret=" + this.getSecret() + ", sessionId=" + this.getSessionId() + ", connectedAt=" + this.getConnectedAt() + ", disconnectedAt=" + this.getDisconnectedAt() + ")";
    }

    private void setMethod(@NotNull EventSubTransportMethod method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        this.method = method;
    }

    private void setCallback(@Nullable String callback) {
        this.callback = callback;
    }

    private void setSecret(@Nullable String secret) {
        this.secret = secret;
    }

    private void setConnectedAt(@Nullable Instant connectedAt) {
        this.connectedAt = connectedAt;
    }

    private void setDisconnectedAt(@Nullable Instant disconnectedAt) {
        this.disconnectedAt = disconnectedAt;
    }

    public EventSubTransport() {
    }

    public EventSubTransport(@NotNull EventSubTransportMethod method, @Nullable String callback, @Nullable String secret, @Nullable String sessionId, @Nullable Instant connectedAt, @Nullable Instant disconnectedAt) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        this.method = method;
        this.callback = callback;
        this.secret = secret;
        this.sessionId = sessionId;
        this.connectedAt = connectedAt;
        this.disconnectedAt = disconnectedAt;
    }

    public EventSubTransport withSessionId(@Nullable String sessionId) {
        return this.sessionId == sessionId ? this : new EventSubTransport(this.method, this.callback, this.secret, sessionId, this.connectedAt, this.disconnectedAt);
    }

    @Deprecated
    @ApiStatus.Internal
    public void setSessionId(@Nullable String sessionId) {
        this.sessionId = sessionId;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class EventSubTransportBuilder {
        private EventSubTransportMethod method;
        private String callback;
        private String secret;
        private String sessionId;
        private Instant connectedAt;
        private Instant disconnectedAt;

        EventSubTransportBuilder() {
        }

        public EventSubTransportBuilder method(@NotNull EventSubTransportMethod method) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            this.method = method;
            return this;
        }

        public EventSubTransportBuilder callback(@Nullable String callback) {
            this.callback = callback;
            return this;
        }

        public EventSubTransportBuilder secret(@Nullable String secret) {
            this.secret = secret;
            return this;
        }

        public EventSubTransportBuilder sessionId(@Nullable String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public EventSubTransportBuilder connectedAt(@Nullable Instant connectedAt) {
            this.connectedAt = connectedAt;
            return this;
        }

        public EventSubTransportBuilder disconnectedAt(@Nullable Instant disconnectedAt) {
            this.disconnectedAt = disconnectedAt;
            return this;
        }

        public EventSubTransport build() {
            return new EventSubTransport(this.method, this.callback, this.secret, this.sessionId, this.connectedAt, this.disconnectedAt);
        }

        public String toString() {
            return "EventSubTransport.EventSubTransportBuilder(method=" + (Object)((Object)this.method) + ", callback=" + this.callback + ", secret=" + this.secret + ", sessionId=" + this.sessionId + ", connectedAt=" + this.connectedAt + ", disconnectedAt=" + this.disconnectedAt + ")";
        }
    }
}

