/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.eventsub.socket.conduit;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.events4j.api.domain.IEventSubscription;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.philippheuer.events4j.simple.SimpleEventHandler;
import com.github.twitch4j.common.util.CryptoUtils;
import com.github.twitch4j.common.util.EventManagerUtils;
import com.github.twitch4j.common.util.ThreadUtils;
import com.github.twitch4j.eventsub.Conduit;
import com.github.twitch4j.eventsub.ConduitShard;
import com.github.twitch4j.eventsub.EventSubSubscription;
import com.github.twitch4j.eventsub.EventSubSubscriptionStatus;
import com.github.twitch4j.eventsub.EventSubTransport;
import com.github.twitch4j.eventsub.EventSubTransportMethod;
import com.github.twitch4j.eventsub.condition.EventSubCondition;
import com.github.twitch4j.eventsub.socket.IEventSubConduit;
import com.github.twitch4j.eventsub.socket.TwitchEventSocket;
import com.github.twitch4j.eventsub.socket.conduit.ConduitSpec;
import com.github.twitch4j.eventsub.socket.conduit.exceptions.ConduitNotFoundException;
import com.github.twitch4j.eventsub.socket.conduit.exceptions.ConduitResizeException;
import com.github.twitch4j.eventsub.socket.conduit.exceptions.CreateConduitException;
import com.github.twitch4j.eventsub.socket.conduit.exceptions.ShardRegistrationException;
import com.github.twitch4j.eventsub.socket.conduit.exceptions.ShardTimeoutException;
import com.github.twitch4j.eventsub.socket.events.ConduitShardReassociationFailureEvent;
import com.github.twitch4j.eventsub.socket.events.EventSocketWelcomedEvent;
import com.github.twitch4j.eventsub.subscriptions.SubscriptionType;
import com.github.twitch4j.helix.TwitchHelix;
import com.github.twitch4j.helix.TwitchHelixBuilder;
import com.github.twitch4j.helix.domain.ConduitList;
import com.github.twitch4j.helix.domain.EventSubSubscriptionList;
import com.github.twitch4j.helix.domain.ShardsInput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TwitchConduitSocketPool
implements IEventSubConduit {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwitchConduitSocketPool.class);
    @NotNull
    private final TwitchHelix api;
    @NotNull
    private final ScheduledThreadPoolExecutor executor;
    private final boolean shouldCloseExecutor;
    @NotNull
    private final EventManager eventManager;
    @Nullable
    private final OAuth2Credential credential;
    private final int shardOffset;
    @NotNull
    private final String conduitId;
    private final boolean shouldDeleteConduit;
    @NotNull
    private final EventSubTransport transport;
    private final List<TwitchEventSocket> sockets;

    TwitchConduitSocketPool(@NotNull ConduitSpec spec) throws CreateConduitException, ConduitNotFoundException, ConduitResizeException, ShardTimeoutException, ShardRegistrationException {
        int totalShards;
        String token;
        this.credential = spec.appAccessToken();
        this.eventManager = EventManagerUtils.validateOrInitializeEventManager((EventManager)spec.eventManager(), SimpleEventHandler.class);
        this.shardOffset = spec.shardOffset();
        if (spec.executor() == null) {
            String threadPrefix = "twitch4j-conduit-pool-" + CryptoUtils.generateNonce((int)4) + "-eventsub-ws-";
            this.executor = ThreadUtils.getDefaultScheduledThreadPoolExecutor((String)threadPrefix, (Integer)Runtime.getRuntime().availableProcessors());
            this.shouldCloseExecutor = true;
        } else {
            this.executor = spec.executor();
            this.shouldCloseExecutor = false;
        }
        this.api = spec.helix() == null ? TwitchHelixBuilder.builder().withClientId(spec.clientId()).withClientSecret(spec.clientSecret()).withDefaultAuthToken(this.credential).withProxyConfig(spec.proxyConfig()).withScheduledThreadPoolExecutor(this.executor).build() : spec.helix();
        int poolShards = spec.poolShards();
        String string = token = this.credential != null ? this.credential.getAccessToken() : null;
        if (spec.conduitId() == null) {
            totalShards = spec.totalShardCount() != null ? spec.totalShardCount() : poolShards;
            this.shouldDeleteConduit = poolShards >= totalShards;
            try {
                this.conduitId = ((Conduit)((ConduitList)this.api.createConduit(token, totalShards).execute()).getConduits().get(0)).getId();
            }
            catch (Exception e2) {
                if (this.shouldCloseExecutor) {
                    this.executor.shutdownNow();
                }
                throw new CreateConduitException(e2);
            }
        }
        this.conduitId = spec.conduitId();
        this.shouldDeleteConduit = false;
        if (spec.totalShardCount() != null) {
            totalShards = spec.totalShardCount();
        } else {
            try {
                totalShards = ((ConduitList)this.api.getConduits(token).execute()).getConduits().stream().filter(c -> this.conduitId.equals(c.getId())).mapToInt(Conduit::getShardCount).findAny().getAsInt();
            }
            catch (Exception e3) {
                if (this.shouldCloseExecutor) {
                    this.executor.shutdownNow();
                }
                throw new ConduitNotFoundException(this.conduitId, e3);
            }
        }
        int requiredShards = this.shardOffset + poolShards;
        if (requiredShards > totalShards) {
            try {
                this.api.updateConduit(token, this.conduitId, requiredShards).execute();
            }
            catch (Exception e4) {
                if (this.shouldCloseExecutor) {
                    this.executor.shutdownNow();
                }
                throw new ConduitResizeException(this.conduitId, e4);
            }
        }
        this.transport = EventSubTransport.builder().method(EventSubTransportMethod.CONDUIT).conduitId(this.conduitId).build();
        this.sockets = new ArrayList<TwitchEventSocket>(poolShards);
        Set<TwitchEventSocket> set = Collections.synchronizedSet(new HashSet(poolShards));
        CountDownLatch latch = new CountDownLatch(poolShards);
        IEventSubscription welcomeTracker = this.eventManager.onEvent(EventSocketWelcomedEvent.class, e -> {
            if (set.remove(e.getConnection())) {
                latch.countDown();
            }
        });
        for (int i = 0; i < poolShards; ++i) {
            TwitchEventSocket socket2 = TwitchEventSocket.builder().api(this.api).clientId(spec.clientId()).clientSecret(spec.clientSecret()).defaultToken(spec.appAccessToken()).proxyConfig(spec.proxyConfig()).eventManager(this.eventManager).taskExecutor(this.executor).build();
            this.sockets.add(socket2);
            set.add(socket2);
        }
        long timeout = spec.socketWelcomeTimeout() != null ? spec.socketWelcomeTimeout().toMillis() : 15000L;
        try {
            if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
                log.error("Failed to create {} shards", (Object)latch.getCount());
            }
        }
        catch (InterruptedException e5) {
            try {
                this.close();
            }
            catch (Exception ex) {
                log.warn("Failed to clean up conduit pool", (Throwable)ex);
            }
            throw new ShardTimeoutException(timeout);
        }
        finally {
            welcomeTracker.dispose();
        }
        this.sockets.removeIf(socket -> {
            if (socket.getWebsocketId() != null) {
                return false;
            }
            try {
                socket.close();
            }
            catch (Exception e) {
                log.warn("Failed to destroy socket shard that did not connect in time", (Throwable)e);
            }
            return true;
        });
        AtomicInteger shardId = new AtomicInteger(this.shardOffset);
        List shards = this.sockets.stream().map(TwitchEventSocket::getWebsocketId).filter(Objects::nonNull).map(id -> EventSubTransport.builder().method(EventSubTransportMethod.WEBSOCKET).sessionId(id).build()).map(t -> ConduitShard.builder().shardId(String.valueOf(shardId.getAndIncrement())).transport(t).build()).collect(Collectors.toList());
        try {
            this.api.updateConduitShards(token, new ShardsInput(this.conduitId, shards)).execute();
        }
        catch (Exception e6) {
            try {
                this.close();
            }
            catch (Exception ex) {
                log.warn("Failed to clean up conduit pool", (Throwable)ex);
            }
            throw new ShardRegistrationException(this.conduitId, e6);
        }
        this.eventManager.onEvent(EventSocketWelcomedEvent.class, e -> {
            if (!e.isSessionChanged()) {
                return;
            }
            int shardIndex = this.sockets.indexOf(e.getConnection());
            if (shardIndex < 0) {
                return;
            }
            String id = String.valueOf(shardIndex + this.shardOffset);
            EventSubTransport shardTransport = EventSubTransport.builder().method(EventSubTransportMethod.WEBSOCKET).sessionId(e.getSessionId()).build();
            ConduitShard updatedShard = ConduitShard.builder().shardId(id).transport(shardTransport).build();
            this.executor.execute(() -> {
                try {
                    this.api.updateConduitShards(token, new ShardsInput(this.conduitId, Collections.singletonList(updatedShard))).execute();
                }
                catch (Exception ex) {
                    log.warn("Failed to re-associate websocket (ID: {}) with conduit (ID: {}) after reconnect", new Object[]{id, this.conduitId, ex});
                    this.eventManager.publish((Object)new ConduitShardReassociationFailureEvent(e.getConnection(), this, id, ex));
                }
            });
        });
    }

    @Override
    public EventSubSubscription register(@NotNull EventSubSubscription subscription) {
        String token = this.credential != null ? this.credential.getAccessToken() : null;
        return (EventSubSubscription)((EventSubSubscriptionList)this.api.createEventSubSubscription(token, subscription.withTransport(this.transport)).execute()).getSubscriptions().get(0);
    }

    @Override
    public <C extends EventSubCondition, B> Optional<EventSubSubscription> register(@NotNull SubscriptionType<C, B, ?> type, @NotNull Function<B, C> conditions) {
        EventSubSubscription sub = type.prepareSubscription(conditions, this.transport);
        try {
            return Optional.ofNullable(this.register(sub));
        }
        catch (Exception e) {
            log.error("Failed to create EventSub subscription for Conduit with ID {}: {}", new Object[]{this.conduitId, sub, e});
            return Optional.empty();
        }
    }

    @Override
    public boolean unregister(@NotNull EventSubSubscription subscription) {
        String id;
        String token;
        if (subscription.getId() == null && subscription.getType() == null) {
            throw new IllegalArgumentException("Subscription to be unregistered is invalid");
        }
        if (subscription.getTransport() != null && !this.conduitId.equals(subscription.getTransport().getConduitId())) {
            throw new IllegalArgumentException("Specified subscription is not registered with this Conduit");
        }
        String string = token = this.credential != null ? this.credential.getAccessToken() : null;
        if (subscription.getId() != null) {
            id = subscription.getId();
        } else {
            try {
                id = ((EventSubSubscriptionList)this.api.getEventSubSubscriptions(token, EventSubSubscriptionStatus.ENABLED, subscription.getType(), null, null, null).execute()).getSubscriptions().stream().filter(sub -> this.conduitId.equals(sub.getTransport().getConduitId())).findAny().map(EventSubSubscription::getId).get();
            }
            catch (Exception e) {
                log.warn("Specified subscription is not actively registered to this Conduit with ID {}: {}", new Object[]{this.conduitId, subscription, e});
                return false;
            }
        }
        try {
            this.api.deleteEventSubSubscription(token, id).execute();
            return true;
        }
        catch (Exception e) {
            log.warn("Failed to delete EventSub subscription from Conduit with ID {}: {}", new Object[]{this.conduitId, subscription, e});
            return false;
        }
    }

    @Override
    public long getLatency() {
        long sum = 0L;
        int count = 0;
        for (TwitchEventSocket socket : this.sockets) {
            sum += socket.getLatency();
            ++count;
        }
        return count > 0 ? sum / (long)count : -1L;
    }

    @Override
    public void close() throws Exception {
        for (TwitchEventSocket socket : this.sockets) {
            socket.close();
        }
        if (this.shouldDeleteConduit) {
            String token = this.credential != null ? this.credential.getAccessToken() : null;
            this.api.deleteConduit(token, this.conduitId).execute();
        }
        if (this.shouldCloseExecutor) {
            this.executor.shutdownNow();
        }
    }

    public int getManagedShardCount() {
        return this.sockets.size();
    }

    @NotNull
    public static TwitchConduitSocketPool create(@NotNull Consumer<ConduitSpec> spec) throws CreateConduitException, ConduitNotFoundException, ConduitResizeException, ShardTimeoutException, ShardRegistrationException {
        return new TwitchConduitSocketPool(ConduitSpec.process(spec));
    }

    @NotNull
    @Generated
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Generated
    public int getShardOffset() {
        return this.shardOffset;
    }

    @Override
    @NotNull
    @Generated
    public String getConduitId() {
        return this.conduitId;
    }
}

