/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.extensions.compat;

import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.config.Twitch4JGlobal;
import com.github.twitch4j.extensions.TwitchExtensions;
import com.github.twitch4j.extensions.compat.ExtensionsTypeConverters;
import com.github.twitch4j.extensions.compat.HystrixCommandConverter;
import com.github.twitch4j.extensions.domain.ChannelList;
import com.github.twitch4j.extensions.domain.ConfigurationSegment;
import com.github.twitch4j.extensions.domain.ConfigurationSegmentType;
import com.github.twitch4j.extensions.domain.ExtensionConfigurationSegment;
import com.github.twitch4j.extensions.domain.ExtensionInformation;
import com.github.twitch4j.extensions.domain.ExtensionSecretList;
import com.github.twitch4j.helix.TwitchHelix;
import com.github.twitch4j.helix.TwitchHelixBuilder;
import com.github.twitch4j.helix.domain.ExtensionConfigurationSegmentInput;
import com.github.twitch4j.helix.domain.ExtensionConfigurationSegmentList;
import com.github.twitch4j.helix.domain.ExtensionLiveChannelsList;
import com.github.twitch4j.helix.domain.ExtensionSecretsList;
import com.github.twitch4j.helix.domain.ExtensionSegment;
import com.github.twitch4j.helix.domain.ReleasedExtensionList;
import com.github.twitch4j.helix.domain.SendPubSubMessageInput;
import com.netflix.hystrix.HystrixCommand;
import feign.Logger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class TwitchExtensionsCompatibilityLayer
implements TwitchExtensions {
    private final String clientId;
    private final TwitchHelix helix;

    public TwitchExtensionsCompatibilityLayer(String clientId, String clientSecret, String userAgent, Long timeout, Integer requestQueueSize, Logger.Level logLevel, ProxyConfig proxyConfig) {
        this.clientId = clientId;
        this.helix = TwitchHelixBuilder.builder().withClientId(clientId).withClientSecret(clientSecret).withUserAgent(userAgent != null ? userAgent : Twitch4JGlobal.userAgent).withTimeout(Integer.valueOf(timeout != null ? timeout.intValue() : 5000)).withRequestQueueSize(Integer.valueOf(requestQueueSize != null ? requestQueueSize : -1)).withLogLevel(logLevel != null ? logLevel : Logger.Level.NONE).withProxyConfig(proxyConfig).build();
    }

    @Override
    public HystrixCommand<ExtensionSecretList> createExtensionSecret(String clientId, String jsonWebToken, int activationDelaySeconds) {
        return new HystrixCommandConverter<ExtensionSecretsList, ExtensionSecretList>(this.helix.createExtensionSecret(jsonWebToken, this.getClientId(clientId), Integer.valueOf(activationDelaySeconds)), ExtensionsTypeConverters.SECRETS_CONVERTER);
    }

    @Override
    public HystrixCommand<ExtensionSecretList> getExtensionSecret(String clientId, String jsonWebToken) {
        return new HystrixCommandConverter<ExtensionSecretsList, ExtensionSecretList>(this.helix.getExtensionSecrets(jsonWebToken, this.getClientId(clientId)), ExtensionsTypeConverters.SECRETS_CONVERTER);
    }

    @Override
    public HystrixCommand<Void> revokeExtensionSecrets(String clientId, String jsonWebToken) {
        throw new UnsupportedOperationException("There is no direct Helix replacement for this endpoint.");
    }

    @Override
    public HystrixCommand<ChannelList> getLiveChannelsWithExtensionActivated(String clientId, String cursor) {
        return new HystrixCommandConverter<ExtensionLiveChannelsList, ChannelList>(this.helix.getExtensionLiveChannels(null, this.getClientId(clientId), Integer.valueOf(100), cursor), ExtensionsTypeConverters.LIVE_CHANNELS_CONVERTER);
    }

    @Override
    public HystrixCommand<Void> setExtensionRequiredConfiguration(String clientId, String jsonWebToken, String extensionVersion, String channelId, String requiredConfiguration) {
        return this.helix.setExtensionRequiredConfiguration(jsonWebToken, this.getClientId(clientId), extensionVersion, requiredConfiguration, channelId);
    }

    @Override
    public HystrixCommand<Void> setExtensionConfigurationSegment(String clientId, String jsonWebToken, ExtensionConfigurationSegment configurationSegment) {
        String extensionId = this.getClientId(clientId);
        return this.helix.setExtensionConfigurationSegment(jsonWebToken, extensionId, ExtensionConfigurationSegmentInput.builder().extensionId(extensionId).segment(ExtensionsTypeConverters.SEGMENT_CONVERTER.apply(configurationSegment.getSegment())).broadcasterId(configurationSegment.getChannelId()).content(configurationSegment.getContent()).version(configurationSegment.getVersion()).build());
    }

    @Override
    public HystrixCommand<Map<String, ConfigurationSegment>> getExtensionChannelConfiguration(String clientId, String jsonWebToken, String channelId) {
        return new HystrixCommandConverter<ExtensionConfigurationSegmentList, Map<String, ConfigurationSegment>>(this.helix.getExtensionConfigurationSegment(jsonWebToken, this.getClientId(clientId), Arrays.asList(ExtensionSegment.BROADCASTER, ExtensionSegment.DEVELOPER), channelId), ExtensionsTypeConverters.CONFIG_SEGMENT_LIST_CONVERTER);
    }

    @Override
    public HystrixCommand<Map<String, ConfigurationSegment>> getExtensionConfigurationSegment(String clientId, String jsonWebToken, ConfigurationSegmentType segmentType, String channelId) {
        return new HystrixCommandConverter<ExtensionConfigurationSegmentList, Map<String, ConfigurationSegment>>(this.helix.getExtensionConfigurationSegment(jsonWebToken, this.getClientId(clientId), Collections.singletonList(ExtensionsTypeConverters.SEGMENT_CONVERTER.apply(segmentType)), channelId), ExtensionsTypeConverters.CONFIG_SEGMENT_LIST_CONVERTER);
    }

    @Override
    public HystrixCommand<Void> sendExtensionPubSubMessage(String clientId, String jsonWebToken, String channelId, String message, String targets) {
        return this.helix.sendExtensionPubSubMessage(jsonWebToken, this.getClientId(clientId), SendPubSubMessageInput.builder().broadcasterId(channelId).message(message).target(targets).globalBroadcast("global".equals(targets)).build());
    }

    @Override
    public HystrixCommand<Void> sendExtensionChatMessage(String clientId, String jsonWebToken, String extensionVersion, String channelId, String text) {
        return this.helix.sendExtensionChatMessage(jsonWebToken, this.getClientId(clientId), extensionVersion, channelId, text);
    }

    @Override
    public HystrixCommand<ExtensionInformation> getExtensionInformation(String clientId) {
        return new HystrixCommandConverter<ReleasedExtensionList, ExtensionInformation>(this.helix.getReleasedExtensions(null, this.getClientId(clientId), null), ExtensionsTypeConverters.EXTENSION_LIST_CONVERTER);
    }

    private String getClientId(String overrideId) {
        return StringUtils.isNotBlank((CharSequence)overrideId) ? overrideId : this.clientId;
    }

    public static TwitchExtensionsCompatibilityLayerBuilder builder() {
        return new TwitchExtensionsCompatibilityLayerBuilder();
    }

    public static class TwitchExtensionsCompatibilityLayerBuilder {
        private String clientId;
        private String clientSecret;
        private String userAgent;
        private Long timeout;
        private Integer requestQueueSize;
        private Logger.Level logLevel;
        private ProxyConfig proxyConfig;

        TwitchExtensionsCompatibilityLayerBuilder() {
        }

        public TwitchExtensionsCompatibilityLayerBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public TwitchExtensionsCompatibilityLayerBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public TwitchExtensionsCompatibilityLayerBuilder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public TwitchExtensionsCompatibilityLayerBuilder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public TwitchExtensionsCompatibilityLayerBuilder requestQueueSize(Integer requestQueueSize) {
            this.requestQueueSize = requestQueueSize;
            return this;
        }

        public TwitchExtensionsCompatibilityLayerBuilder logLevel(Logger.Level logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public TwitchExtensionsCompatibilityLayerBuilder proxyConfig(ProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }

        public TwitchExtensionsCompatibilityLayer build() {
            return new TwitchExtensionsCompatibilityLayer(this.clientId, this.clientSecret, this.userAgent, this.timeout, this.requestQueueSize, this.logLevel, this.proxyConfig);
        }

        public String toString() {
            return "TwitchExtensionsCompatibilityLayer.TwitchExtensionsCompatibilityLayerBuilder(clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", userAgent=" + this.userAgent + ", timeout=" + this.timeout + ", requestQueueSize=" + this.requestQueueSize + ", logLevel=" + this.logLevel + ", proxyConfig=" + this.proxyConfig + ")";
        }
    }
}

