/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.extensions.compat;

import com.netflix.hystrix.HystrixCommand;
import java.util.function.Function;
import lombok.NonNull;

class HystrixCommandConverter<T, U>
extends HystrixCommand<U> {
    private final HystrixCommand<T> command;
    private final Function<T, U> converter;

    public HystrixCommandConverter(@NonNull HystrixCommand<T> hystrixCommand, @NonNull Function<T, U> converter) {
        super(hystrixCommand.getCommandGroup());
        if (hystrixCommand == null) {
            throw new NullPointerException("hystrixCommand is marked non-null but is null");
        }
        if (converter == null) {
            throw new NullPointerException("converter is marked non-null but is null");
        }
        this.command = hystrixCommand;
        this.converter = converter;
    }

    protected U run() {
        return this.converter.apply(this.command.execute());
    }
}

