/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.extensions.util;

import com.github.twitch4j.extensions.TwitchExtensionsBuilder;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class TwitchExtensionsClientIdInterceptor
implements RequestInterceptor {
    private static final String HEADER_NAME = "Client-Id";
    private final String defaultClientId;
    private final String userAgent;

    public TwitchExtensionsClientIdInterceptor(TwitchExtensionsBuilder builder) {
        this.defaultClientId = builder.getClientId();
        this.userAgent = builder.getUserAgent();
    }

    public void apply(RequestTemplate template) {
        String url;
        Collection headers = (Collection)template.headers().get(HEADER_NAME);
        if (headers == null || headers.size() != 1 || StringUtils.isBlank((CharSequence)((CharSequence)headers.iterator().next()))) {
            template.removeHeader(HEADER_NAME);
            template.header(HEADER_NAME, new String[]{this.defaultClientId});
        }
        template.uri((url = template.url()).startsWith("//") ? '/' + this.defaultClientId + '/' + url.substring(2) : url);
        template.header("User-Agent", new String[]{this.userAgent});
    }
}

