/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.graphql.command;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.Query;
import com.github.twitch4j.graphql.command.BaseCommand;
import com.github.twitch4j.graphql.internal.FetchUserQuery;

public class CommandFetchUser
extends BaseCommand<FetchUserQuery.Data> {
    private final String userId;
    private final String userLogin;

    public CommandFetchUser(ApolloClient apolloClient, String userId, String userLogin) {
        super(apolloClient);
        this.userId = userId;
        this.userLogin = userLogin;
        if (userId == null && userLogin == null) {
            throw new NullPointerException("Either the user id or login must be specified!");
        }
    }

    @Override
    protected ApolloCall<FetchUserQuery.Data> getGraphQLCall() {
        return this.apolloClient.query((Query)FetchUserQuery.builder().id(this.userId).login(this.userLogin).build());
    }
}

