/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=ChatSettingsBuilder.class)
public class ChatSettings {
    private String broadcasterId;
    @JsonProperty(value="emote_mode")
    private Boolean isEmoteOnlyMode;
    @JsonProperty(value="follower_mode")
    private Boolean isFollowersOnlyMode;
    @Nullable
    private Integer followerModeDuration;
    @Nullable
    private String moderatorId;
    @JsonProperty(value="non_moderator_chat_delay")
    @Nullable
    private Boolean hasNonModeratorChatDelay;
    @Nullable
    private Integer nonModeratorChatDelayDuration;
    @JsonProperty(value="slow_mode")
    private Boolean isSlowMode;
    @Nullable
    private Integer slowModeWaitTime;
    @JsonProperty(value="subscriber_mode")
    private Boolean isSubscribersOnlyMode;
    @JsonProperty(value="unique_chat_mode")
    private Boolean isUniqueChatMode;

    @Nullable
    public Duration getFollowersOnlyLength() {
        return this.followerModeDuration != null ? Duration.of(this.followerModeDuration.intValue(), ChronoUnit.MINUTES) : null;
    }

    @Nullable
    public Duration getNonModChatDelayLength() {
        return this.nonModeratorChatDelayDuration != null ? Duration.of(this.nonModeratorChatDelayDuration.intValue(), ChronoUnit.SECONDS) : null;
    }

    @Nullable
    public Duration getSlowModeLength() {
        return this.slowModeWaitTime != null ? Duration.of(this.slowModeWaitTime.intValue(), ChronoUnit.SECONDS) : null;
    }

    public static ChatSettingsBuilder builder() {
        return new ChatSettingsBuilder();
    }

    public ChatSettingsBuilder toBuilder() {
        return new ChatSettingsBuilder().broadcasterId(this.broadcasterId).isEmoteOnlyMode(this.isEmoteOnlyMode).isFollowersOnlyMode(this.isFollowersOnlyMode).followerModeDuration(this.followerModeDuration).moderatorId(this.moderatorId).hasNonModeratorChatDelay(this.hasNonModeratorChatDelay).nonModeratorChatDelayDuration(this.nonModeratorChatDelayDuration).isSlowMode(this.isSlowMode).slowModeWaitTime(this.slowModeWaitTime).isSubscribersOnlyMode(this.isSubscribersOnlyMode).isUniqueChatMode(this.isUniqueChatMode);
    }

    public ChatSettings withBroadcasterId(String broadcasterId) {
        return this.broadcasterId == broadcasterId ? this : new ChatSettings(broadcasterId, this.isEmoteOnlyMode, this.isFollowersOnlyMode, this.followerModeDuration, this.moderatorId, this.hasNonModeratorChatDelay, this.nonModeratorChatDelayDuration, this.isSlowMode, this.slowModeWaitTime, this.isSubscribersOnlyMode, this.isUniqueChatMode);
    }

    public ChatSettings withIsEmoteOnlyMode(Boolean isEmoteOnlyMode) {
        return this.isEmoteOnlyMode == isEmoteOnlyMode ? this : new ChatSettings(this.broadcasterId, isEmoteOnlyMode, this.isFollowersOnlyMode, this.followerModeDuration, this.moderatorId, this.hasNonModeratorChatDelay, this.nonModeratorChatDelayDuration, this.isSlowMode, this.slowModeWaitTime, this.isSubscribersOnlyMode, this.isUniqueChatMode);
    }

    public ChatSettings withIsFollowersOnlyMode(Boolean isFollowersOnlyMode) {
        return this.isFollowersOnlyMode == isFollowersOnlyMode ? this : new ChatSettings(this.broadcasterId, this.isEmoteOnlyMode, isFollowersOnlyMode, this.followerModeDuration, this.moderatorId, this.hasNonModeratorChatDelay, this.nonModeratorChatDelayDuration, this.isSlowMode, this.slowModeWaitTime, this.isSubscribersOnlyMode, this.isUniqueChatMode);
    }

    public ChatSettings withFollowerModeDuration(@Nullable Integer followerModeDuration) {
        return this.followerModeDuration == followerModeDuration ? this : new ChatSettings(this.broadcasterId, this.isEmoteOnlyMode, this.isFollowersOnlyMode, followerModeDuration, this.moderatorId, this.hasNonModeratorChatDelay, this.nonModeratorChatDelayDuration, this.isSlowMode, this.slowModeWaitTime, this.isSubscribersOnlyMode, this.isUniqueChatMode);
    }

    public ChatSettings withModeratorId(@Nullable String moderatorId) {
        return this.moderatorId == moderatorId ? this : new ChatSettings(this.broadcasterId, this.isEmoteOnlyMode, this.isFollowersOnlyMode, this.followerModeDuration, moderatorId, this.hasNonModeratorChatDelay, this.nonModeratorChatDelayDuration, this.isSlowMode, this.slowModeWaitTime, this.isSubscribersOnlyMode, this.isUniqueChatMode);
    }

    public ChatSettings withHasNonModeratorChatDelay(@Nullable Boolean hasNonModeratorChatDelay) {
        return this.hasNonModeratorChatDelay == hasNonModeratorChatDelay ? this : new ChatSettings(this.broadcasterId, this.isEmoteOnlyMode, this.isFollowersOnlyMode, this.followerModeDuration, this.moderatorId, hasNonModeratorChatDelay, this.nonModeratorChatDelayDuration, this.isSlowMode, this.slowModeWaitTime, this.isSubscribersOnlyMode, this.isUniqueChatMode);
    }

    public ChatSettings withNonModeratorChatDelayDuration(@Nullable Integer nonModeratorChatDelayDuration) {
        return this.nonModeratorChatDelayDuration == nonModeratorChatDelayDuration ? this : new ChatSettings(this.broadcasterId, this.isEmoteOnlyMode, this.isFollowersOnlyMode, this.followerModeDuration, this.moderatorId, this.hasNonModeratorChatDelay, nonModeratorChatDelayDuration, this.isSlowMode, this.slowModeWaitTime, this.isSubscribersOnlyMode, this.isUniqueChatMode);
    }

    public ChatSettings withIsSlowMode(Boolean isSlowMode) {
        return this.isSlowMode == isSlowMode ? this : new ChatSettings(this.broadcasterId, this.isEmoteOnlyMode, this.isFollowersOnlyMode, this.followerModeDuration, this.moderatorId, this.hasNonModeratorChatDelay, this.nonModeratorChatDelayDuration, isSlowMode, this.slowModeWaitTime, this.isSubscribersOnlyMode, this.isUniqueChatMode);
    }

    public ChatSettings withSlowModeWaitTime(@Nullable Integer slowModeWaitTime) {
        return this.slowModeWaitTime == slowModeWaitTime ? this : new ChatSettings(this.broadcasterId, this.isEmoteOnlyMode, this.isFollowersOnlyMode, this.followerModeDuration, this.moderatorId, this.hasNonModeratorChatDelay, this.nonModeratorChatDelayDuration, this.isSlowMode, slowModeWaitTime, this.isSubscribersOnlyMode, this.isUniqueChatMode);
    }

    public ChatSettings withIsSubscribersOnlyMode(Boolean isSubscribersOnlyMode) {
        return this.isSubscribersOnlyMode == isSubscribersOnlyMode ? this : new ChatSettings(this.broadcasterId, this.isEmoteOnlyMode, this.isFollowersOnlyMode, this.followerModeDuration, this.moderatorId, this.hasNonModeratorChatDelay, this.nonModeratorChatDelayDuration, this.isSlowMode, this.slowModeWaitTime, isSubscribersOnlyMode, this.isUniqueChatMode);
    }

    public ChatSettings withIsUniqueChatMode(Boolean isUniqueChatMode) {
        return this.isUniqueChatMode == isUniqueChatMode ? this : new ChatSettings(this.broadcasterId, this.isEmoteOnlyMode, this.isFollowersOnlyMode, this.followerModeDuration, this.moderatorId, this.hasNonModeratorChatDelay, this.nonModeratorChatDelayDuration, this.isSlowMode, this.slowModeWaitTime, this.isSubscribersOnlyMode, isUniqueChatMode);
    }

    public String getBroadcasterId() {
        return this.broadcasterId;
    }

    public Boolean isEmoteOnlyMode() {
        return this.isEmoteOnlyMode;
    }

    public Boolean isFollowersOnlyMode() {
        return this.isFollowersOnlyMode;
    }

    @Nullable
    public Integer getFollowerModeDuration() {
        return this.followerModeDuration;
    }

    @Nullable
    public String getModeratorId() {
        return this.moderatorId;
    }

    @Nullable
    public Boolean hasNonModeratorChatDelay() {
        return this.hasNonModeratorChatDelay;
    }

    @Nullable
    public Integer getNonModeratorChatDelayDuration() {
        return this.nonModeratorChatDelayDuration;
    }

    public Boolean isSlowMode() {
        return this.isSlowMode;
    }

    @Nullable
    public Integer getSlowModeWaitTime() {
        return this.slowModeWaitTime;
    }

    public Boolean isSubscribersOnlyMode() {
        return this.isSubscribersOnlyMode;
    }

    public Boolean isUniqueChatMode() {
        return this.isUniqueChatMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatSettings)) {
            return false;
        }
        ChatSettings other = (ChatSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isEmoteOnlyMode = this.isEmoteOnlyMode();
        Boolean other$isEmoteOnlyMode = other.isEmoteOnlyMode();
        if (this$isEmoteOnlyMode == null ? other$isEmoteOnlyMode != null : !((Object)this$isEmoteOnlyMode).equals(other$isEmoteOnlyMode)) {
            return false;
        }
        Boolean this$isFollowersOnlyMode = this.isFollowersOnlyMode();
        Boolean other$isFollowersOnlyMode = other.isFollowersOnlyMode();
        if (this$isFollowersOnlyMode == null ? other$isFollowersOnlyMode != null : !((Object)this$isFollowersOnlyMode).equals(other$isFollowersOnlyMode)) {
            return false;
        }
        Integer this$followerModeDuration = this.getFollowerModeDuration();
        Integer other$followerModeDuration = other.getFollowerModeDuration();
        if (this$followerModeDuration == null ? other$followerModeDuration != null : !((Object)this$followerModeDuration).equals(other$followerModeDuration)) {
            return false;
        }
        Boolean this$hasNonModeratorChatDelay = this.hasNonModeratorChatDelay();
        Boolean other$hasNonModeratorChatDelay = other.hasNonModeratorChatDelay();
        if (this$hasNonModeratorChatDelay == null ? other$hasNonModeratorChatDelay != null : !((Object)this$hasNonModeratorChatDelay).equals(other$hasNonModeratorChatDelay)) {
            return false;
        }
        Integer this$nonModeratorChatDelayDuration = this.getNonModeratorChatDelayDuration();
        Integer other$nonModeratorChatDelayDuration = other.getNonModeratorChatDelayDuration();
        if (this$nonModeratorChatDelayDuration == null ? other$nonModeratorChatDelayDuration != null : !((Object)this$nonModeratorChatDelayDuration).equals(other$nonModeratorChatDelayDuration)) {
            return false;
        }
        Boolean this$isSlowMode = this.isSlowMode();
        Boolean other$isSlowMode = other.isSlowMode();
        if (this$isSlowMode == null ? other$isSlowMode != null : !((Object)this$isSlowMode).equals(other$isSlowMode)) {
            return false;
        }
        Integer this$slowModeWaitTime = this.getSlowModeWaitTime();
        Integer other$slowModeWaitTime = other.getSlowModeWaitTime();
        if (this$slowModeWaitTime == null ? other$slowModeWaitTime != null : !((Object)this$slowModeWaitTime).equals(other$slowModeWaitTime)) {
            return false;
        }
        Boolean this$isSubscribersOnlyMode = this.isSubscribersOnlyMode();
        Boolean other$isSubscribersOnlyMode = other.isSubscribersOnlyMode();
        if (this$isSubscribersOnlyMode == null ? other$isSubscribersOnlyMode != null : !((Object)this$isSubscribersOnlyMode).equals(other$isSubscribersOnlyMode)) {
            return false;
        }
        Boolean this$isUniqueChatMode = this.isUniqueChatMode();
        Boolean other$isUniqueChatMode = other.isUniqueChatMode();
        if (this$isUniqueChatMode == null ? other$isUniqueChatMode != null : !((Object)this$isUniqueChatMode).equals(other$isUniqueChatMode)) {
            return false;
        }
        String this$broadcasterId = this.getBroadcasterId();
        String other$broadcasterId = other.getBroadcasterId();
        if (this$broadcasterId == null ? other$broadcasterId != null : !this$broadcasterId.equals(other$broadcasterId)) {
            return false;
        }
        String this$moderatorId = this.getModeratorId();
        String other$moderatorId = other.getModeratorId();
        return !(this$moderatorId == null ? other$moderatorId != null : !this$moderatorId.equals(other$moderatorId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isEmoteOnlyMode = this.isEmoteOnlyMode();
        result = result * 59 + ($isEmoteOnlyMode == null ? 43 : ((Object)$isEmoteOnlyMode).hashCode());
        Boolean $isFollowersOnlyMode = this.isFollowersOnlyMode();
        result = result * 59 + ($isFollowersOnlyMode == null ? 43 : ((Object)$isFollowersOnlyMode).hashCode());
        Integer $followerModeDuration = this.getFollowerModeDuration();
        result = result * 59 + ($followerModeDuration == null ? 43 : ((Object)$followerModeDuration).hashCode());
        Boolean $hasNonModeratorChatDelay = this.hasNonModeratorChatDelay();
        result = result * 59 + ($hasNonModeratorChatDelay == null ? 43 : ((Object)$hasNonModeratorChatDelay).hashCode());
        Integer $nonModeratorChatDelayDuration = this.getNonModeratorChatDelayDuration();
        result = result * 59 + ($nonModeratorChatDelayDuration == null ? 43 : ((Object)$nonModeratorChatDelayDuration).hashCode());
        Boolean $isSlowMode = this.isSlowMode();
        result = result * 59 + ($isSlowMode == null ? 43 : ((Object)$isSlowMode).hashCode());
        Integer $slowModeWaitTime = this.getSlowModeWaitTime();
        result = result * 59 + ($slowModeWaitTime == null ? 43 : ((Object)$slowModeWaitTime).hashCode());
        Boolean $isSubscribersOnlyMode = this.isSubscribersOnlyMode();
        result = result * 59 + ($isSubscribersOnlyMode == null ? 43 : ((Object)$isSubscribersOnlyMode).hashCode());
        Boolean $isUniqueChatMode = this.isUniqueChatMode();
        result = result * 59 + ($isUniqueChatMode == null ? 43 : ((Object)$isUniqueChatMode).hashCode());
        String $broadcasterId = this.getBroadcasterId();
        result = result * 59 + ($broadcasterId == null ? 43 : $broadcasterId.hashCode());
        String $moderatorId = this.getModeratorId();
        result = result * 59 + ($moderatorId == null ? 43 : $moderatorId.hashCode());
        return result;
    }

    public String toString() {
        return "ChatSettings(broadcasterId=" + this.getBroadcasterId() + ", isEmoteOnlyMode=" + this.isEmoteOnlyMode() + ", isFollowersOnlyMode=" + this.isFollowersOnlyMode() + ", followerModeDuration=" + this.getFollowerModeDuration() + ", moderatorId=" + this.getModeratorId() + ", hasNonModeratorChatDelay=" + this.hasNonModeratorChatDelay() + ", nonModeratorChatDelayDuration=" + this.getNonModeratorChatDelayDuration() + ", isSlowMode=" + this.isSlowMode() + ", slowModeWaitTime=" + this.getSlowModeWaitTime() + ", isSubscribersOnlyMode=" + this.isSubscribersOnlyMode() + ", isUniqueChatMode=" + this.isUniqueChatMode() + ")";
    }

    private void setBroadcasterId(String broadcasterId) {
        this.broadcasterId = broadcasterId;
    }

    @JsonProperty(value="emote_mode")
    private ChatSettings isEmoteOnlyMode(Boolean isEmoteOnlyMode) {
        this.isEmoteOnlyMode = isEmoteOnlyMode;
        return this;
    }

    @JsonProperty(value="follower_mode")
    private ChatSettings isFollowersOnlyMode(Boolean isFollowersOnlyMode) {
        this.isFollowersOnlyMode = isFollowersOnlyMode;
        return this;
    }

    private void setFollowerModeDuration(@Nullable Integer followerModeDuration) {
        this.followerModeDuration = followerModeDuration;
    }

    private void setModeratorId(@Nullable String moderatorId) {
        this.moderatorId = moderatorId;
    }

    @JsonProperty(value="non_moderator_chat_delay")
    private ChatSettings hasNonModeratorChatDelay(@Nullable Boolean hasNonModeratorChatDelay) {
        this.hasNonModeratorChatDelay = hasNonModeratorChatDelay;
        return this;
    }

    private void setNonModeratorChatDelayDuration(@Nullable Integer nonModeratorChatDelayDuration) {
        this.nonModeratorChatDelayDuration = nonModeratorChatDelayDuration;
    }

    @JsonProperty(value="slow_mode")
    private ChatSettings isSlowMode(Boolean isSlowMode) {
        this.isSlowMode = isSlowMode;
        return this;
    }

    private void setSlowModeWaitTime(@Nullable Integer slowModeWaitTime) {
        this.slowModeWaitTime = slowModeWaitTime;
    }

    @JsonProperty(value="subscriber_mode")
    private ChatSettings isSubscribersOnlyMode(Boolean isSubscribersOnlyMode) {
        this.isSubscribersOnlyMode = isSubscribersOnlyMode;
        return this;
    }

    @JsonProperty(value="unique_chat_mode")
    private ChatSettings isUniqueChatMode(Boolean isUniqueChatMode) {
        this.isUniqueChatMode = isUniqueChatMode;
        return this;
    }

    public ChatSettings() {
    }

    public ChatSettings(String broadcasterId, Boolean isEmoteOnlyMode, Boolean isFollowersOnlyMode, @Nullable Integer followerModeDuration, @Nullable String moderatorId, @Nullable Boolean hasNonModeratorChatDelay, @Nullable Integer nonModeratorChatDelayDuration, Boolean isSlowMode, @Nullable Integer slowModeWaitTime, Boolean isSubscribersOnlyMode, Boolean isUniqueChatMode) {
        this.broadcasterId = broadcasterId;
        this.isEmoteOnlyMode = isEmoteOnlyMode;
        this.isFollowersOnlyMode = isFollowersOnlyMode;
        this.followerModeDuration = followerModeDuration;
        this.moderatorId = moderatorId;
        this.hasNonModeratorChatDelay = hasNonModeratorChatDelay;
        this.nonModeratorChatDelayDuration = nonModeratorChatDelayDuration;
        this.isSlowMode = isSlowMode;
        this.slowModeWaitTime = slowModeWaitTime;
        this.isSubscribersOnlyMode = isSubscribersOnlyMode;
        this.isUniqueChatMode = isUniqueChatMode;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ChatSettingsBuilder {
        private String broadcasterId;
        private Boolean isEmoteOnlyMode;
        private Boolean isFollowersOnlyMode;
        private Integer followerModeDuration;
        private String moderatorId;
        private Boolean hasNonModeratorChatDelay;
        private Integer nonModeratorChatDelayDuration;
        private Boolean isSlowMode;
        private Integer slowModeWaitTime;
        private Boolean isSubscribersOnlyMode;
        private Boolean isUniqueChatMode;

        ChatSettingsBuilder() {
        }

        public ChatSettingsBuilder broadcasterId(String broadcasterId) {
            this.broadcasterId = broadcasterId;
            return this;
        }

        @JsonProperty(value="emote_mode")
        public ChatSettingsBuilder isEmoteOnlyMode(Boolean isEmoteOnlyMode) {
            this.isEmoteOnlyMode = isEmoteOnlyMode;
            return this;
        }

        @JsonProperty(value="follower_mode")
        public ChatSettingsBuilder isFollowersOnlyMode(Boolean isFollowersOnlyMode) {
            this.isFollowersOnlyMode = isFollowersOnlyMode;
            return this;
        }

        public ChatSettingsBuilder followerModeDuration(@Nullable Integer followerModeDuration) {
            this.followerModeDuration = followerModeDuration;
            return this;
        }

        public ChatSettingsBuilder moderatorId(@Nullable String moderatorId) {
            this.moderatorId = moderatorId;
            return this;
        }

        @JsonProperty(value="non_moderator_chat_delay")
        public ChatSettingsBuilder hasNonModeratorChatDelay(@Nullable Boolean hasNonModeratorChatDelay) {
            this.hasNonModeratorChatDelay = hasNonModeratorChatDelay;
            return this;
        }

        public ChatSettingsBuilder nonModeratorChatDelayDuration(@Nullable Integer nonModeratorChatDelayDuration) {
            this.nonModeratorChatDelayDuration = nonModeratorChatDelayDuration;
            return this;
        }

        @JsonProperty(value="slow_mode")
        public ChatSettingsBuilder isSlowMode(Boolean isSlowMode) {
            this.isSlowMode = isSlowMode;
            return this;
        }

        public ChatSettingsBuilder slowModeWaitTime(@Nullable Integer slowModeWaitTime) {
            this.slowModeWaitTime = slowModeWaitTime;
            return this;
        }

        @JsonProperty(value="subscriber_mode")
        public ChatSettingsBuilder isSubscribersOnlyMode(Boolean isSubscribersOnlyMode) {
            this.isSubscribersOnlyMode = isSubscribersOnlyMode;
            return this;
        }

        @JsonProperty(value="unique_chat_mode")
        public ChatSettingsBuilder isUniqueChatMode(Boolean isUniqueChatMode) {
            this.isUniqueChatMode = isUniqueChatMode;
            return this;
        }

        public ChatSettings build() {
            return new ChatSettings(this.broadcasterId, this.isEmoteOnlyMode, this.isFollowersOnlyMode, this.followerModeDuration, this.moderatorId, this.hasNonModeratorChatDelay, this.nonModeratorChatDelayDuration, this.isSlowMode, this.slowModeWaitTime, this.isSubscribersOnlyMode, this.isUniqueChatMode);
        }

        public String toString() {
            return "ChatSettings.ChatSettingsBuilder(broadcasterId=" + this.broadcasterId + ", isEmoteOnlyMode=" + this.isEmoteOnlyMode + ", isFollowersOnlyMode=" + this.isFollowersOnlyMode + ", followerModeDuration=" + this.followerModeDuration + ", moderatorId=" + this.moderatorId + ", hasNonModeratorChatDelay=" + this.hasNonModeratorChatDelay + ", nonModeratorChatDelayDuration=" + this.nonModeratorChatDelayDuration + ", isSlowMode=" + this.isSlowMode + ", slowModeWaitTime=" + this.slowModeWaitTime + ", isSubscribersOnlyMode=" + this.isSubscribersOnlyMode + ", isUniqueChatMode=" + this.isUniqueChatMode + ")";
        }
    }
}

