/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.interceptor;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.helix.interceptor.TwitchHelixTokenManager;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchHelixClientIdInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TwitchHelixClientIdInterceptor.class);
    public static final String AUTH_HEADER = "Authorization";
    public static final String BEARER_PREFIX = "Bearer ";
    private final String userAgent;
    private final TwitchHelixTokenManager tokenManager;

    public TwitchHelixClientIdInterceptor(String userAgent, TwitchHelixTokenManager tokenManager) {
        this.userAgent = userAgent;
        this.tokenManager = tokenManager;
    }

    public void apply(RequestTemplate template) {
        String clientId = this.tokenManager.getDefaultClientId();
        if (template.headers().containsKey(AUTH_HEADER)) {
            String oauthToken = ((String)((Collection)template.headers().get(AUTH_HEADER)).iterator().next()).substring(BEARER_PREFIX.length());
            if (oauthToken.isEmpty()) {
                try {
                    oauthToken = this.tokenManager.getDefaultAuthToken().getAccessToken();
                    clientId = this.tokenManager.getDefaultClientId();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to generate an app access token as no oauth token was passed to this Helix call", e);
                }
                template.removeHeader(AUTH_HEADER);
                template.header(AUTH_HEADER, new String[]{BEARER_PREFIX + oauthToken});
            } else if (!StringUtils.contains((CharSequence)oauthToken, (int)46)) {
                OAuth2Credential verifiedCredential = this.tokenManager.getOrPopulateCache(oauthToken);
                clientId = TwitchHelixTokenManager.extractClientId(verifiedCredential);
            }
            log.debug("Setting new client-id {} for token {}", (Object)clientId, (Object)oauthToken.substring(0, 5));
        }
        if (!template.headers().containsKey("Client-Id")) {
            template.header("Client-Id", new String[]{clientId});
        }
        template.header("User-Agent", new String[]{this.userAgent});
    }
}

