/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.interceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.twitch4j.helix.interceptor.TwitchHelixRateLimitTracker;
import feign.Request;
import feign.Response;
import feign.jackson.JacksonDecoder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;

public class TwitchHelixDecoder
extends JacksonDecoder {
    public static final String REMAINING_HEADER = "Ratelimit-Remaining";
    private final TwitchHelixRateLimitTracker rateLimitTracker;

    public TwitchHelixDecoder(ObjectMapper mapper, TwitchHelixRateLimitTracker rateLimitTracker) {
        super(mapper);
        this.rateLimitTracker = rateLimitTracker;
    }

    public Object decode(Response response, Type type) throws IOException {
        String token = TwitchHelixDecoder.singleFirst((Collection)response.request().headers().get("Authorization"));
        if (token != null && token.startsWith("Bearer ")) {
            Integer remaining;
            String remainingStr = TwitchHelixDecoder.singleFirst((Collection)response.headers().get(REMAINING_HEADER));
            try {
                remaining = Integer.parseInt(remainingStr);
            }
            catch (NumberFormatException ignored) {
                remaining = null;
            }
            if (remaining != null) {
                String bearer = token.substring("Bearer ".length());
                if (response.request().httpMethod() == Request.HttpMethod.POST && response.request().requestTemplate().path().endsWith("/clips")) {
                    this.rateLimitTracker.updateRemainingCreateClip(bearer, remaining);
                } else {
                    this.rateLimitTracker.updateRemaining(bearer, remaining);
                }
            }
        }
        return super.decode(response, type);
    }

    static String singleFirst(Collection<String> collection) {
        if (collection == null || collection.size() != 1) {
            return null;
        }
        return collection.toArray(new String[1])[0];
    }
}

