/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.interceptor;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.common.util.BucketUtils;
import com.github.twitch4j.helix.interceptor.TwitchHelixDecoder;
import com.github.twitch4j.helix.interceptor.TwitchHelixRateLimitTracker;
import com.github.twitch4j.helix.interceptor.TwitchHelixTokenManager;
import feign.Client;
import feign.Request;
import feign.Response;
import feign.okhttp.OkHttpClient;
import io.github.bucket4j.Bucket;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchHelixHttpClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(TwitchHelixHttpClient.class);
    private final Client client;
    private final ScheduledExecutorService executor;
    private final TwitchHelixTokenManager tokenManager;
    private final TwitchHelixRateLimitTracker rateLimitTracker;
    private final long timeout;

    public TwitchHelixHttpClient(OkHttpClient client, ScheduledThreadPoolExecutor executor, TwitchHelixTokenManager tokenManager, TwitchHelixRateLimitTracker rateLimitTracker, Integer timeout) {
        this.client = client;
        this.executor = executor;
        this.tokenManager = tokenManager;
        this.rateLimitTracker = rateLimitTracker;
        this.timeout = timeout == null ? 60000L : timeout.longValue();
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        OAuth2Credential credential;
        String token = TwitchHelixDecoder.singleFirst((Collection)request.headers().get("Authorization"));
        if (token != null && token.startsWith("Bearer ") && (credential = this.tokenManager.getIfPresent(token.substring("Bearer ".length()))) != null) {
            Bucket bucket = this.rateLimitTracker.getOrInitializeBucket(this.rateLimitTracker.getPrimaryBucketKey(credential));
            return this.executeAgainstBucket(bucket, () -> this.delegatedExecute(request, options));
        }
        return this.delegatedExecute(request, options);
    }

    private Response delegatedExecute(Request request, Request.Options options) throws IOException {
        String templatePath = request.requestTemplate().path();
        if (templatePath.endsWith("/moderation/bans")) {
            String channelId = (String)((Collection)request.requestTemplate().queries().getOrDefault("broadcaster_id", Collections.emptyList())).iterator().next();
            Bucket modBucket = this.rateLimitTracker.getModerationBucket(channelId);
            return this.executeAgainstBucket(modBucket, () -> this.client.execute(request, options));
        }
        if (templatePath.endsWith("/moderation/blocked_terms") && (request.httpMethod() == Request.HttpMethod.POST || request.httpMethod() == Request.HttpMethod.DELETE)) {
            String channelId = (String)((Collection)request.requestTemplate().queries().getOrDefault("broadcaster_id", Collections.emptyList())).iterator().next();
            Bucket termsBucket = this.rateLimitTracker.getTermsBucket(channelId);
            return this.executeAgainstBucket(termsBucket, () -> this.client.execute(request, options));
        }
        if (request.httpMethod() == Request.HttpMethod.POST && templatePath.endsWith("/clips")) {
            String token = ((String)((Collection)request.headers().get("Authorization")).iterator().next()).substring("Bearer ".length());
            OAuth2Credential cred = this.tokenManager.getIfPresent(token);
            String userId = cred != null ? cred.getUserId() : "";
            Bucket clipBucket = this.rateLimitTracker.getClipBucket(userId != null ? userId : "");
            return this.executeAgainstBucket(clipBucket, () -> this.client.execute(request, options));
        }
        return this.client.execute(request, options);
    }

    private <T> T executeAgainstBucket(Bucket bucket, Callable<T> call) throws IOException {
        try {
            return BucketUtils.scheduleAgainstBucket((Bucket)bucket, (ScheduledExecutorService)this.executor, call).get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.error("Throttled Helix API call timed-out before completion", (Throwable)e);
            return null;
        }
    }
}

