/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.interceptor;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.philippheuer.credentialmanager.domain.Credential;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.common.util.BucketUtils;
import com.github.twitch4j.helix.interceptor.TwitchHelixTokenManager;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class TwitchHelixRateLimitTracker {
    private static final Bandwidth BANS_BANDWIDTH = Bandwidth.simple((long)100L, (Duration)Duration.ofSeconds(30L));
    private static final Bandwidth CLIPS_BANDWIDTH = Bandwidth.simple((long)600L, (Duration)Duration.ofSeconds(60L));
    private static final Bandwidth TERMS_BANDWIDTH = Bandwidth.simple((long)60L, (Duration)Duration.ofSeconds(60L));
    private final Cache<String, Bucket> primaryBuckets = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final Cache<String, Bucket> bansByChannelId = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final Cache<String, Bucket> clipsByUserId = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final Cache<String, Bucket> termsByChannelId = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final Bandwidth apiRateLimit;
    private final TwitchHelixTokenManager tokenManager;

    @NotNull
    Bucket getOrInitializeBucket(@NotNull String key) {
        return (Bucket)this.primaryBuckets.get((Object)key, k -> BucketUtils.createBucket((Bandwidth)this.apiRateLimit));
    }

    @NotNull
    String getPrimaryBucketKey(@NotNull OAuth2Credential credential) {
        String clientId = TwitchHelixTokenManager.extractClientId(credential);
        return clientId == null ? "" : (StringUtils.isEmpty((CharSequence)credential.getUserId()) ? clientId : clientId + "-" + credential.getUserId());
    }

    @NotNull
    Bucket getModerationBucket(@NotNull String channelId) {
        return (Bucket)this.bansByChannelId.get((Object)channelId, k -> BucketUtils.createBucket((Bandwidth)BANS_BANDWIDTH));
    }

    @NotNull
    Bucket getClipBucket(@NotNull String userId) {
        return (Bucket)this.clipsByUserId.get((Object)userId, k -> BucketUtils.createBucket((Bandwidth)CLIPS_BANDWIDTH));
    }

    @NotNull
    Bucket getTermsBucket(@NotNull String channelId) {
        return (Bucket)this.termsByChannelId.get((Object)channelId, k -> BucketUtils.createBucket((Bandwidth)TERMS_BANDWIDTH));
    }

    public void updateRemaining(@NotNull String token, int remaining) {
        this.updateRemainingGeneric(token, remaining, this::getPrimaryBucketKey, this::getOrInitializeBucket);
    }

    public void updateRemainingCreateClip(@NotNull String token, int remaining) {
        this.updateRemainingGeneric(token, remaining, Credential::getUserId, this::getClipBucket);
    }

    public void markDepletedBanBucket(@NotNull String channelId) {
        Bucket modBucket = this.getModerationBucket(channelId);
        modBucket.consumeIgnoringRateLimits(Math.max(modBucket.tryConsumeAsMuchAsPossible(), 1L));
    }

    private void updateRemainingGeneric(String token, int remaining, Function<OAuth2Credential, String> credToKey, Function<String, Bucket> keyToBucket) {
        OAuth2Credential credential = this.tokenManager.getIfPresent(token);
        if (credential == null) {
            return;
        }
        String key = credToKey.apply(credential);
        if (key == null) {
            return;
        }
        Bucket bucket = keyToBucket.apply(key);
        long diff = bucket.getAvailableTokens() - (long)remaining;
        if (diff > 0L) {
            bucket.tryConsumeAsMuchAsPossible(diff);
        }
    }

    public TwitchHelixRateLimitTracker(Bandwidth apiRateLimit, TwitchHelixTokenManager tokenManager) {
        this.apiRateLimit = apiRateLimit;
        this.tokenManager = tokenManager;
    }
}

