/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.Instant;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class BannedEvent {
    @NonNull
    private String id;
    private EventType eventType;
    private Instant eventTimestamp;
    private String version;
    private EventData eventData;

    @NonNull
    public String getId() {
        return this.id;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public Instant getEventTimestamp() {
        return this.eventTimestamp;
    }

    public String getVersion() {
        return this.version;
    }

    public EventData getEventData() {
        return this.eventData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BannedEvent)) {
            return false;
        }
        BannedEvent other = (BannedEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        EventType this$eventType = this.getEventType();
        EventType other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !((Object)((Object)this$eventType)).equals((Object)other$eventType)) {
            return false;
        }
        Instant this$eventTimestamp = this.getEventTimestamp();
        Instant other$eventTimestamp = other.getEventTimestamp();
        if (this$eventTimestamp == null ? other$eventTimestamp != null : !((Object)this$eventTimestamp).equals(other$eventTimestamp)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        EventData this$eventData = this.getEventData();
        EventData other$eventData = other.getEventData();
        return !(this$eventData == null ? other$eventData != null : !((Object)this$eventData).equals(other$eventData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BannedEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        EventType $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : ((Object)((Object)$eventType)).hashCode());
        Instant $eventTimestamp = this.getEventTimestamp();
        result = result * 59 + ($eventTimestamp == null ? 43 : ((Object)$eventTimestamp).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        EventData $eventData = this.getEventData();
        result = result * 59 + ($eventData == null ? 43 : ((Object)$eventData).hashCode());
        return result;
    }

    public String toString() {
        return "BannedEvent(id=" + this.getId() + ", eventType=" + (Object)((Object)this.getEventType()) + ", eventTimestamp=" + this.getEventTimestamp() + ", version=" + this.getVersion() + ", eventData=" + this.getEventData() + ")";
    }

    private void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    private void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    private void setEventTimestamp(Instant eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    private void setVersion(String version) {
        this.version = version;
    }

    private void setEventData(EventData eventData) {
        this.eventData = eventData;
    }

    public static enum EventType {
        BAN("moderation.user.ban"),
        UNBAN("moderation.user.unban");

        private final String type;

        private EventType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        @JsonCreator
        public static EventType fromString(String type) {
            if (EventType.BAN.type.equalsIgnoreCase(type)) {
                return BAN;
            }
            if (EventType.UNBAN.type.equalsIgnoreCase(type)) {
                return UNBAN;
            }
            return null;
        }
    }

    public static class EventData {
        @NonNull
        private String broadcasterId;
        private String broadcasterLogin;
        private String broadcasterName;
        @NonNull
        private String userId;
        private String userLogin;
        private String userName;
        private Instant expiresAt;
        @Nullable
        private String reason;
        private String moderatorId;
        private String moderatorLogin;
        private String moderatorName;

        @NonNull
        public String getBroadcasterId() {
            return this.broadcasterId;
        }

        public String getBroadcasterLogin() {
            return this.broadcasterLogin;
        }

        public String getBroadcasterName() {
            return this.broadcasterName;
        }

        @NonNull
        public String getUserId() {
            return this.userId;
        }

        public String getUserLogin() {
            return this.userLogin;
        }

        public String getUserName() {
            return this.userName;
        }

        public Instant getExpiresAt() {
            return this.expiresAt;
        }

        @Nullable
        public String getReason() {
            return this.reason;
        }

        public String getModeratorId() {
            return this.moderatorId;
        }

        public String getModeratorLogin() {
            return this.moderatorLogin;
        }

        public String getModeratorName() {
            return this.moderatorName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventData)) {
                return false;
            }
            EventData other = (EventData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$broadcasterId = this.getBroadcasterId();
            String other$broadcasterId = other.getBroadcasterId();
            if (this$broadcasterId == null ? other$broadcasterId != null : !this$broadcasterId.equals(other$broadcasterId)) {
                return false;
            }
            String this$broadcasterLogin = this.getBroadcasterLogin();
            String other$broadcasterLogin = other.getBroadcasterLogin();
            if (this$broadcasterLogin == null ? other$broadcasterLogin != null : !this$broadcasterLogin.equals(other$broadcasterLogin)) {
                return false;
            }
            String this$broadcasterName = this.getBroadcasterName();
            String other$broadcasterName = other.getBroadcasterName();
            if (this$broadcasterName == null ? other$broadcasterName != null : !this$broadcasterName.equals(other$broadcasterName)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            String this$userLogin = this.getUserLogin();
            String other$userLogin = other.getUserLogin();
            if (this$userLogin == null ? other$userLogin != null : !this$userLogin.equals(other$userLogin)) {
                return false;
            }
            String this$userName = this.getUserName();
            String other$userName = other.getUserName();
            if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
                return false;
            }
            Instant this$expiresAt = this.getExpiresAt();
            Instant other$expiresAt = other.getExpiresAt();
            if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                return false;
            }
            String this$moderatorId = this.getModeratorId();
            String other$moderatorId = other.getModeratorId();
            if (this$moderatorId == null ? other$moderatorId != null : !this$moderatorId.equals(other$moderatorId)) {
                return false;
            }
            String this$moderatorLogin = this.getModeratorLogin();
            String other$moderatorLogin = other.getModeratorLogin();
            if (this$moderatorLogin == null ? other$moderatorLogin != null : !this$moderatorLogin.equals(other$moderatorLogin)) {
                return false;
            }
            String this$moderatorName = this.getModeratorName();
            String other$moderatorName = other.getModeratorName();
            return !(this$moderatorName == null ? other$moderatorName != null : !this$moderatorName.equals(other$moderatorName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EventData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $broadcasterId = this.getBroadcasterId();
            result = result * 59 + ($broadcasterId == null ? 43 : $broadcasterId.hashCode());
            String $broadcasterLogin = this.getBroadcasterLogin();
            result = result * 59 + ($broadcasterLogin == null ? 43 : $broadcasterLogin.hashCode());
            String $broadcasterName = this.getBroadcasterName();
            result = result * 59 + ($broadcasterName == null ? 43 : $broadcasterName.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            String $userLogin = this.getUserLogin();
            result = result * 59 + ($userLogin == null ? 43 : $userLogin.hashCode());
            String $userName = this.getUserName();
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            Instant $expiresAt = this.getExpiresAt();
            result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            String $moderatorId = this.getModeratorId();
            result = result * 59 + ($moderatorId == null ? 43 : $moderatorId.hashCode());
            String $moderatorLogin = this.getModeratorLogin();
            result = result * 59 + ($moderatorLogin == null ? 43 : $moderatorLogin.hashCode());
            String $moderatorName = this.getModeratorName();
            result = result * 59 + ($moderatorName == null ? 43 : $moderatorName.hashCode());
            return result;
        }

        public String toString() {
            return "BannedEvent.EventData(broadcasterId=" + this.getBroadcasterId() + ", broadcasterLogin=" + this.getBroadcasterLogin() + ", broadcasterName=" + this.getBroadcasterName() + ", userId=" + this.getUserId() + ", userLogin=" + this.getUserLogin() + ", userName=" + this.getUserName() + ", expiresAt=" + this.getExpiresAt() + ", reason=" + this.getReason() + ", moderatorId=" + this.getModeratorId() + ", moderatorLogin=" + this.getModeratorLogin() + ", moderatorName=" + this.getModeratorName() + ")";
        }

        private void setBroadcasterId(@NonNull String broadcasterId) {
            if (broadcasterId == null) {
                throw new NullPointerException("broadcasterId is marked non-null but is null");
            }
            this.broadcasterId = broadcasterId;
        }

        private void setBroadcasterLogin(String broadcasterLogin) {
            this.broadcasterLogin = broadcasterLogin;
        }

        private void setBroadcasterName(String broadcasterName) {
            this.broadcasterName = broadcasterName;
        }

        private void setUserId(@NonNull String userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
        }

        private void setUserLogin(String userLogin) {
            this.userLogin = userLogin;
        }

        private void setUserName(String userName) {
            this.userName = userName;
        }

        private void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        private void setReason(@Nullable String reason) {
            this.reason = reason;
        }

        private void setModeratorId(String moderatorId) {
            this.moderatorId = moderatorId;
        }

        private void setModeratorLogin(String moderatorLogin) {
            this.moderatorLogin = moderatorLogin;
        }

        private void setModeratorName(String moderatorName) {
            this.moderatorName = moderatorName;
        }
    }
}

