/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.domain;

import com.github.twitch4j.helix.domain.UpdateEntitlementStatus;
import com.github.twitch4j.helix.domain.UpdatedDropEntitlements;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class UpdatedDropEntitlementsList {
    private List<UpdatedDropEntitlements> data;
    private final AtomicReference<Object> transformedData = new AtomicReference();

    private static Map<UpdateEntitlementStatus, Collection<String>> transform(Collection<UpdatedDropEntitlements> rawData) {
        EnumMap<UpdateEntitlementStatus, Collection> map = new EnumMap<UpdateEntitlementStatus, Collection>(UpdateEntitlementStatus.class);
        for (UpdatedDropEntitlements updated : rawData) {
            map.merge(updated.getStatus(), new HashSet<String>(updated.getIds()), (c1, c2) -> {
                c1.addAll(c2);
                return c1;
            });
        }
        return Collections.unmodifiableMap(map);
    }

    public List<UpdatedDropEntitlements> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdatedDropEntitlementsList)) {
            return false;
        }
        UpdatedDropEntitlementsList other = (UpdatedDropEntitlementsList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<UpdatedDropEntitlements> this$data = this.getData();
        List<UpdatedDropEntitlements> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        Map<UpdateEntitlementStatus, Collection<String>> this$transformedData = this.getTransformedData();
        Map<UpdateEntitlementStatus, Collection<String>> other$transformedData = other.getTransformedData();
        return !(this$transformedData == null ? other$transformedData != null : !((Object)this$transformedData).equals(other$transformedData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdatedDropEntitlementsList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<UpdatedDropEntitlements> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        Map<UpdateEntitlementStatus, Collection<String>> $transformedData = this.getTransformedData();
        result = result * 59 + ($transformedData == null ? 43 : ((Object)$transformedData).hashCode());
        return result;
    }

    public String toString() {
        return "UpdatedDropEntitlementsList(data=" + this.getData() + ")";
    }

    private void setData(List<UpdatedDropEntitlements> data) {
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<UpdateEntitlementStatus, Collection<String>> getTransformedData() {
        Object value = this.transformedData.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.transformedData;
            synchronized (atomicReference) {
                value = this.transformedData.get();
                if (value == null) {
                    Map<UpdateEntitlementStatus, Collection<String>> actualValue = UpdatedDropEntitlementsList.transform(this.getData());
                    value = actualValue == null ? this.transformedData : actualValue;
                    this.transformedData.set(value);
                }
            }
        }
        return (Map)(value == this.transformedData ? null : value);
    }
}

