/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.interceptor;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.auth.providers.TwitchIdentityProvider;
import io.github.xanthic.cache.api.Cache;
import io.github.xanthic.cache.api.domain.ExpiryType;
import io.github.xanthic.cache.core.CacheApi;
import java.time.Duration;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TwitchHelixTokenManager {
    private static final Logger log = LoggerFactory.getLogger(TwitchHelixTokenManager.class);
    private static final String CLIENT_ID_CONTEXT = "client_id";
    private final Cache<String, OAuth2Credential> accessTokenCache = CacheApi.create(spec -> {
        spec.maxSize(Long.valueOf(10000L));
        spec.expiryType(ExpiryType.POST_ACCESS);
        spec.expiryTime(Duration.ofMinutes(15L));
    });
    private final TwitchIdentityProvider twitchIdentityProvider;
    private final String clientId;
    private final String clientSecret;
    private volatile String defaultClientId;
    private volatile OAuth2Credential defaultAuthToken;

    public TwitchHelixTokenManager(String clientId, String clientSecret, OAuth2Credential defaultAuthToken) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.twitchIdentityProvider = new TwitchIdentityProvider(clientId, clientSecret, null);
        this.defaultClientId = clientId;
        this.defaultAuthToken = defaultAuthToken;
        if (defaultAuthToken != null) {
            this.defaultClientId = Objects.toString(defaultAuthToken.getContext().getOrDefault(CLIENT_ID_CONTEXT, clientId), null);
            this.twitchIdentityProvider.getAdditionalCredentialInformation(defaultAuthToken).ifPresent(oauth -> {
                this.populateCache((OAuth2Credential)oauth);
                this.defaultClientId = TwitchHelixTokenManager.extractClientId(oauth);
                this.defaultAuthToken.updateCredential(oauth);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OAuth2Credential getDefaultAuthToken() {
        if (this.defaultAuthToken == null) {
            TwitchHelixTokenManager twitchHelixTokenManager = this;
            synchronized (twitchHelixTokenManager) {
                if (this.defaultAuthToken == null) {
                    this.checkClientCredentialsParameters();
                    OAuth2Credential token = this.twitchIdentityProvider.getAppAccessToken();
                    this.populateCache(token);
                    this.defaultClientId = (String)token.getContext().computeIfAbsent(CLIENT_ID_CONTEXT, s -> this.clientId);
                    this.defaultAuthToken = token;
                    return this.defaultAuthToken;
                }
            }
        }
        return this.defaultAuthToken;
    }

    @Nullable
    OAuth2Credential getIfPresent(@NotNull String accessToken) {
        return (OAuth2Credential)this.accessTokenCache.get((Object)accessToken);
    }

    @NotNull
    OAuth2Credential getOrPopulateCache(@NotNull String accessToken) {
        OAuth2Credential verifiedCredential = this.getIfPresent(accessToken);
        if (verifiedCredential == null) {
            log.debug("Getting matching client-id for authorization token {}", (Object)accessToken.substring(0, 5));
            verifiedCredential = (OAuth2Credential)this.twitchIdentityProvider.getAdditionalCredentialInformation(new OAuth2Credential(this.twitchIdentityProvider.getProviderName(), accessToken)).orElseThrow(() -> new RuntimeException("Failed to get the client_id for the provided authentication token, the authentication token may be invalid!"));
            this.populateCache(verifiedCredential);
        }
        return verifiedCredential;
    }

    private void populateCache(@NotNull OAuth2Credential enrichedCredential) {
        this.accessTokenCache.put((Object)enrichedCredential.getAccessToken(), (Object)enrichedCredential);
    }

    private void checkClientCredentialsParameters() {
        if (StringUtils.isEmpty((CharSequence)this.defaultClientId) || StringUtils.isEmpty((CharSequence)this.clientSecret) || this.clientSecret.charAt(0) == '*') {
            throw new RuntimeException("Necessary OAuth token was missing from Helix call, without the means to generate one!");
        }
    }

    static String extractClientId(@NotNull OAuth2Credential credential) {
        return (String)credential.getContext().get(CLIENT_ID_CONTEXT);
    }

    String getDefaultClientId() {
        return this.defaultClientId;
    }
}

