/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.twitch4j.eventsub.domain.ContentClassification;
import com.github.twitch4j.helix.domain.ContentClassificationState;
import com.github.twitch4j.helix.interceptor.ContentClassificationStateListSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChannelInformation {
    private String broadcasterId;
    private String broadcasterLogin;
    private String broadcasterName;
    private String broadcasterLanguage;
    private String gameId;
    private String gameName;
    private String title;
    @Nullable
    private Integer delay;
    private List<String> tags;
    @JsonSerialize(using=ContentClassificationStateListSerializer.class)
    private Collection<ContentClassificationState> contentClassificationLabels;
    @JsonProperty(value="is_branded_content")
    private Boolean isBrandedContent;

    @JsonProperty(value="content_classification_labels")
    private void setContentClassificationLabels(Collection<ContentClassification> labels) {
        if (labels == null) {
            return;
        }
        this.contentClassificationLabels = new ArrayList<ContentClassificationState>(labels.size());
        labels.forEach(label -> this.contentClassificationLabels.add(new ContentClassificationState((ContentClassification)label, true)));
    }

    public static ChannelInformationBuilder builder() {
        return new ChannelInformationBuilder();
    }

    public ChannelInformationBuilder toBuilder() {
        ChannelInformationBuilder builder = new ChannelInformationBuilder().broadcasterId(this.broadcasterId).broadcasterLogin(this.broadcasterLogin).broadcasterName(this.broadcasterName).broadcasterLanguage(this.broadcasterLanguage).gameId(this.gameId).gameName(this.gameName).title(this.title).delay(this.delay).tags(this.tags).isBrandedContent(this.isBrandedContent);
        if (this.contentClassificationLabels != null) {
            builder.contentClassificationLabels(this.contentClassificationLabels);
        }
        return builder;
    }

    public String getBroadcasterId() {
        return this.broadcasterId;
    }

    public String getBroadcasterLogin() {
        return this.broadcasterLogin;
    }

    public String getBroadcasterName() {
        return this.broadcasterName;
    }

    public String getBroadcasterLanguage() {
        return this.broadcasterLanguage;
    }

    public String getGameId() {
        return this.gameId;
    }

    public String getGameName() {
        return this.gameName;
    }

    public String getTitle() {
        return this.title;
    }

    @Nullable
    public Integer getDelay() {
        return this.delay;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Collection<ContentClassificationState> getContentClassificationLabels() {
        return this.contentClassificationLabels;
    }

    public Boolean isBrandedContent() {
        return this.isBrandedContent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelInformation)) {
            return false;
        }
        ChannelInformation other = (ChannelInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$delay = this.getDelay();
        Integer other$delay = other.getDelay();
        if (this$delay == null ? other$delay != null : !((Object)this$delay).equals(other$delay)) {
            return false;
        }
        Boolean this$isBrandedContent = this.isBrandedContent();
        Boolean other$isBrandedContent = other.isBrandedContent();
        if (this$isBrandedContent == null ? other$isBrandedContent != null : !((Object)this$isBrandedContent).equals(other$isBrandedContent)) {
            return false;
        }
        String this$broadcasterId = this.getBroadcasterId();
        String other$broadcasterId = other.getBroadcasterId();
        if (this$broadcasterId == null ? other$broadcasterId != null : !this$broadcasterId.equals(other$broadcasterId)) {
            return false;
        }
        String this$broadcasterLogin = this.getBroadcasterLogin();
        String other$broadcasterLogin = other.getBroadcasterLogin();
        if (this$broadcasterLogin == null ? other$broadcasterLogin != null : !this$broadcasterLogin.equals(other$broadcasterLogin)) {
            return false;
        }
        String this$broadcasterName = this.getBroadcasterName();
        String other$broadcasterName = other.getBroadcasterName();
        if (this$broadcasterName == null ? other$broadcasterName != null : !this$broadcasterName.equals(other$broadcasterName)) {
            return false;
        }
        String this$broadcasterLanguage = this.getBroadcasterLanguage();
        String other$broadcasterLanguage = other.getBroadcasterLanguage();
        if (this$broadcasterLanguage == null ? other$broadcasterLanguage != null : !this$broadcasterLanguage.equals(other$broadcasterLanguage)) {
            return false;
        }
        String this$gameId = this.getGameId();
        String other$gameId = other.getGameId();
        if (this$gameId == null ? other$gameId != null : !this$gameId.equals(other$gameId)) {
            return false;
        }
        String this$gameName = this.getGameName();
        String other$gameName = other.getGameName();
        if (this$gameName == null ? other$gameName != null : !this$gameName.equals(other$gameName)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Collection<ContentClassificationState> this$contentClassificationLabels = this.getContentClassificationLabels();
        Collection<ContentClassificationState> other$contentClassificationLabels = other.getContentClassificationLabels();
        return !(this$contentClassificationLabels == null ? other$contentClassificationLabels != null : !((Object)this$contentClassificationLabels).equals(other$contentClassificationLabels));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChannelInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $delay = this.getDelay();
        result = result * 59 + ($delay == null ? 43 : ((Object)$delay).hashCode());
        Boolean $isBrandedContent = this.isBrandedContent();
        result = result * 59 + ($isBrandedContent == null ? 43 : ((Object)$isBrandedContent).hashCode());
        String $broadcasterId = this.getBroadcasterId();
        result = result * 59 + ($broadcasterId == null ? 43 : $broadcasterId.hashCode());
        String $broadcasterLogin = this.getBroadcasterLogin();
        result = result * 59 + ($broadcasterLogin == null ? 43 : $broadcasterLogin.hashCode());
        String $broadcasterName = this.getBroadcasterName();
        result = result * 59 + ($broadcasterName == null ? 43 : $broadcasterName.hashCode());
        String $broadcasterLanguage = this.getBroadcasterLanguage();
        result = result * 59 + ($broadcasterLanguage == null ? 43 : $broadcasterLanguage.hashCode());
        String $gameId = this.getGameId();
        result = result * 59 + ($gameId == null ? 43 : $gameId.hashCode());
        String $gameName = this.getGameName();
        result = result * 59 + ($gameName == null ? 43 : $gameName.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Collection<ContentClassificationState> $contentClassificationLabels = this.getContentClassificationLabels();
        result = result * 59 + ($contentClassificationLabels == null ? 43 : ((Object)$contentClassificationLabels).hashCode());
        return result;
    }

    public String toString() {
        return "ChannelInformation(broadcasterId=" + this.getBroadcasterId() + ", broadcasterLogin=" + this.getBroadcasterLogin() + ", broadcasterName=" + this.getBroadcasterName() + ", broadcasterLanguage=" + this.getBroadcasterLanguage() + ", gameId=" + this.getGameId() + ", gameName=" + this.getGameName() + ", title=" + this.getTitle() + ", delay=" + this.getDelay() + ", tags=" + this.getTags() + ", contentClassificationLabels=" + this.getContentClassificationLabels() + ", isBrandedContent=" + this.isBrandedContent() + ")";
    }

    public ChannelInformation withBroadcasterId(String broadcasterId) {
        return this.broadcasterId == broadcasterId ? this : new ChannelInformation(broadcasterId, this.broadcasterLogin, this.broadcasterName, this.broadcasterLanguage, this.gameId, this.gameName, this.title, this.delay, this.tags, this.contentClassificationLabels, this.isBrandedContent);
    }

    public ChannelInformation withBroadcasterLogin(String broadcasterLogin) {
        return this.broadcasterLogin == broadcasterLogin ? this : new ChannelInformation(this.broadcasterId, broadcasterLogin, this.broadcasterName, this.broadcasterLanguage, this.gameId, this.gameName, this.title, this.delay, this.tags, this.contentClassificationLabels, this.isBrandedContent);
    }

    public ChannelInformation withBroadcasterName(String broadcasterName) {
        return this.broadcasterName == broadcasterName ? this : new ChannelInformation(this.broadcasterId, this.broadcasterLogin, broadcasterName, this.broadcasterLanguage, this.gameId, this.gameName, this.title, this.delay, this.tags, this.contentClassificationLabels, this.isBrandedContent);
    }

    public ChannelInformation withBroadcasterLanguage(String broadcasterLanguage) {
        return this.broadcasterLanguage == broadcasterLanguage ? this : new ChannelInformation(this.broadcasterId, this.broadcasterLogin, this.broadcasterName, broadcasterLanguage, this.gameId, this.gameName, this.title, this.delay, this.tags, this.contentClassificationLabels, this.isBrandedContent);
    }

    public ChannelInformation withGameId(String gameId) {
        return this.gameId == gameId ? this : new ChannelInformation(this.broadcasterId, this.broadcasterLogin, this.broadcasterName, this.broadcasterLanguage, gameId, this.gameName, this.title, this.delay, this.tags, this.contentClassificationLabels, this.isBrandedContent);
    }

    public ChannelInformation withGameName(String gameName) {
        return this.gameName == gameName ? this : new ChannelInformation(this.broadcasterId, this.broadcasterLogin, this.broadcasterName, this.broadcasterLanguage, this.gameId, gameName, this.title, this.delay, this.tags, this.contentClassificationLabels, this.isBrandedContent);
    }

    public ChannelInformation withTitle(String title) {
        return this.title == title ? this : new ChannelInformation(this.broadcasterId, this.broadcasterLogin, this.broadcasterName, this.broadcasterLanguage, this.gameId, this.gameName, title, this.delay, this.tags, this.contentClassificationLabels, this.isBrandedContent);
    }

    public ChannelInformation withDelay(@Nullable Integer delay) {
        return this.delay == delay ? this : new ChannelInformation(this.broadcasterId, this.broadcasterLogin, this.broadcasterName, this.broadcasterLanguage, this.gameId, this.gameName, this.title, delay, this.tags, this.contentClassificationLabels, this.isBrandedContent);
    }

    public ChannelInformation withTags(List<String> tags) {
        return this.tags == tags ? this : new ChannelInformation(this.broadcasterId, this.broadcasterLogin, this.broadcasterName, this.broadcasterLanguage, this.gameId, this.gameName, this.title, this.delay, tags, this.contentClassificationLabels, this.isBrandedContent);
    }

    public ChannelInformation withContentClassificationLabels(Collection<ContentClassificationState> contentClassificationLabels) {
        return this.contentClassificationLabels == contentClassificationLabels ? this : new ChannelInformation(this.broadcasterId, this.broadcasterLogin, this.broadcasterName, this.broadcasterLanguage, this.gameId, this.gameName, this.title, this.delay, this.tags, contentClassificationLabels, this.isBrandedContent);
    }

    public ChannelInformation withIsBrandedContent(Boolean isBrandedContent) {
        return this.isBrandedContent == isBrandedContent ? this : new ChannelInformation(this.broadcasterId, this.broadcasterLogin, this.broadcasterName, this.broadcasterLanguage, this.gameId, this.gameName, this.title, this.delay, this.tags, this.contentClassificationLabels, isBrandedContent);
    }

    private void setBroadcasterId(String broadcasterId) {
        this.broadcasterId = broadcasterId;
    }

    private void setBroadcasterLogin(String broadcasterLogin) {
        this.broadcasterLogin = broadcasterLogin;
    }

    private void setBroadcasterName(String broadcasterName) {
        this.broadcasterName = broadcasterName;
    }

    private void setBroadcasterLanguage(String broadcasterLanguage) {
        this.broadcasterLanguage = broadcasterLanguage;
    }

    private void setGameId(String gameId) {
        this.gameId = gameId;
    }

    private void setGameName(String gameName) {
        this.gameName = gameName;
    }

    private void setTitle(String title) {
        this.title = title;
    }

    private void setDelay(@Nullable Integer delay) {
        this.delay = delay;
    }

    private void setTags(List<String> tags) {
        this.tags = tags;
    }

    @JsonProperty(value="is_branded_content")
    private ChannelInformation isBrandedContent(Boolean isBrandedContent) {
        this.isBrandedContent = isBrandedContent;
        return this;
    }

    public ChannelInformation() {
    }

    public ChannelInformation(String broadcasterId, String broadcasterLogin, String broadcasterName, String broadcasterLanguage, String gameId, String gameName, String title, @Nullable Integer delay, List<String> tags, Collection<ContentClassificationState> contentClassificationLabels, Boolean isBrandedContent) {
        this.broadcasterId = broadcasterId;
        this.broadcasterLogin = broadcasterLogin;
        this.broadcasterName = broadcasterName;
        this.broadcasterLanguage = broadcasterLanguage;
        this.gameId = gameId;
        this.gameName = gameName;
        this.title = title;
        this.delay = delay;
        this.tags = tags;
        this.contentClassificationLabels = contentClassificationLabels;
        this.isBrandedContent = isBrandedContent;
    }

    public static class ChannelInformationBuilder {
        private String broadcasterId;
        private String broadcasterLogin;
        private String broadcasterName;
        private String broadcasterLanguage;
        private String gameId;
        private String gameName;
        private String title;
        private Integer delay;
        private List<String> tags;
        private ArrayList<ContentClassificationState> contentClassificationLabels;
        private Boolean isBrandedContent;

        ChannelInformationBuilder() {
        }

        public ChannelInformationBuilder broadcasterId(String broadcasterId) {
            this.broadcasterId = broadcasterId;
            return this;
        }

        public ChannelInformationBuilder broadcasterLogin(String broadcasterLogin) {
            this.broadcasterLogin = broadcasterLogin;
            return this;
        }

        public ChannelInformationBuilder broadcasterName(String broadcasterName) {
            this.broadcasterName = broadcasterName;
            return this;
        }

        public ChannelInformationBuilder broadcasterLanguage(String broadcasterLanguage) {
            this.broadcasterLanguage = broadcasterLanguage;
            return this;
        }

        public ChannelInformationBuilder gameId(String gameId) {
            this.gameId = gameId;
            return this;
        }

        public ChannelInformationBuilder gameName(String gameName) {
            this.gameName = gameName;
            return this;
        }

        public ChannelInformationBuilder title(String title) {
            this.title = title;
            return this;
        }

        public ChannelInformationBuilder delay(@Nullable Integer delay) {
            this.delay = delay;
            return this;
        }

        public ChannelInformationBuilder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public ChannelInformationBuilder contentClassificationLabel(ContentClassificationState contentClassificationLabel) {
            if (this.contentClassificationLabels == null) {
                this.contentClassificationLabels = new ArrayList();
            }
            this.contentClassificationLabels.add(contentClassificationLabel);
            return this;
        }

        public ChannelInformationBuilder contentClassificationLabels(Collection<? extends ContentClassificationState> contentClassificationLabels) {
            if (contentClassificationLabels == null) {
                throw new NullPointerException("contentClassificationLabels cannot be null");
            }
            if (this.contentClassificationLabels == null) {
                this.contentClassificationLabels = new ArrayList();
            }
            this.contentClassificationLabels.addAll(contentClassificationLabels);
            return this;
        }

        public ChannelInformationBuilder clearContentClassificationLabels() {
            if (this.contentClassificationLabels != null) {
                this.contentClassificationLabels.clear();
            }
            return this;
        }

        @JsonProperty(value="is_branded_content")
        public ChannelInformationBuilder isBrandedContent(Boolean isBrandedContent) {
            this.isBrandedContent = isBrandedContent;
            return this;
        }

        public ChannelInformation build() {
            List<ContentClassificationState> contentClassificationLabels;
            switch (this.contentClassificationLabels == null ? 0 : this.contentClassificationLabels.size()) {
                case 0: {
                    contentClassificationLabels = Collections.emptyList();
                    break;
                }
                case 1: {
                    contentClassificationLabels = Collections.singletonList(this.contentClassificationLabels.get(0));
                    break;
                }
                default: {
                    contentClassificationLabels = Collections.unmodifiableList(new ArrayList<ContentClassificationState>(this.contentClassificationLabels));
                }
            }
            return new ChannelInformation(this.broadcasterId, this.broadcasterLogin, this.broadcasterName, this.broadcasterLanguage, this.gameId, this.gameName, this.title, this.delay, this.tags, contentClassificationLabels, this.isBrandedContent);
        }

        public String toString() {
            return "ChannelInformation.ChannelInformationBuilder(broadcasterId=" + this.broadcasterId + ", broadcasterLogin=" + this.broadcasterLogin + ", broadcasterName=" + this.broadcasterName + ", broadcasterLanguage=" + this.broadcasterLanguage + ", gameId=" + this.gameId + ", gameName=" + this.gameName + ", title=" + this.title + ", delay=" + this.delay + ", tags=" + this.tags + ", contentClassificationLabels=" + this.contentClassificationLabels + ", isBrandedContent=" + this.isBrandedContent + ")";
        }
    }
}

