/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.github.twitch4j.eventsub.domain.PollChoice;
import com.github.twitch4j.eventsub.domain.PollStatus;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=PollBuilder.class)
public class Poll {
    private String id;
    private String broadcasterId;
    private String broadcasterName;
    private String broadcasterLogin;
    private String title;
    private List<PollChoice> choices;
    @Deprecated
    @JsonProperty(value="bits_voting_enabled")
    private Boolean isBitsVotingEnabled = false;
    @Deprecated
    private Integer bitsPerVote;
    @JsonProperty(value="channel_points_voting_enabled")
    private Boolean isChannelPointsVotingEnabled;
    private Integer channelPointsPerVote;
    private PollStatus status;
    @JsonProperty(value="duration")
    private Integer durationSeconds;
    private Instant startedAt;
    @Nullable
    private Instant endedAt;

    @JsonIgnore
    @Nullable
    public Duration getDuration() {
        return this.durationSeconds != null ? Duration.ofSeconds(this.durationSeconds.longValue()) : null;
    }

    public static PollBuilder builder() {
        return new PollBuilder();
    }

    public PollBuilder toBuilder() {
        PollBuilder builder = new PollBuilder().id(this.id).broadcasterId(this.broadcasterId).broadcasterName(this.broadcasterName).broadcasterLogin(this.broadcasterLogin).title(this.title).isBitsVotingEnabled(this.isBitsVotingEnabled).bitsPerVote(this.bitsPerVote).isChannelPointsVotingEnabled(this.isChannelPointsVotingEnabled).channelPointsPerVote(this.channelPointsPerVote).status(this.status).durationSeconds(this.durationSeconds).startedAt(this.startedAt).endedAt(this.endedAt);
        if (this.choices != null) {
            builder.choices(this.choices);
        }
        return builder;
    }

    public Poll withId(String id) {
        return this.id == id ? this : new Poll(id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.choices, this.isBitsVotingEnabled, this.bitsPerVote, this.isChannelPointsVotingEnabled, this.channelPointsPerVote, this.status, this.durationSeconds, this.startedAt, this.endedAt);
    }

    public Poll withBroadcasterId(String broadcasterId) {
        return this.broadcasterId == broadcasterId ? this : new Poll(this.id, broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.choices, this.isBitsVotingEnabled, this.bitsPerVote, this.isChannelPointsVotingEnabled, this.channelPointsPerVote, this.status, this.durationSeconds, this.startedAt, this.endedAt);
    }

    public Poll withBroadcasterName(String broadcasterName) {
        return this.broadcasterName == broadcasterName ? this : new Poll(this.id, this.broadcasterId, broadcasterName, this.broadcasterLogin, this.title, this.choices, this.isBitsVotingEnabled, this.bitsPerVote, this.isChannelPointsVotingEnabled, this.channelPointsPerVote, this.status, this.durationSeconds, this.startedAt, this.endedAt);
    }

    public Poll withBroadcasterLogin(String broadcasterLogin) {
        return this.broadcasterLogin == broadcasterLogin ? this : new Poll(this.id, this.broadcasterId, this.broadcasterName, broadcasterLogin, this.title, this.choices, this.isBitsVotingEnabled, this.bitsPerVote, this.isChannelPointsVotingEnabled, this.channelPointsPerVote, this.status, this.durationSeconds, this.startedAt, this.endedAt);
    }

    public Poll withTitle(String title) {
        return this.title == title ? this : new Poll(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, title, this.choices, this.isBitsVotingEnabled, this.bitsPerVote, this.isChannelPointsVotingEnabled, this.channelPointsPerVote, this.status, this.durationSeconds, this.startedAt, this.endedAt);
    }

    public Poll withChoices(List<PollChoice> choices) {
        return this.choices == choices ? this : new Poll(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, choices, this.isBitsVotingEnabled, this.bitsPerVote, this.isChannelPointsVotingEnabled, this.channelPointsPerVote, this.status, this.durationSeconds, this.startedAt, this.endedAt);
    }

    @Deprecated
    public Poll withIsBitsVotingEnabled(Boolean isBitsVotingEnabled) {
        return this.isBitsVotingEnabled == isBitsVotingEnabled ? this : new Poll(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.choices, isBitsVotingEnabled, this.bitsPerVote, this.isChannelPointsVotingEnabled, this.channelPointsPerVote, this.status, this.durationSeconds, this.startedAt, this.endedAt);
    }

    @Deprecated
    public Poll withBitsPerVote(Integer bitsPerVote) {
        return this.bitsPerVote == bitsPerVote ? this : new Poll(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.choices, this.isBitsVotingEnabled, bitsPerVote, this.isChannelPointsVotingEnabled, this.channelPointsPerVote, this.status, this.durationSeconds, this.startedAt, this.endedAt);
    }

    public Poll withIsChannelPointsVotingEnabled(Boolean isChannelPointsVotingEnabled) {
        return this.isChannelPointsVotingEnabled == isChannelPointsVotingEnabled ? this : new Poll(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.choices, this.isBitsVotingEnabled, this.bitsPerVote, isChannelPointsVotingEnabled, this.channelPointsPerVote, this.status, this.durationSeconds, this.startedAt, this.endedAt);
    }

    public Poll withChannelPointsPerVote(Integer channelPointsPerVote) {
        return this.channelPointsPerVote == channelPointsPerVote ? this : new Poll(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.choices, this.isBitsVotingEnabled, this.bitsPerVote, this.isChannelPointsVotingEnabled, channelPointsPerVote, this.status, this.durationSeconds, this.startedAt, this.endedAt);
    }

    public Poll withStatus(PollStatus status) {
        return this.status == status ? this : new Poll(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.choices, this.isBitsVotingEnabled, this.bitsPerVote, this.isChannelPointsVotingEnabled, this.channelPointsPerVote, status, this.durationSeconds, this.startedAt, this.endedAt);
    }

    public Poll withDurationSeconds(Integer durationSeconds) {
        return this.durationSeconds == durationSeconds ? this : new Poll(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.choices, this.isBitsVotingEnabled, this.bitsPerVote, this.isChannelPointsVotingEnabled, this.channelPointsPerVote, this.status, durationSeconds, this.startedAt, this.endedAt);
    }

    public Poll withStartedAt(Instant startedAt) {
        return this.startedAt == startedAt ? this : new Poll(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.choices, this.isBitsVotingEnabled, this.bitsPerVote, this.isChannelPointsVotingEnabled, this.channelPointsPerVote, this.status, this.durationSeconds, startedAt, this.endedAt);
    }

    public Poll withEndedAt(@Nullable Instant endedAt) {
        return this.endedAt == endedAt ? this : new Poll(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.choices, this.isBitsVotingEnabled, this.bitsPerVote, this.isChannelPointsVotingEnabled, this.channelPointsPerVote, this.status, this.durationSeconds, this.startedAt, endedAt);
    }

    public String getId() {
        return this.id;
    }

    public String getBroadcasterId() {
        return this.broadcasterId;
    }

    public String getBroadcasterName() {
        return this.broadcasterName;
    }

    public String getBroadcasterLogin() {
        return this.broadcasterLogin;
    }

    public String getTitle() {
        return this.title;
    }

    public List<PollChoice> getChoices() {
        return this.choices;
    }

    @Deprecated
    public Boolean isBitsVotingEnabled() {
        return this.isBitsVotingEnabled;
    }

    @Deprecated
    public Integer getBitsPerVote() {
        return this.bitsPerVote;
    }

    public Boolean isChannelPointsVotingEnabled() {
        return this.isChannelPointsVotingEnabled;
    }

    public Integer getChannelPointsPerVote() {
        return this.channelPointsPerVote;
    }

    public PollStatus getStatus() {
        return this.status;
    }

    public Integer getDurationSeconds() {
        return this.durationSeconds;
    }

    public Instant getStartedAt() {
        return this.startedAt;
    }

    @Nullable
    public Instant getEndedAt() {
        return this.endedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Poll)) {
            return false;
        }
        Poll other = (Poll)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isBitsVotingEnabled = this.isBitsVotingEnabled();
        Boolean other$isBitsVotingEnabled = other.isBitsVotingEnabled();
        if (this$isBitsVotingEnabled == null ? other$isBitsVotingEnabled != null : !((Object)this$isBitsVotingEnabled).equals(other$isBitsVotingEnabled)) {
            return false;
        }
        Integer this$bitsPerVote = this.getBitsPerVote();
        Integer other$bitsPerVote = other.getBitsPerVote();
        if (this$bitsPerVote == null ? other$bitsPerVote != null : !((Object)this$bitsPerVote).equals(other$bitsPerVote)) {
            return false;
        }
        Boolean this$isChannelPointsVotingEnabled = this.isChannelPointsVotingEnabled();
        Boolean other$isChannelPointsVotingEnabled = other.isChannelPointsVotingEnabled();
        if (this$isChannelPointsVotingEnabled == null ? other$isChannelPointsVotingEnabled != null : !((Object)this$isChannelPointsVotingEnabled).equals(other$isChannelPointsVotingEnabled)) {
            return false;
        }
        Integer this$channelPointsPerVote = this.getChannelPointsPerVote();
        Integer other$channelPointsPerVote = other.getChannelPointsPerVote();
        if (this$channelPointsPerVote == null ? other$channelPointsPerVote != null : !((Object)this$channelPointsPerVote).equals(other$channelPointsPerVote)) {
            return false;
        }
        Integer this$durationSeconds = this.getDurationSeconds();
        Integer other$durationSeconds = other.getDurationSeconds();
        if (this$durationSeconds == null ? other$durationSeconds != null : !((Object)this$durationSeconds).equals(other$durationSeconds)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$broadcasterId = this.getBroadcasterId();
        String other$broadcasterId = other.getBroadcasterId();
        if (this$broadcasterId == null ? other$broadcasterId != null : !this$broadcasterId.equals(other$broadcasterId)) {
            return false;
        }
        String this$broadcasterName = this.getBroadcasterName();
        String other$broadcasterName = other.getBroadcasterName();
        if (this$broadcasterName == null ? other$broadcasterName != null : !this$broadcasterName.equals(other$broadcasterName)) {
            return false;
        }
        String this$broadcasterLogin = this.getBroadcasterLogin();
        String other$broadcasterLogin = other.getBroadcasterLogin();
        if (this$broadcasterLogin == null ? other$broadcasterLogin != null : !this$broadcasterLogin.equals(other$broadcasterLogin)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List<PollChoice> this$choices = this.getChoices();
        List<PollChoice> other$choices = other.getChoices();
        if (this$choices == null ? other$choices != null : !((Object)this$choices).equals(other$choices)) {
            return false;
        }
        PollStatus this$status = this.getStatus();
        PollStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Instant this$startedAt = this.getStartedAt();
        Instant other$startedAt = other.getStartedAt();
        if (this$startedAt == null ? other$startedAt != null : !((Object)this$startedAt).equals(other$startedAt)) {
            return false;
        }
        Instant this$endedAt = this.getEndedAt();
        Instant other$endedAt = other.getEndedAt();
        return !(this$endedAt == null ? other$endedAt != null : !((Object)this$endedAt).equals(other$endedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Poll;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isBitsVotingEnabled = this.isBitsVotingEnabled();
        result = result * 59 + ($isBitsVotingEnabled == null ? 43 : ((Object)$isBitsVotingEnabled).hashCode());
        Integer $bitsPerVote = this.getBitsPerVote();
        result = result * 59 + ($bitsPerVote == null ? 43 : ((Object)$bitsPerVote).hashCode());
        Boolean $isChannelPointsVotingEnabled = this.isChannelPointsVotingEnabled();
        result = result * 59 + ($isChannelPointsVotingEnabled == null ? 43 : ((Object)$isChannelPointsVotingEnabled).hashCode());
        Integer $channelPointsPerVote = this.getChannelPointsPerVote();
        result = result * 59 + ($channelPointsPerVote == null ? 43 : ((Object)$channelPointsPerVote).hashCode());
        Integer $durationSeconds = this.getDurationSeconds();
        result = result * 59 + ($durationSeconds == null ? 43 : ((Object)$durationSeconds).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $broadcasterId = this.getBroadcasterId();
        result = result * 59 + ($broadcasterId == null ? 43 : $broadcasterId.hashCode());
        String $broadcasterName = this.getBroadcasterName();
        result = result * 59 + ($broadcasterName == null ? 43 : $broadcasterName.hashCode());
        String $broadcasterLogin = this.getBroadcasterLogin();
        result = result * 59 + ($broadcasterLogin == null ? 43 : $broadcasterLogin.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List<PollChoice> $choices = this.getChoices();
        result = result * 59 + ($choices == null ? 43 : ((Object)$choices).hashCode());
        PollStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Instant $startedAt = this.getStartedAt();
        result = result * 59 + ($startedAt == null ? 43 : ((Object)$startedAt).hashCode());
        Instant $endedAt = this.getEndedAt();
        result = result * 59 + ($endedAt == null ? 43 : ((Object)$endedAt).hashCode());
        return result;
    }

    public String toString() {
        return "Poll(id=" + this.getId() + ", broadcasterId=" + this.getBroadcasterId() + ", broadcasterName=" + this.getBroadcasterName() + ", broadcasterLogin=" + this.getBroadcasterLogin() + ", title=" + this.getTitle() + ", choices=" + this.getChoices() + ", isBitsVotingEnabled=" + this.isBitsVotingEnabled() + ", bitsPerVote=" + this.getBitsPerVote() + ", isChannelPointsVotingEnabled=" + this.isChannelPointsVotingEnabled() + ", channelPointsPerVote=" + this.getChannelPointsPerVote() + ", status=" + this.getStatus() + ", durationSeconds=" + this.getDurationSeconds() + ", startedAt=" + this.getStartedAt() + ", endedAt=" + this.getEndedAt() + ")";
    }

    private void setId(String id) {
        this.id = id;
    }

    private void setBroadcasterId(String broadcasterId) {
        this.broadcasterId = broadcasterId;
    }

    private void setBroadcasterName(String broadcasterName) {
        this.broadcasterName = broadcasterName;
    }

    private void setBroadcasterLogin(String broadcasterLogin) {
        this.broadcasterLogin = broadcasterLogin;
    }

    private void setTitle(String title) {
        this.title = title;
    }

    private void setChoices(List<PollChoice> choices) {
        this.choices = choices;
    }

    @Deprecated
    @JsonProperty(value="bits_voting_enabled")
    private Poll isBitsVotingEnabled(Boolean isBitsVotingEnabled) {
        this.isBitsVotingEnabled = isBitsVotingEnabled;
        return this;
    }

    @Deprecated
    private void setBitsPerVote(Integer bitsPerVote) {
        this.bitsPerVote = bitsPerVote;
    }

    @JsonProperty(value="channel_points_voting_enabled")
    private Poll isChannelPointsVotingEnabled(Boolean isChannelPointsVotingEnabled) {
        this.isChannelPointsVotingEnabled = isChannelPointsVotingEnabled;
        return this;
    }

    private void setChannelPointsPerVote(Integer channelPointsPerVote) {
        this.channelPointsPerVote = channelPointsPerVote;
    }

    private void setStatus(PollStatus status) {
        this.status = status;
    }

    @JsonProperty(value="duration")
    private void setDurationSeconds(Integer durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    private void setStartedAt(Instant startedAt) {
        this.startedAt = startedAt;
    }

    private void setEndedAt(@Nullable Instant endedAt) {
        this.endedAt = endedAt;
    }

    public Poll() {
    }

    public Poll(String id, String broadcasterId, String broadcasterName, String broadcasterLogin, String title, List<PollChoice> choices, Boolean isBitsVotingEnabled, Integer bitsPerVote, Boolean isChannelPointsVotingEnabled, Integer channelPointsPerVote, PollStatus status, Integer durationSeconds, Instant startedAt, @Nullable Instant endedAt) {
        this.id = id;
        this.broadcasterId = broadcasterId;
        this.broadcasterName = broadcasterName;
        this.broadcasterLogin = broadcasterLogin;
        this.title = title;
        this.choices = choices;
        this.isBitsVotingEnabled = isBitsVotingEnabled;
        this.bitsPerVote = bitsPerVote;
        this.isChannelPointsVotingEnabled = isChannelPointsVotingEnabled;
        this.channelPointsPerVote = channelPointsPerVote;
        this.status = status;
        this.durationSeconds = durationSeconds;
        this.startedAt = startedAt;
        this.endedAt = endedAt;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class PollBuilder {
        private String id;
        private String broadcasterId;
        private String broadcasterName;
        private String broadcasterLogin;
        private String title;
        private ArrayList<PollChoice> choices;
        private Boolean isBitsVotingEnabled;
        private Integer bitsPerVote;
        private Boolean isChannelPointsVotingEnabled;
        private Integer channelPointsPerVote;
        private PollStatus status;
        private Integer durationSeconds;
        private Instant startedAt;
        private Instant endedAt;

        PollBuilder() {
        }

        public PollBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PollBuilder broadcasterId(String broadcasterId) {
            this.broadcasterId = broadcasterId;
            return this;
        }

        public PollBuilder broadcasterName(String broadcasterName) {
            this.broadcasterName = broadcasterName;
            return this;
        }

        public PollBuilder broadcasterLogin(String broadcasterLogin) {
            this.broadcasterLogin = broadcasterLogin;
            return this;
        }

        public PollBuilder title(String title) {
            this.title = title;
            return this;
        }

        public PollBuilder choice(PollChoice choice) {
            if (this.choices == null) {
                this.choices = new ArrayList();
            }
            this.choices.add(choice);
            return this;
        }

        public PollBuilder choices(Collection<? extends PollChoice> choices) {
            if (choices == null) {
                throw new NullPointerException("choices cannot be null");
            }
            if (this.choices == null) {
                this.choices = new ArrayList();
            }
            this.choices.addAll(choices);
            return this;
        }

        public PollBuilder clearChoices() {
            if (this.choices != null) {
                this.choices.clear();
            }
            return this;
        }

        @Deprecated
        @JsonProperty(value="bits_voting_enabled")
        public PollBuilder isBitsVotingEnabled(Boolean isBitsVotingEnabled) {
            this.isBitsVotingEnabled = isBitsVotingEnabled;
            return this;
        }

        @Deprecated
        public PollBuilder bitsPerVote(Integer bitsPerVote) {
            this.bitsPerVote = bitsPerVote;
            return this;
        }

        @JsonProperty(value="channel_points_voting_enabled")
        public PollBuilder isChannelPointsVotingEnabled(Boolean isChannelPointsVotingEnabled) {
            this.isChannelPointsVotingEnabled = isChannelPointsVotingEnabled;
            return this;
        }

        public PollBuilder channelPointsPerVote(Integer channelPointsPerVote) {
            this.channelPointsPerVote = channelPointsPerVote;
            return this;
        }

        public PollBuilder status(PollStatus status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="duration")
        public PollBuilder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public PollBuilder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public PollBuilder endedAt(@Nullable Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public Poll build() {
            List<PollChoice> choices;
            switch (this.choices == null ? 0 : this.choices.size()) {
                case 0: {
                    choices = Collections.emptyList();
                    break;
                }
                case 1: {
                    choices = Collections.singletonList(this.choices.get(0));
                    break;
                }
                default: {
                    choices = Collections.unmodifiableList(new ArrayList<PollChoice>(this.choices));
                }
            }
            return new Poll(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, choices, this.isBitsVotingEnabled, this.bitsPerVote, this.isChannelPointsVotingEnabled, this.channelPointsPerVote, this.status, this.durationSeconds, this.startedAt, this.endedAt);
        }

        public String toString() {
            return "Poll.PollBuilder(id=" + this.id + ", broadcasterId=" + this.broadcasterId + ", broadcasterName=" + this.broadcasterName + ", broadcasterLogin=" + this.broadcasterLogin + ", title=" + this.title + ", choices=" + this.choices + ", isBitsVotingEnabled=" + this.isBitsVotingEnabled + ", bitsPerVote=" + this.bitsPerVote + ", isChannelPointsVotingEnabled=" + this.isChannelPointsVotingEnabled + ", channelPointsPerVote=" + this.channelPointsPerVote + ", status=" + this.status + ", durationSeconds=" + this.durationSeconds + ", startedAt=" + this.startedAt + ", endedAt=" + this.endedAt + ")";
        }
    }
}

