/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.philippheuer.credentialmanager.CredentialManager;
import com.github.philippheuer.credentialmanager.CredentialManagerBuilder;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.auth.TwitchAuth;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.config.Twitch4JGlobal;
import com.github.twitch4j.common.util.BucketUtils;
import com.github.twitch4j.common.util.CryptoUtils;
import com.github.twitch4j.common.util.ThreadUtils;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.helix.TwitchHelix;
import com.github.twitch4j.helix.TwitchHelixErrorDecoder;
import com.github.twitch4j.helix.domain.CustomReward;
import com.github.twitch4j.helix.interceptor.CustomRewardEncodeMixIn;
import com.github.twitch4j.helix.interceptor.TwitchHelixClientIdInterceptor;
import com.github.twitch4j.helix.interceptor.TwitchHelixDecoder;
import com.github.twitch4j.helix.interceptor.TwitchHelixHttpClient;
import com.github.twitch4j.helix.interceptor.TwitchHelixRateLimitTracker;
import com.github.twitch4j.helix.interceptor.TwitchHelixTokenManager;
import com.netflix.config.ConfigurationManager;
import feign.Client;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.hystrix.HystrixFeign;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import io.github.bucket4j.Bandwidth;
import java.time.Duration;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchHelixBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwitchHelixBuilder.class);
    public static final String OFFICIAL_BASE_URL = "https://api.twitch.tv/helix";
    public static final String MOCK_BASE_URL = "http://localhost:8080/mock";
    public static final Bandwidth DEFAULT_BANDWIDTH = BucketUtils.simple((long)800L, (Duration)Duration.ofMinutes(1L));
    private String clientId = Twitch4JGlobal.clientId;
    private String clientSecret = Twitch4JGlobal.clientSecret;
    private String redirectUrl = "http://localhost";
    private CredentialManager credentialManager = null;
    private String userAgent = Twitch4JGlobal.userAgent;
    private OAuth2Credential defaultAuthToken = null;
    private Integer requestQueueSize = -1;
    private String baseUrl = "https://api.twitch.tv/helix";
    private Integer timeout = 5000;
    private Logger.Level logLevel = Logger.Level.NONE;
    private ProxyConfig proxyConfig = null;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = null;
    private Bandwidth apiRateLimit = DEFAULT_BANDWIDTH;

    public static TwitchHelixBuilder builder() {
        return new TwitchHelixBuilder();
    }

    public TwitchHelix build() {
        log.debug("Helix: Initializing Module ...");
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.isolation.thread.timeoutInMilliseconds", (Object)this.timeout);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.requestCache.enabled", (Object)false);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.threadpool.default.maxQueueSize", (Object)this.getRequestQueueSize());
        ConfigurationManager.getConfigInstance().setProperty("hystrix.threadpool.default.queueSizeRejectionThreshold", (Object)this.getRequestQueueSize());
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.TwitchHelix#banUser(String,String,String,BanUserInput).circuitBreaker.enabled", (Object)false);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.TwitchHelix#unbanUser(String,String,String,String).circuitBreaker.enabled", (Object)false);
        if (this.logLevel == Logger.Level.HEADERS || this.logLevel == Logger.Level.FULL) {
            log.warn("Helix: The current feign loglevel will print sensitive information including your access token, please don't share this log!");
        }
        ObjectMapper mapper = TypeConvert.getObjectMapper();
        ObjectMapper serializer = mapper.copy().addMixIn(CustomReward.class, CustomRewardEncodeMixIn.class);
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (this.proxyConfig != null) {
            this.proxyConfig.apply(clientBuilder);
        }
        if (this.scheduledThreadPoolExecutor == null) {
            this.scheduledThreadPoolExecutor = ThreadUtils.getDefaultScheduledThreadPoolExecutor((String)("twitch4j-" + CryptoUtils.generateNonce((int)4)), (Integer)1);
        }
        if (this.apiRateLimit == null) {
            this.apiRateLimit = DEFAULT_BANDWIDTH;
        }
        if (this.credentialManager == null) {
            this.credentialManager = CredentialManagerBuilder.builder().build();
        }
        TwitchAuth.registerIdentityProvider((CredentialManager)this.credentialManager, (String)this.clientId, (String)this.clientSecret, (String)this.redirectUrl, (boolean)MOCK_BASE_URL.equals(this.baseUrl));
        TwitchHelixTokenManager tokenManager = new TwitchHelixTokenManager(this.credentialManager, this.clientId, this.clientSecret, this.defaultAuthToken);
        TwitchHelixRateLimitTracker rateLimitTracker = new TwitchHelixRateLimitTracker(this.apiRateLimit, tokenManager);
        return (TwitchHelix)HystrixFeign.builder().client((Client)new TwitchHelixHttpClient(new OkHttpClient(clientBuilder.build()), this.scheduledThreadPoolExecutor, tokenManager, rateLimitTracker, this.timeout)).encoder((Encoder)new JacksonEncoder(serializer)).decoder((Decoder)new TwitchHelixDecoder(mapper, rateLimitTracker)).logger((feign.Logger)new Slf4jLogger()).logLevel(this.logLevel).errorDecoder((ErrorDecoder)new TwitchHelixErrorDecoder((Decoder)new JacksonDecoder(), rateLimitTracker)).requestInterceptor((RequestInterceptor)new TwitchHelixClientIdInterceptor(this.userAgent, tokenManager)).options(new Request.Options((long)(this.timeout / 3), TimeUnit.MILLISECONDS, (long)this.timeout.intValue(), TimeUnit.MILLISECONDS, true)).retryer((Retryer)new Retryer.Default(500L, (long)this.timeout.intValue(), 2)).decodeVoid().target(TwitchHelix.class, this.baseUrl);
    }

    @Generated
    private TwitchHelixBuilder() {
    }

    @Generated
    private TwitchHelixBuilder(String clientId, String clientSecret, String redirectUrl, CredentialManager credentialManager, String userAgent, OAuth2Credential defaultAuthToken, Integer requestQueueSize, String baseUrl, Integer timeout, Logger.Level logLevel, ProxyConfig proxyConfig, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, Bandwidth apiRateLimit) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUrl = redirectUrl;
        this.credentialManager = credentialManager;
        this.userAgent = userAgent;
        this.defaultAuthToken = defaultAuthToken;
        this.requestQueueSize = requestQueueSize;
        this.baseUrl = baseUrl;
        this.timeout = timeout;
        this.logLevel = logLevel;
        this.proxyConfig = proxyConfig;
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        this.apiRateLimit = apiRateLimit;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @Generated
    public CredentialManager getCredentialManager() {
        return this.credentialManager;
    }

    @Generated
    public String getUserAgent() {
        return this.userAgent;
    }

    @Generated
    public OAuth2Credential getDefaultAuthToken() {
        return this.defaultAuthToken;
    }

    @Generated
    public Integer getRequestQueueSize() {
        return this.requestQueueSize;
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public Integer getTimeout() {
        return this.timeout;
    }

    @Generated
    public Logger.Level getLogLevel() {
        return this.logLevel;
    }

    @Generated
    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    @Generated
    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    @Generated
    public Bandwidth getApiRateLimit() {
        return this.apiRateLimit;
    }

    @Generated
    public TwitchHelixBuilder withClientId(String clientId) {
        return this.clientId == clientId ? this : new TwitchHelixBuilder(clientId, this.clientSecret, this.redirectUrl, this.credentialManager, this.userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor, this.apiRateLimit);
    }

    @Generated
    public TwitchHelixBuilder withClientSecret(String clientSecret) {
        return this.clientSecret == clientSecret ? this : new TwitchHelixBuilder(this.clientId, clientSecret, this.redirectUrl, this.credentialManager, this.userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor, this.apiRateLimit);
    }

    @Generated
    public TwitchHelixBuilder withRedirectUrl(String redirectUrl) {
        return this.redirectUrl == redirectUrl ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, redirectUrl, this.credentialManager, this.userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor, this.apiRateLimit);
    }

    @Generated
    public TwitchHelixBuilder withCredentialManager(CredentialManager credentialManager) {
        return this.credentialManager == credentialManager ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, this.redirectUrl, credentialManager, this.userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor, this.apiRateLimit);
    }

    @Generated
    public TwitchHelixBuilder withUserAgent(String userAgent) {
        return this.userAgent == userAgent ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, this.redirectUrl, this.credentialManager, userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor, this.apiRateLimit);
    }

    @Generated
    public TwitchHelixBuilder withDefaultAuthToken(OAuth2Credential defaultAuthToken) {
        return this.defaultAuthToken == defaultAuthToken ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, this.redirectUrl, this.credentialManager, this.userAgent, defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor, this.apiRateLimit);
    }

    @Generated
    public TwitchHelixBuilder withRequestQueueSize(Integer requestQueueSize) {
        return this.requestQueueSize == requestQueueSize ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, this.redirectUrl, this.credentialManager, this.userAgent, this.defaultAuthToken, requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor, this.apiRateLimit);
    }

    @Generated
    public TwitchHelixBuilder withBaseUrl(String baseUrl) {
        return this.baseUrl == baseUrl ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, this.redirectUrl, this.credentialManager, this.userAgent, this.defaultAuthToken, this.requestQueueSize, baseUrl, this.timeout, this.logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor, this.apiRateLimit);
    }

    @Generated
    public TwitchHelixBuilder withTimeout(Integer timeout) {
        return this.timeout == timeout ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, this.redirectUrl, this.credentialManager, this.userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, timeout, this.logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor, this.apiRateLimit);
    }

    @Generated
    public TwitchHelixBuilder withLogLevel(Logger.Level logLevel) {
        return this.logLevel == logLevel ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, this.redirectUrl, this.credentialManager, this.userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor, this.apiRateLimit);
    }

    @Generated
    public TwitchHelixBuilder withProxyConfig(ProxyConfig proxyConfig) {
        return this.proxyConfig == proxyConfig ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, this.redirectUrl, this.credentialManager, this.userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, proxyConfig, this.scheduledThreadPoolExecutor, this.apiRateLimit);
    }

    @Generated
    public TwitchHelixBuilder withScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        return this.scheduledThreadPoolExecutor == scheduledThreadPoolExecutor ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, this.redirectUrl, this.credentialManager, this.userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig, scheduledThreadPoolExecutor, this.apiRateLimit);
    }

    @Generated
    public TwitchHelixBuilder withApiRateLimit(Bandwidth apiRateLimit) {
        return this.apiRateLimit == apiRateLimit ? this : new TwitchHelixBuilder(this.clientId, this.clientSecret, this.redirectUrl, this.credentialManager, this.userAgent, this.defaultAuthToken, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig, this.scheduledThreadPoolExecutor, apiRateLimit);
    }
}

