/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.twitch4j.common.enums.SubscriptionPlan;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class Emote {
    private String id;
    private String name;
    @Nullable
    private Images images;
    @Nullable
    private String emoteSetId;
    private List<Format> format;
    private List<Scale> scale;
    private List<Theme> themeMode;
    @Nullable
    private String ownerId;
    @Nullable
    private String emoteType;
    @Nullable
    private SubscriptionPlan tier;

    @NonNull
    public Type getParsedEmoteType() {
        return Type.parseEmoteType(this.emoteType != null ? this.emoteType : "");
    }

    @Generated
    public Emote() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Nullable
    @Generated
    public Images getImages() {
        return this.images;
    }

    @Nullable
    @Generated
    public String getEmoteSetId() {
        return this.emoteSetId;
    }

    @Generated
    public List<Format> getFormat() {
        return this.format;
    }

    @Generated
    public List<Scale> getScale() {
        return this.scale;
    }

    @Generated
    public List<Theme> getThemeMode() {
        return this.themeMode;
    }

    @Nullable
    @Generated
    public String getOwnerId() {
        return this.ownerId;
    }

    @Nullable
    @Generated
    public String getEmoteType() {
        return this.emoteType;
    }

    @Nullable
    @Generated
    public SubscriptionPlan getTier() {
        return this.tier;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Emote)) {
            return false;
        }
        Emote other = (Emote)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Images this$images = this.getImages();
        Images other$images = other.getImages();
        if (this$images == null ? other$images != null : !((Object)this$images).equals(other$images)) {
            return false;
        }
        String this$emoteSetId = this.getEmoteSetId();
        String other$emoteSetId = other.getEmoteSetId();
        if (this$emoteSetId == null ? other$emoteSetId != null : !this$emoteSetId.equals(other$emoteSetId)) {
            return false;
        }
        List<Format> this$format = this.getFormat();
        List<Format> other$format = other.getFormat();
        if (this$format == null ? other$format != null : !((Object)this$format).equals(other$format)) {
            return false;
        }
        List<Scale> this$scale = this.getScale();
        List<Scale> other$scale = other.getScale();
        if (this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale)) {
            return false;
        }
        List<Theme> this$themeMode = this.getThemeMode();
        List<Theme> other$themeMode = other.getThemeMode();
        if (this$themeMode == null ? other$themeMode != null : !((Object)this$themeMode).equals(other$themeMode)) {
            return false;
        }
        String this$ownerId = this.getOwnerId();
        String other$ownerId = other.getOwnerId();
        if (this$ownerId == null ? other$ownerId != null : !this$ownerId.equals(other$ownerId)) {
            return false;
        }
        String this$emoteType = this.getEmoteType();
        String other$emoteType = other.getEmoteType();
        if (this$emoteType == null ? other$emoteType != null : !this$emoteType.equals(other$emoteType)) {
            return false;
        }
        SubscriptionPlan this$tier = this.getTier();
        SubscriptionPlan other$tier = other.getTier();
        return !(this$tier == null ? other$tier != null : !this$tier.equals(other$tier));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Emote;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Images $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        String $emoteSetId = this.getEmoteSetId();
        result = result * 59 + ($emoteSetId == null ? 43 : $emoteSetId.hashCode());
        List<Format> $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)$format).hashCode());
        List<Scale> $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        List<Theme> $themeMode = this.getThemeMode();
        result = result * 59 + ($themeMode == null ? 43 : ((Object)$themeMode).hashCode());
        String $ownerId = this.getOwnerId();
        result = result * 59 + ($ownerId == null ? 43 : $ownerId.hashCode());
        String $emoteType = this.getEmoteType();
        result = result * 59 + ($emoteType == null ? 43 : $emoteType.hashCode());
        SubscriptionPlan $tier = this.getTier();
        result = result * 59 + ($tier == null ? 43 : $tier.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Emote(id=" + this.getId() + ", name=" + this.getName() + ", images=" + this.getImages() + ", emoteSetId=" + this.getEmoteSetId() + ", format=" + this.getFormat() + ", scale=" + this.getScale() + ", themeMode=" + this.getThemeMode() + ", ownerId=" + this.getOwnerId() + ", emoteType=" + this.getEmoteType() + ", tier=" + this.getTier() + ")";
    }

    @Generated
    private void setId(String id) {
        this.id = id;
    }

    @Generated
    private void setName(String name) {
        this.name = name;
    }

    @Generated
    private void setImages(@Nullable Images images) {
        this.images = images;
    }

    @Generated
    private void setEmoteSetId(@Nullable String emoteSetId) {
        this.emoteSetId = emoteSetId;
    }

    @Generated
    private void setFormat(List<Format> format) {
        this.format = format;
    }

    @Generated
    private void setScale(List<Scale> scale) {
        this.scale = scale;
    }

    @Generated
    private void setThemeMode(List<Theme> themeMode) {
        this.themeMode = themeMode;
    }

    @Generated
    private void setOwnerId(@Nullable String ownerId) {
        this.ownerId = ownerId;
    }

    @Generated
    private void setEmoteType(@Nullable String emoteType) {
        this.emoteType = emoteType;
    }

    @Generated
    private void setTier(@Nullable SubscriptionPlan tier) {
        this.tier = tier;
    }

    public static enum Type {
        ARCHIVE,
        BITS_TIER,
        CHANNEL_POINTS,
        FOLLOWER,
        GLOBALS,
        HYPE_TRAIN,
        LIMITED_TIME("limitedtime", "owl2019"),
        NONE,
        PRIME("prime", "turbo"),
        REWARDS("rewards", "megacommerce", "megacheer"),
        SMILIES,
        SUBSCRIPTIONS,
        TWO_FACTOR,
        OTHER;

        @NonNull
        private final String[] twitchStrings;
        private static final Map<String, Type> MAPPINGS;

        private Type() {
            this.twitchStrings = new String[]{this.name().toLowerCase().replace("_", "")};
        }

        private Type(String ... names) {
            this.twitchStrings = names;
        }

        @NonNull
        public static Type parseEmoteType(String emoteType) {
            return MAPPINGS.getOrDefault(emoteType, OTHER);
        }

        static {
            HashMap<String, Type> map = new HashMap<String, Type>();
            for (Type emoteType : Type.values()) {
                for (String twitchString : emoteType.twitchStrings) {
                    map.put(twitchString, emoteType);
                }
            }
            MAPPINGS = Collections.unmodifiableMap(map);
        }
    }

    public static class Images {
        @JsonProperty(value="url_1x")
        private String smallImageUrl;
        @JsonProperty(value="url_2x")
        private String mediumImageUrl;
        @JsonProperty(value="url_4x")
        private String largeImageUrl;

        @Generated
        public Images() {
        }

        @Generated
        public String getSmallImageUrl() {
            return this.smallImageUrl;
        }

        @Generated
        public String getMediumImageUrl() {
            return this.mediumImageUrl;
        }

        @Generated
        public String getLargeImageUrl() {
            return this.largeImageUrl;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Images)) {
                return false;
            }
            Images other = (Images)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$smallImageUrl = this.getSmallImageUrl();
            String other$smallImageUrl = other.getSmallImageUrl();
            if (this$smallImageUrl == null ? other$smallImageUrl != null : !this$smallImageUrl.equals(other$smallImageUrl)) {
                return false;
            }
            String this$mediumImageUrl = this.getMediumImageUrl();
            String other$mediumImageUrl = other.getMediumImageUrl();
            if (this$mediumImageUrl == null ? other$mediumImageUrl != null : !this$mediumImageUrl.equals(other$mediumImageUrl)) {
                return false;
            }
            String this$largeImageUrl = this.getLargeImageUrl();
            String other$largeImageUrl = other.getLargeImageUrl();
            return !(this$largeImageUrl == null ? other$largeImageUrl != null : !this$largeImageUrl.equals(other$largeImageUrl));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Images;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $smallImageUrl = this.getSmallImageUrl();
            result = result * 59 + ($smallImageUrl == null ? 43 : $smallImageUrl.hashCode());
            String $mediumImageUrl = this.getMediumImageUrl();
            result = result * 59 + ($mediumImageUrl == null ? 43 : $mediumImageUrl.hashCode());
            String $largeImageUrl = this.getLargeImageUrl();
            result = result * 59 + ($largeImageUrl == null ? 43 : $largeImageUrl.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Emote.Images(smallImageUrl=" + this.getSmallImageUrl() + ", mediumImageUrl=" + this.getMediumImageUrl() + ", largeImageUrl=" + this.getLargeImageUrl() + ")";
        }

        @JsonProperty(value="url_1x")
        @Generated
        private void setSmallImageUrl(String smallImageUrl) {
            this.smallImageUrl = smallImageUrl;
        }

        @JsonProperty(value="url_2x")
        @Generated
        private void setMediumImageUrl(String mediumImageUrl) {
            this.mediumImageUrl = mediumImageUrl;
        }

        @JsonProperty(value="url_4x")
        @Generated
        private void setLargeImageUrl(String largeImageUrl) {
            this.largeImageUrl = largeImageUrl;
        }
    }

    public static enum Theme {
        DARK,
        LIGHT;

    }

    public static enum Scale {
        SMALL("1.0"),
        MEDIUM("2.0"),
        LARGE("3.0");

        private final String twitchString;

        @Generated
        private Scale(String twitchString) {
            this.twitchString = twitchString;
        }

        @Generated
        public String getTwitchString() {
            return this.twitchString;
        }
    }

    public static enum Format {
        DEFAULT,
        STATIC,
        ANIMATED;

    }
}

