/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.github.twitch4j.eventsub.domain.PredictionOutcome;
import com.github.twitch4j.eventsub.domain.PredictionStatus;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=PredictionBuilder.class)
public class Prediction {
    private String id;
    private String broadcasterId;
    private String broadcasterName;
    private String broadcasterLogin;
    private String title;
    @Nullable
    private String winningOutcomeId;
    private List<PredictionOutcome> outcomes;
    @JsonProperty(value="prediction_window")
    private Integer predictionWindowSeconds;
    private PredictionStatus status;
    private Instant createdAt;
    @Nullable
    private Instant endedAt;
    @Nullable
    private Instant lockedAt;

    @JsonIgnore
    @Nullable
    public Duration getPredictionWindow() {
        return this.predictionWindowSeconds != null ? Duration.ofSeconds(this.predictionWindowSeconds.longValue()) : null;
    }

    @JsonIgnore
    public Optional<PredictionOutcome> getWinningOutcome() {
        if (this.winningOutcomeId != null) {
            for (PredictionOutcome outcome : this.getOutcomes()) {
                if (outcome == null || !this.winningOutcomeId.equals(outcome.getId())) continue;
                return Optional.of(outcome);
            }
        }
        return Optional.empty();
    }

    @Generated
    public static PredictionBuilder builder() {
        return new PredictionBuilder();
    }

    @Generated
    public PredictionBuilder toBuilder() {
        PredictionBuilder builder = new PredictionBuilder().id(this.id).broadcasterId(this.broadcasterId).broadcasterName(this.broadcasterName).broadcasterLogin(this.broadcasterLogin).title(this.title).winningOutcomeId(this.winningOutcomeId).predictionWindowSeconds(this.predictionWindowSeconds).status(this.status).createdAt(this.createdAt).endedAt(this.endedAt).lockedAt(this.lockedAt);
        if (this.outcomes != null) {
            builder.outcomes(this.outcomes);
        }
        return builder;
    }

    @Generated
    public Prediction withId(String id) {
        return this.id == id ? this : new Prediction(id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.winningOutcomeId, this.outcomes, this.predictionWindowSeconds, this.status, this.createdAt, this.endedAt, this.lockedAt);
    }

    @Generated
    public Prediction withBroadcasterId(String broadcasterId) {
        return this.broadcasterId == broadcasterId ? this : new Prediction(this.id, broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.winningOutcomeId, this.outcomes, this.predictionWindowSeconds, this.status, this.createdAt, this.endedAt, this.lockedAt);
    }

    @Generated
    public Prediction withBroadcasterName(String broadcasterName) {
        return this.broadcasterName == broadcasterName ? this : new Prediction(this.id, this.broadcasterId, broadcasterName, this.broadcasterLogin, this.title, this.winningOutcomeId, this.outcomes, this.predictionWindowSeconds, this.status, this.createdAt, this.endedAt, this.lockedAt);
    }

    @Generated
    public Prediction withBroadcasterLogin(String broadcasterLogin) {
        return this.broadcasterLogin == broadcasterLogin ? this : new Prediction(this.id, this.broadcasterId, this.broadcasterName, broadcasterLogin, this.title, this.winningOutcomeId, this.outcomes, this.predictionWindowSeconds, this.status, this.createdAt, this.endedAt, this.lockedAt);
    }

    @Generated
    public Prediction withTitle(String title) {
        return this.title == title ? this : new Prediction(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, title, this.winningOutcomeId, this.outcomes, this.predictionWindowSeconds, this.status, this.createdAt, this.endedAt, this.lockedAt);
    }

    @Generated
    public Prediction withWinningOutcomeId(@Nullable String winningOutcomeId) {
        return this.winningOutcomeId == winningOutcomeId ? this : new Prediction(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, winningOutcomeId, this.outcomes, this.predictionWindowSeconds, this.status, this.createdAt, this.endedAt, this.lockedAt);
    }

    @Generated
    public Prediction withOutcomes(List<PredictionOutcome> outcomes) {
        return this.outcomes == outcomes ? this : new Prediction(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.winningOutcomeId, outcomes, this.predictionWindowSeconds, this.status, this.createdAt, this.endedAt, this.lockedAt);
    }

    @Generated
    public Prediction withPredictionWindowSeconds(Integer predictionWindowSeconds) {
        return this.predictionWindowSeconds == predictionWindowSeconds ? this : new Prediction(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.winningOutcomeId, this.outcomes, predictionWindowSeconds, this.status, this.createdAt, this.endedAt, this.lockedAt);
    }

    @Generated
    public Prediction withStatus(PredictionStatus status) {
        return this.status == status ? this : new Prediction(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.winningOutcomeId, this.outcomes, this.predictionWindowSeconds, status, this.createdAt, this.endedAt, this.lockedAt);
    }

    @Generated
    public Prediction withCreatedAt(Instant createdAt) {
        return this.createdAt == createdAt ? this : new Prediction(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.winningOutcomeId, this.outcomes, this.predictionWindowSeconds, this.status, createdAt, this.endedAt, this.lockedAt);
    }

    @Generated
    public Prediction withEndedAt(@Nullable Instant endedAt) {
        return this.endedAt == endedAt ? this : new Prediction(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.winningOutcomeId, this.outcomes, this.predictionWindowSeconds, this.status, this.createdAt, endedAt, this.lockedAt);
    }

    @Generated
    public Prediction withLockedAt(@Nullable Instant lockedAt) {
        return this.lockedAt == lockedAt ? this : new Prediction(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.winningOutcomeId, this.outcomes, this.predictionWindowSeconds, this.status, this.createdAt, this.endedAt, lockedAt);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getBroadcasterId() {
        return this.broadcasterId;
    }

    @Generated
    public String getBroadcasterName() {
        return this.broadcasterName;
    }

    @Generated
    public String getBroadcasterLogin() {
        return this.broadcasterLogin;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Nullable
    @Generated
    public String getWinningOutcomeId() {
        return this.winningOutcomeId;
    }

    @Generated
    public List<PredictionOutcome> getOutcomes() {
        return this.outcomes;
    }

    @Generated
    public Integer getPredictionWindowSeconds() {
        return this.predictionWindowSeconds;
    }

    @Generated
    public PredictionStatus getStatus() {
        return this.status;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @Generated
    public Instant getEndedAt() {
        return this.endedAt;
    }

    @Nullable
    @Generated
    public Instant getLockedAt() {
        return this.lockedAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Prediction)) {
            return false;
        }
        Prediction other = (Prediction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$predictionWindowSeconds = this.getPredictionWindowSeconds();
        Integer other$predictionWindowSeconds = other.getPredictionWindowSeconds();
        if (this$predictionWindowSeconds == null ? other$predictionWindowSeconds != null : !((Object)this$predictionWindowSeconds).equals(other$predictionWindowSeconds)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$broadcasterId = this.getBroadcasterId();
        String other$broadcasterId = other.getBroadcasterId();
        if (this$broadcasterId == null ? other$broadcasterId != null : !this$broadcasterId.equals(other$broadcasterId)) {
            return false;
        }
        String this$broadcasterName = this.getBroadcasterName();
        String other$broadcasterName = other.getBroadcasterName();
        if (this$broadcasterName == null ? other$broadcasterName != null : !this$broadcasterName.equals(other$broadcasterName)) {
            return false;
        }
        String this$broadcasterLogin = this.getBroadcasterLogin();
        String other$broadcasterLogin = other.getBroadcasterLogin();
        if (this$broadcasterLogin == null ? other$broadcasterLogin != null : !this$broadcasterLogin.equals(other$broadcasterLogin)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$winningOutcomeId = this.getWinningOutcomeId();
        String other$winningOutcomeId = other.getWinningOutcomeId();
        if (this$winningOutcomeId == null ? other$winningOutcomeId != null : !this$winningOutcomeId.equals(other$winningOutcomeId)) {
            return false;
        }
        List<PredictionOutcome> this$outcomes = this.getOutcomes();
        List<PredictionOutcome> other$outcomes = other.getOutcomes();
        if (this$outcomes == null ? other$outcomes != null : !((Object)this$outcomes).equals(other$outcomes)) {
            return false;
        }
        PredictionStatus this$status = this.getStatus();
        PredictionStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$endedAt = this.getEndedAt();
        Instant other$endedAt = other.getEndedAt();
        if (this$endedAt == null ? other$endedAt != null : !((Object)this$endedAt).equals(other$endedAt)) {
            return false;
        }
        Instant this$lockedAt = this.getLockedAt();
        Instant other$lockedAt = other.getLockedAt();
        return !(this$lockedAt == null ? other$lockedAt != null : !((Object)this$lockedAt).equals(other$lockedAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Prediction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $predictionWindowSeconds = this.getPredictionWindowSeconds();
        result = result * 59 + ($predictionWindowSeconds == null ? 43 : ((Object)$predictionWindowSeconds).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $broadcasterId = this.getBroadcasterId();
        result = result * 59 + ($broadcasterId == null ? 43 : $broadcasterId.hashCode());
        String $broadcasterName = this.getBroadcasterName();
        result = result * 59 + ($broadcasterName == null ? 43 : $broadcasterName.hashCode());
        String $broadcasterLogin = this.getBroadcasterLogin();
        result = result * 59 + ($broadcasterLogin == null ? 43 : $broadcasterLogin.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $winningOutcomeId = this.getWinningOutcomeId();
        result = result * 59 + ($winningOutcomeId == null ? 43 : $winningOutcomeId.hashCode());
        List<PredictionOutcome> $outcomes = this.getOutcomes();
        result = result * 59 + ($outcomes == null ? 43 : ((Object)$outcomes).hashCode());
        PredictionStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $endedAt = this.getEndedAt();
        result = result * 59 + ($endedAt == null ? 43 : ((Object)$endedAt).hashCode());
        Instant $lockedAt = this.getLockedAt();
        result = result * 59 + ($lockedAt == null ? 43 : ((Object)$lockedAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Prediction(id=" + this.getId() + ", broadcasterId=" + this.getBroadcasterId() + ", broadcasterName=" + this.getBroadcasterName() + ", broadcasterLogin=" + this.getBroadcasterLogin() + ", title=" + this.getTitle() + ", winningOutcomeId=" + this.getWinningOutcomeId() + ", outcomes=" + this.getOutcomes() + ", predictionWindowSeconds=" + this.getPredictionWindowSeconds() + ", status=" + this.getStatus() + ", createdAt=" + this.getCreatedAt() + ", endedAt=" + this.getEndedAt() + ", lockedAt=" + this.getLockedAt() + ")";
    }

    @Generated
    private void setId(String id) {
        this.id = id;
    }

    @Generated
    private void setBroadcasterId(String broadcasterId) {
        this.broadcasterId = broadcasterId;
    }

    @Generated
    private void setBroadcasterName(String broadcasterName) {
        this.broadcasterName = broadcasterName;
    }

    @Generated
    private void setBroadcasterLogin(String broadcasterLogin) {
        this.broadcasterLogin = broadcasterLogin;
    }

    @Generated
    private void setTitle(String title) {
        this.title = title;
    }

    @Generated
    private void setWinningOutcomeId(@Nullable String winningOutcomeId) {
        this.winningOutcomeId = winningOutcomeId;
    }

    @Generated
    private void setOutcomes(List<PredictionOutcome> outcomes) {
        this.outcomes = outcomes;
    }

    @JsonProperty(value="prediction_window")
    @Generated
    private void setPredictionWindowSeconds(Integer predictionWindowSeconds) {
        this.predictionWindowSeconds = predictionWindowSeconds;
    }

    @Generated
    private void setStatus(PredictionStatus status) {
        this.status = status;
    }

    @Generated
    private void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    private void setEndedAt(@Nullable Instant endedAt) {
        this.endedAt = endedAt;
    }

    @Generated
    private void setLockedAt(@Nullable Instant lockedAt) {
        this.lockedAt = lockedAt;
    }

    @Generated
    public Prediction() {
    }

    @Generated
    public Prediction(String id, String broadcasterId, String broadcasterName, String broadcasterLogin, String title, @Nullable String winningOutcomeId, List<PredictionOutcome> outcomes, Integer predictionWindowSeconds, PredictionStatus status, Instant createdAt, @Nullable Instant endedAt, @Nullable Instant lockedAt) {
        this.id = id;
        this.broadcasterId = broadcasterId;
        this.broadcasterName = broadcasterName;
        this.broadcasterLogin = broadcasterLogin;
        this.title = title;
        this.winningOutcomeId = winningOutcomeId;
        this.outcomes = outcomes;
        this.predictionWindowSeconds = predictionWindowSeconds;
        this.status = status;
        this.createdAt = createdAt;
        this.endedAt = endedAt;
        this.lockedAt = lockedAt;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class PredictionBuilder {
        @Generated
        private String id;
        @Generated
        private String broadcasterId;
        @Generated
        private String broadcasterName;
        @Generated
        private String broadcasterLogin;
        @Generated
        private String title;
        @Generated
        private String winningOutcomeId;
        @Generated
        private ArrayList<PredictionOutcome> outcomes;
        @Generated
        private Integer predictionWindowSeconds;
        @Generated
        private PredictionStatus status;
        @Generated
        private Instant createdAt;
        @Generated
        private Instant endedAt;
        @Generated
        private Instant lockedAt;

        @Generated
        PredictionBuilder() {
        }

        @Generated
        public PredictionBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public PredictionBuilder broadcasterId(String broadcasterId) {
            this.broadcasterId = broadcasterId;
            return this;
        }

        @Generated
        public PredictionBuilder broadcasterName(String broadcasterName) {
            this.broadcasterName = broadcasterName;
            return this;
        }

        @Generated
        public PredictionBuilder broadcasterLogin(String broadcasterLogin) {
            this.broadcasterLogin = broadcasterLogin;
            return this;
        }

        @Generated
        public PredictionBuilder title(String title) {
            this.title = title;
            return this;
        }

        @Generated
        public PredictionBuilder winningOutcomeId(@Nullable String winningOutcomeId) {
            this.winningOutcomeId = winningOutcomeId;
            return this;
        }

        @Generated
        public PredictionBuilder outcome(PredictionOutcome outcome) {
            if (this.outcomes == null) {
                this.outcomes = new ArrayList();
            }
            this.outcomes.add(outcome);
            return this;
        }

        @Generated
        public PredictionBuilder outcomes(Collection<? extends PredictionOutcome> outcomes) {
            if (outcomes == null) {
                throw new NullPointerException("outcomes cannot be null");
            }
            if (this.outcomes == null) {
                this.outcomes = new ArrayList();
            }
            this.outcomes.addAll(outcomes);
            return this;
        }

        @Generated
        public PredictionBuilder clearOutcomes() {
            if (this.outcomes != null) {
                this.outcomes.clear();
            }
            return this;
        }

        @JsonProperty(value="prediction_window")
        @Generated
        public PredictionBuilder predictionWindowSeconds(Integer predictionWindowSeconds) {
            this.predictionWindowSeconds = predictionWindowSeconds;
            return this;
        }

        @Generated
        public PredictionBuilder status(PredictionStatus status) {
            this.status = status;
            return this;
        }

        @Generated
        public PredictionBuilder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public PredictionBuilder endedAt(@Nullable Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        @Generated
        public PredictionBuilder lockedAt(@Nullable Instant lockedAt) {
            this.lockedAt = lockedAt;
            return this;
        }

        @Generated
        public Prediction build() {
            List<PredictionOutcome> outcomes;
            switch (this.outcomes == null ? 0 : this.outcomes.size()) {
                case 0: {
                    outcomes = Collections.emptyList();
                    break;
                }
                case 1: {
                    outcomes = Collections.singletonList(this.outcomes.get(0));
                    break;
                }
                default: {
                    outcomes = Collections.unmodifiableList(new ArrayList<PredictionOutcome>(this.outcomes));
                }
            }
            return new Prediction(this.id, this.broadcasterId, this.broadcasterName, this.broadcasterLogin, this.title, this.winningOutcomeId, outcomes, this.predictionWindowSeconds, this.status, this.createdAt, this.endedAt, this.lockedAt);
        }

        @Generated
        public String toString() {
            return "Prediction.PredictionBuilder(id=" + this.id + ", broadcasterId=" + this.broadcasterId + ", broadcasterName=" + this.broadcasterName + ", broadcasterLogin=" + this.broadcasterLogin + ", title=" + this.title + ", winningOutcomeId=" + this.winningOutcomeId + ", outcomes=" + this.outcomes + ", predictionWindowSeconds=" + this.predictionWindowSeconds + ", status=" + this.status + ", createdAt=" + this.createdAt + ", endedAt=" + this.endedAt + ", lockedAt=" + this.lockedAt + ")";
        }
    }
}

