/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=ExtensionBitsProductBuilder.class)
public class ExtensionBitsProduct {
    private String sku;
    private Cost cost;
    @JsonProperty(value="in_development")
    private Boolean isInDevelopment;
    private String displayName;
    private Instant expiration;
    @JsonProperty(value="is_broadcast")
    private Boolean isBroadcast;

    public static ExtensionBitsProductBuilder builder() {
        return new ExtensionBitsProductBuilder();
    }

    public ExtensionBitsProductBuilder toBuilder() {
        return new ExtensionBitsProductBuilder().sku(this.sku).cost(this.cost).isInDevelopment(this.isInDevelopment).displayName(this.displayName).expiration(this.expiration).isBroadcast(this.isBroadcast);
    }

    public ExtensionBitsProduct withSku(String sku) {
        return this.sku == sku ? this : new ExtensionBitsProduct(sku, this.cost, this.isInDevelopment, this.displayName, this.expiration, this.isBroadcast);
    }

    public ExtensionBitsProduct withCost(Cost cost) {
        return this.cost == cost ? this : new ExtensionBitsProduct(this.sku, cost, this.isInDevelopment, this.displayName, this.expiration, this.isBroadcast);
    }

    public ExtensionBitsProduct withIsInDevelopment(Boolean isInDevelopment) {
        return this.isInDevelopment == isInDevelopment ? this : new ExtensionBitsProduct(this.sku, this.cost, isInDevelopment, this.displayName, this.expiration, this.isBroadcast);
    }

    public ExtensionBitsProduct withDisplayName(String displayName) {
        return this.displayName == displayName ? this : new ExtensionBitsProduct(this.sku, this.cost, this.isInDevelopment, displayName, this.expiration, this.isBroadcast);
    }

    public ExtensionBitsProduct withExpiration(Instant expiration) {
        return this.expiration == expiration ? this : new ExtensionBitsProduct(this.sku, this.cost, this.isInDevelopment, this.displayName, expiration, this.isBroadcast);
    }

    public ExtensionBitsProduct withIsBroadcast(Boolean isBroadcast) {
        return this.isBroadcast == isBroadcast ? this : new ExtensionBitsProduct(this.sku, this.cost, this.isInDevelopment, this.displayName, this.expiration, isBroadcast);
    }

    public String getSku() {
        return this.sku;
    }

    public Cost getCost() {
        return this.cost;
    }

    public Boolean isInDevelopment() {
        return this.isInDevelopment;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public Boolean isBroadcast() {
        return this.isBroadcast;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtensionBitsProduct)) {
            return false;
        }
        ExtensionBitsProduct other = (ExtensionBitsProduct)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isInDevelopment = this.isInDevelopment();
        Boolean other$isInDevelopment = other.isInDevelopment();
        if (this$isInDevelopment == null ? other$isInDevelopment != null : !((Object)this$isInDevelopment).equals(other$isInDevelopment)) {
            return false;
        }
        Boolean this$isBroadcast = this.isBroadcast();
        Boolean other$isBroadcast = other.isBroadcast();
        if (this$isBroadcast == null ? other$isBroadcast != null : !((Object)this$isBroadcast).equals(other$isBroadcast)) {
            return false;
        }
        String this$sku = this.getSku();
        String other$sku = other.getSku();
        if (this$sku == null ? other$sku != null : !this$sku.equals(other$sku)) {
            return false;
        }
        Cost this$cost = this.getCost();
        Cost other$cost = other.getCost();
        if (this$cost == null ? other$cost != null : !((Object)this$cost).equals(other$cost)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Instant this$expiration = this.getExpiration();
        Instant other$expiration = other.getExpiration();
        return !(this$expiration == null ? other$expiration != null : !((Object)this$expiration).equals(other$expiration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExtensionBitsProduct;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isInDevelopment = this.isInDevelopment();
        result = result * 59 + ($isInDevelopment == null ? 43 : ((Object)$isInDevelopment).hashCode());
        Boolean $isBroadcast = this.isBroadcast();
        result = result * 59 + ($isBroadcast == null ? 43 : ((Object)$isBroadcast).hashCode());
        String $sku = this.getSku();
        result = result * 59 + ($sku == null ? 43 : $sku.hashCode());
        Cost $cost = this.getCost();
        result = result * 59 + ($cost == null ? 43 : ((Object)$cost).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Instant $expiration = this.getExpiration();
        result = result * 59 + ($expiration == null ? 43 : ((Object)$expiration).hashCode());
        return result;
    }

    public String toString() {
        return "ExtensionBitsProduct(sku=" + this.getSku() + ", cost=" + this.getCost() + ", isInDevelopment=" + this.isInDevelopment() + ", displayName=" + this.getDisplayName() + ", expiration=" + this.getExpiration() + ", isBroadcast=" + this.isBroadcast() + ")";
    }

    private void setSku(String sku) {
        this.sku = sku;
    }

    private void setCost(Cost cost) {
        this.cost = cost;
    }

    @JsonProperty(value="in_development")
    private ExtensionBitsProduct isInDevelopment(Boolean isInDevelopment) {
        this.isInDevelopment = isInDevelopment;
        return this;
    }

    private void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    private void setExpiration(Instant expiration) {
        this.expiration = expiration;
    }

    @JsonProperty(value="is_broadcast")
    private ExtensionBitsProduct isBroadcast(Boolean isBroadcast) {
        this.isBroadcast = isBroadcast;
        return this;
    }

    public ExtensionBitsProduct() {
    }

    public ExtensionBitsProduct(String sku, Cost cost, Boolean isInDevelopment, String displayName, Instant expiration, Boolean isBroadcast) {
        this.sku = sku;
        this.cost = cost;
        this.isInDevelopment = isInDevelopment;
        this.displayName = displayName;
        this.expiration = expiration;
        this.isBroadcast = isBroadcast;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ExtensionBitsProductBuilder {
        private String sku;
        private Cost cost;
        private Boolean isInDevelopment;
        private String displayName;
        private Instant expiration;
        private Boolean isBroadcast;

        ExtensionBitsProductBuilder() {
        }

        public ExtensionBitsProductBuilder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public ExtensionBitsProductBuilder cost(Cost cost) {
            this.cost = cost;
            return this;
        }

        @JsonProperty(value="in_development")
        public ExtensionBitsProductBuilder isInDevelopment(Boolean isInDevelopment) {
            this.isInDevelopment = isInDevelopment;
            return this;
        }

        public ExtensionBitsProductBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ExtensionBitsProductBuilder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        @JsonProperty(value="is_broadcast")
        public ExtensionBitsProductBuilder isBroadcast(Boolean isBroadcast) {
            this.isBroadcast = isBroadcast;
            return this;
        }

        public ExtensionBitsProduct build() {
            return new ExtensionBitsProduct(this.sku, this.cost, this.isInDevelopment, this.displayName, this.expiration, this.isBroadcast);
        }

        public String toString() {
            return "ExtensionBitsProduct.ExtensionBitsProductBuilder(sku=" + this.sku + ", cost=" + this.cost + ", isInDevelopment=" + this.isInDevelopment + ", displayName=" + this.displayName + ", expiration=" + this.expiration + ", isBroadcast=" + this.isBroadcast + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonDeserialize(builder=CostBuilder.class)
    public static class Cost {
        private Integer amount;
        private String type;

        private static String $default$type() {
            return "bits";
        }

        public static CostBuilder builder() {
            return new CostBuilder();
        }

        public CostBuilder toBuilder() {
            return new CostBuilder().amount(this.amount).type(this.type);
        }

        public Cost withAmount(Integer amount) {
            return this.amount == amount ? this : new Cost(amount, this.type);
        }

        public Cost withType(String type) {
            return this.type == type ? this : new Cost(this.amount, type);
        }

        public Integer getAmount() {
            return this.amount;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cost)) {
                return false;
            }
            Cost other = (Cost)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$amount = this.getAmount();
            Integer other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Cost;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "ExtensionBitsProduct.Cost(amount=" + this.getAmount() + ", type=" + this.getType() + ")";
        }

        private void setAmount(Integer amount) {
            this.amount = amount;
        }

        private void setType(String type) {
            this.type = type;
        }

        public Cost() {
            this.type = Cost.$default$type();
        }

        public Cost(Integer amount, String type) {
            this.amount = amount;
            this.type = type;
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class CostBuilder {
            private Integer amount;
            private boolean type$set;
            private String type$value;

            CostBuilder() {
            }

            public CostBuilder amount(Integer amount) {
                this.amount = amount;
                return this;
            }

            public CostBuilder type(String type) {
                this.type$value = type;
                this.type$set = true;
                return this;
            }

            public Cost build() {
                String type$value = this.type$value;
                if (!this.type$set) {
                    type$value = Cost.$default$type();
                }
                return new Cost(this.amount, type$value);
            }

            public String toString() {
                return "ExtensionBitsProduct.Cost.CostBuilder(amount=" + this.amount + ", type$value=" + this.type$value + ")";
            }
        }
    }
}

