/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=ScheduleSegmentInputBuilder.class)
public class ScheduleSegmentInput {
    private Instant startTime;
    private String timezone;
    @JsonProperty(value="is_recurring")
    private Boolean recurring;
    @JsonProperty(value="is_canceled")
    private Boolean canceled;
    @JsonProperty(value="duration")
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private Integer durationMinutes;
    private String categoryId;
    private String title;

    public static ScheduleSegmentInputBuilder builder() {
        return new ScheduleSegmentInputBuilder();
    }

    public ScheduleSegmentInputBuilder toBuilder() {
        return new ScheduleSegmentInputBuilder().startTime(this.startTime).timezone(this.timezone).recurring(this.recurring).canceled(this.canceled).durationMinutes(this.durationMinutes).categoryId(this.categoryId).title(this.title);
    }

    public ScheduleSegmentInput withStartTime(Instant startTime) {
        return this.startTime == startTime ? this : new ScheduleSegmentInput(startTime, this.timezone, this.recurring, this.canceled, this.durationMinutes, this.categoryId, this.title);
    }

    public ScheduleSegmentInput withTimezone(String timezone) {
        return this.timezone == timezone ? this : new ScheduleSegmentInput(this.startTime, timezone, this.recurring, this.canceled, this.durationMinutes, this.categoryId, this.title);
    }

    public ScheduleSegmentInput withRecurring(Boolean recurring) {
        return this.recurring == recurring ? this : new ScheduleSegmentInput(this.startTime, this.timezone, recurring, this.canceled, this.durationMinutes, this.categoryId, this.title);
    }

    public ScheduleSegmentInput withCanceled(Boolean canceled) {
        return this.canceled == canceled ? this : new ScheduleSegmentInput(this.startTime, this.timezone, this.recurring, canceled, this.durationMinutes, this.categoryId, this.title);
    }

    public ScheduleSegmentInput withDurationMinutes(Integer durationMinutes) {
        return this.durationMinutes == durationMinutes ? this : new ScheduleSegmentInput(this.startTime, this.timezone, this.recurring, this.canceled, durationMinutes, this.categoryId, this.title);
    }

    public ScheduleSegmentInput withCategoryId(String categoryId) {
        return this.categoryId == categoryId ? this : new ScheduleSegmentInput(this.startTime, this.timezone, this.recurring, this.canceled, this.durationMinutes, categoryId, this.title);
    }

    public ScheduleSegmentInput withTitle(String title) {
        return this.title == title ? this : new ScheduleSegmentInput(this.startTime, this.timezone, this.recurring, this.canceled, this.durationMinutes, this.categoryId, title);
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public Boolean getRecurring() {
        return this.recurring;
    }

    public Boolean getCanceled() {
        return this.canceled;
    }

    public Integer getDurationMinutes() {
        return this.durationMinutes;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduleSegmentInput)) {
            return false;
        }
        ScheduleSegmentInput other = (ScheduleSegmentInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$recurring = this.getRecurring();
        Boolean other$recurring = other.getRecurring();
        if (this$recurring == null ? other$recurring != null : !((Object)this$recurring).equals(other$recurring)) {
            return false;
        }
        Boolean this$canceled = this.getCanceled();
        Boolean other$canceled = other.getCanceled();
        if (this$canceled == null ? other$canceled != null : !((Object)this$canceled).equals(other$canceled)) {
            return false;
        }
        Integer this$durationMinutes = this.getDurationMinutes();
        Integer other$durationMinutes = other.getDurationMinutes();
        if (this$durationMinutes == null ? other$durationMinutes != null : !((Object)this$durationMinutes).equals(other$durationMinutes)) {
            return false;
        }
        Instant this$startTime = this.getStartTime();
        Instant other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        if (this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone)) {
            return false;
        }
        String this$categoryId = this.getCategoryId();
        String other$categoryId = other.getCategoryId();
        if (this$categoryId == null ? other$categoryId != null : !this$categoryId.equals(other$categoryId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        return !(this$title == null ? other$title != null : !this$title.equals(other$title));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScheduleSegmentInput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $recurring = this.getRecurring();
        result = result * 59 + ($recurring == null ? 43 : ((Object)$recurring).hashCode());
        Boolean $canceled = this.getCanceled();
        result = result * 59 + ($canceled == null ? 43 : ((Object)$canceled).hashCode());
        Integer $durationMinutes = this.getDurationMinutes();
        result = result * 59 + ($durationMinutes == null ? 43 : ((Object)$durationMinutes).hashCode());
        Instant $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        String $categoryId = this.getCategoryId();
        result = result * 59 + ($categoryId == null ? 43 : $categoryId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        return result;
    }

    public String toString() {
        return "ScheduleSegmentInput(startTime=" + this.getStartTime() + ", timezone=" + this.getTimezone() + ", recurring=" + this.getRecurring() + ", canceled=" + this.getCanceled() + ", durationMinutes=" + this.getDurationMinutes() + ", categoryId=" + this.getCategoryId() + ", title=" + this.getTitle() + ")";
    }

    private void setStartTime(Instant startTime) {
        this.startTime = startTime;
    }

    private void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @JsonProperty(value="is_recurring")
    private void setRecurring(Boolean recurring) {
        this.recurring = recurring;
    }

    @JsonProperty(value="is_canceled")
    private void setCanceled(Boolean canceled) {
        this.canceled = canceled;
    }

    @JsonProperty(value="duration")
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private void setDurationMinutes(Integer durationMinutes) {
        this.durationMinutes = durationMinutes;
    }

    private void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    private void setTitle(String title) {
        this.title = title;
    }

    public ScheduleSegmentInput() {
    }

    public ScheduleSegmentInput(Instant startTime, String timezone, Boolean recurring, Boolean canceled, Integer durationMinutes, String categoryId, String title) {
        this.startTime = startTime;
        this.timezone = timezone;
        this.recurring = recurring;
        this.canceled = canceled;
        this.durationMinutes = durationMinutes;
        this.categoryId = categoryId;
        this.title = title;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ScheduleSegmentInputBuilder {
        private Instant startTime;
        private String timezone;
        private Boolean recurring;
        private Boolean canceled;
        private Integer durationMinutes;
        private String categoryId;
        private String title;

        ScheduleSegmentInputBuilder() {
        }

        public ScheduleSegmentInputBuilder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public ScheduleSegmentInputBuilder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @JsonProperty(value="is_recurring")
        public ScheduleSegmentInputBuilder recurring(Boolean recurring) {
            this.recurring = recurring;
            return this;
        }

        @JsonProperty(value="is_canceled")
        public ScheduleSegmentInputBuilder canceled(Boolean canceled) {
            this.canceled = canceled;
            return this;
        }

        @JsonProperty(value="duration")
        @JsonFormat(shape=JsonFormat.Shape.STRING)
        public ScheduleSegmentInputBuilder durationMinutes(Integer durationMinutes) {
            this.durationMinutes = durationMinutes;
            return this;
        }

        public ScheduleSegmentInputBuilder categoryId(String categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public ScheduleSegmentInputBuilder title(String title) {
            this.title = title;
            return this;
        }

        public ScheduleSegmentInput build() {
            return new ScheduleSegmentInput(this.startTime, this.timezone, this.recurring, this.canceled, this.durationMinutes, this.categoryId, this.title);
        }

        public String toString() {
            return "ScheduleSegmentInput.ScheduleSegmentInputBuilder(startTime=" + this.startTime + ", timezone=" + this.timezone + ", recurring=" + this.recurring + ", canceled=" + this.canceled + ", durationMinutes=" + this.durationMinutes + ", categoryId=" + this.categoryId + ", title=" + this.title + ")";
        }
    }
}

