/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.github.twitch4j.helix.domain.DropFulfillmentStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=UpdateDropEntitlementInputBuilder.class)
public class UpdateDropEntitlementInput {
    private DropFulfillmentStatus fulfillmentStatus;
    private List<String> entitlementIds;

    public static UpdateDropEntitlementInputBuilder builder() {
        return new UpdateDropEntitlementInputBuilder();
    }

    public UpdateDropEntitlementInputBuilder toBuilder() {
        UpdateDropEntitlementInputBuilder builder = new UpdateDropEntitlementInputBuilder().fulfillmentStatus(this.fulfillmentStatus);
        if (this.entitlementIds != null) {
            builder.entitlementIds(this.entitlementIds);
        }
        return builder;
    }

    public UpdateDropEntitlementInput withFulfillmentStatus(DropFulfillmentStatus fulfillmentStatus) {
        return this.fulfillmentStatus == fulfillmentStatus ? this : new UpdateDropEntitlementInput(fulfillmentStatus, this.entitlementIds);
    }

    public UpdateDropEntitlementInput withEntitlementIds(List<String> entitlementIds) {
        return this.entitlementIds == entitlementIds ? this : new UpdateDropEntitlementInput(this.fulfillmentStatus, entitlementIds);
    }

    public DropFulfillmentStatus getFulfillmentStatus() {
        return this.fulfillmentStatus;
    }

    public List<String> getEntitlementIds() {
        return this.entitlementIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateDropEntitlementInput)) {
            return false;
        }
        UpdateDropEntitlementInput other = (UpdateDropEntitlementInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DropFulfillmentStatus this$fulfillmentStatus = this.getFulfillmentStatus();
        DropFulfillmentStatus other$fulfillmentStatus = other.getFulfillmentStatus();
        if (this$fulfillmentStatus == null ? other$fulfillmentStatus != null : !((Object)((Object)this$fulfillmentStatus)).equals((Object)other$fulfillmentStatus)) {
            return false;
        }
        List<String> this$entitlementIds = this.getEntitlementIds();
        List<String> other$entitlementIds = other.getEntitlementIds();
        return !(this$entitlementIds == null ? other$entitlementIds != null : !((Object)this$entitlementIds).equals(other$entitlementIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateDropEntitlementInput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DropFulfillmentStatus $fulfillmentStatus = this.getFulfillmentStatus();
        result = result * 59 + ($fulfillmentStatus == null ? 43 : ((Object)((Object)$fulfillmentStatus)).hashCode());
        List<String> $entitlementIds = this.getEntitlementIds();
        result = result * 59 + ($entitlementIds == null ? 43 : ((Object)$entitlementIds).hashCode());
        return result;
    }

    public String toString() {
        return "UpdateDropEntitlementInput(fulfillmentStatus=" + (Object)((Object)this.getFulfillmentStatus()) + ", entitlementIds=" + this.getEntitlementIds() + ")";
    }

    private void setFulfillmentStatus(DropFulfillmentStatus fulfillmentStatus) {
        this.fulfillmentStatus = fulfillmentStatus;
    }

    private void setEntitlementIds(List<String> entitlementIds) {
        this.entitlementIds = entitlementIds;
    }

    public UpdateDropEntitlementInput() {
    }

    public UpdateDropEntitlementInput(DropFulfillmentStatus fulfillmentStatus, List<String> entitlementIds) {
        this.fulfillmentStatus = fulfillmentStatus;
        this.entitlementIds = entitlementIds;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class UpdateDropEntitlementInputBuilder {
        private DropFulfillmentStatus fulfillmentStatus;
        private ArrayList<String> entitlementIds;

        UpdateDropEntitlementInputBuilder() {
        }

        public UpdateDropEntitlementInputBuilder fulfillmentStatus(DropFulfillmentStatus fulfillmentStatus) {
            this.fulfillmentStatus = fulfillmentStatus;
            return this;
        }

        public UpdateDropEntitlementInputBuilder entitlementId(String entitlementId) {
            if (this.entitlementIds == null) {
                this.entitlementIds = new ArrayList();
            }
            this.entitlementIds.add(entitlementId);
            return this;
        }

        public UpdateDropEntitlementInputBuilder entitlementIds(Collection<? extends String> entitlementIds) {
            if (entitlementIds == null) {
                throw new NullPointerException("entitlementIds cannot be null");
            }
            if (this.entitlementIds == null) {
                this.entitlementIds = new ArrayList();
            }
            this.entitlementIds.addAll(entitlementIds);
            return this;
        }

        public UpdateDropEntitlementInputBuilder clearEntitlementIds() {
            if (this.entitlementIds != null) {
                this.entitlementIds.clear();
            }
            return this;
        }

        public UpdateDropEntitlementInput build() {
            List<String> entitlementIds;
            switch (this.entitlementIds == null ? 0 : this.entitlementIds.size()) {
                case 0: {
                    entitlementIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    entitlementIds = Collections.singletonList(this.entitlementIds.get(0));
                    break;
                }
                default: {
                    entitlementIds = Collections.unmodifiableList(new ArrayList<String>(this.entitlementIds));
                }
            }
            return new UpdateDropEntitlementInput(this.fulfillmentStatus, entitlementIds);
        }

        public String toString() {
            return "UpdateDropEntitlementInput.UpdateDropEntitlementInputBuilder(fulfillmentStatus=" + (Object)((Object)this.fulfillmentStatus) + ", entitlementIds=" + this.entitlementIds + ")";
        }
    }
}

