/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.kraken;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.config.Twitch4JGlobal;
import com.github.twitch4j.common.feign.interceptor.JsonContentTypeHeaderInterceptor;
import com.github.twitch4j.common.feign.interceptor.TwitchClientIdInterceptor;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.kraken.TwitchKraken;
import com.github.twitch4j.kraken.TwitchKrakenErrorDecoder;
import com.netflix.config.ConfigurationManager;
import feign.Client;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.hystrix.HystrixFeign;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class TwitchKrakenBuilder {
    private static final Logger log = LoggerFactory.getLogger(TwitchKrakenBuilder.class);
    private String clientId = Twitch4JGlobal.clientId;
    private String clientSecret = Twitch4JGlobal.clientSecret;
    private String userAgent = Twitch4JGlobal.userAgent;
    private Integer requestQueueSize = -1;
    private String baseUrl = "https://api.twitch.tv/kraken";
    private Integer timeout = 5000;
    private Integer uploadTimeout = 240000;
    private Logger.Level logLevel = Logger.Level.NONE;
    private ProxyConfig proxyConfig = null;

    public static TwitchKrakenBuilder builder() {
        return new TwitchKrakenBuilder();
    }

    @Deprecated
    public TwitchKraken build() {
        log.warn("Kraken is deprecated and has been shut down on Febuary 28, 2022.");
        log.warn("More details about the decommission are available here: https://blog.twitch.tv/en/2021/07/15/legacy-twitch-api-v5-shutdown-details-and-timeline");
        log.debug("Kraken: Initializing Module ...");
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.isolation.thread.timeoutInMilliseconds", (Object)this.timeout);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.requestCache.enabled", (Object)false);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.threadpool.default.maxQueueSize", (Object)this.getRequestQueueSize());
        ConfigurationManager.getConfigInstance().setProperty("hystrix.threadpool.default.queueSizeRejectionThreshold", (Object)this.getRequestQueueSize());
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.TwitchKraken#uploadVideoPart(URI,String,String,int,byte[]).execution.isolation.thread.timeoutInMilliseconds", (Object)this.uploadTimeout);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.TwitchKraken#getChatEmoticonsBySet(Collection).execution.isolation.thread.timeoutInMilliseconds", (Object)(this.timeout * 2));
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.TwitchKraken#getChatEmoticons().execution.isolation.thread.timeoutInMilliseconds", (Object)(this.timeout * 4));
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.TwitchKraken#getAllChatEmoticons().execution.isolation.thread.timeoutInMilliseconds", (Object)(this.timeout * 8));
        if (this.logLevel == Logger.Level.HEADERS || this.logLevel == Logger.Level.FULL) {
            log.warn("Kraken: The current feign loglevel will print sensitive information including your access token, please don't share this log!");
        }
        ObjectMapper mapper = TypeConvert.getObjectMapper();
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (this.proxyConfig != null) {
            this.proxyConfig.apply(clientBuilder);
        }
        return (TwitchKraken)HystrixFeign.builder().client((Client)new OkHttpClient(clientBuilder.build())).encoder((Encoder)new JacksonEncoder(mapper)).decoder((Decoder)new JacksonDecoder(mapper)).logger((feign.Logger)new Slf4jLogger()).logLevel(this.logLevel).errorDecoder((ErrorDecoder)new TwitchKrakenErrorDecoder((Decoder)new JacksonDecoder())).requestInterceptor((RequestInterceptor)new TwitchClientIdInterceptor(this.clientId, this.userAgent)).requestInterceptor(t -> t.header("Accept", new String[]{"application/vnd.twitchtv.v5+json"})).requestInterceptor((RequestInterceptor)new JsonContentTypeHeaderInterceptor()).options(new Request.Options((long)(this.timeout / 3), TimeUnit.MILLISECONDS, (long)this.timeout.intValue(), TimeUnit.MILLISECONDS, true)).retryer((Retryer)new Retryer.Default(500L, (long)this.timeout.intValue(), 2)).target(TwitchKraken.class, this.baseUrl);
    }

    private TwitchKrakenBuilder() {
    }

    private TwitchKrakenBuilder(String clientId, String clientSecret, String userAgent, Integer requestQueueSize, String baseUrl, Integer timeout, Integer uploadTimeout, Logger.Level logLevel, ProxyConfig proxyConfig) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.userAgent = userAgent;
        this.requestQueueSize = requestQueueSize;
        this.baseUrl = baseUrl;
        this.timeout = timeout;
        this.uploadTimeout = uploadTimeout;
        this.logLevel = logLevel;
        this.proxyConfig = proxyConfig;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Integer getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getUploadTimeout() {
        return this.uploadTimeout;
    }

    public Logger.Level getLogLevel() {
        return this.logLevel;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public TwitchKrakenBuilder withClientId(String clientId) {
        return this.clientId == clientId ? this : new TwitchKrakenBuilder(clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.uploadTimeout, this.logLevel, this.proxyConfig);
    }

    public TwitchKrakenBuilder withClientSecret(String clientSecret) {
        return this.clientSecret == clientSecret ? this : new TwitchKrakenBuilder(this.clientId, clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.uploadTimeout, this.logLevel, this.proxyConfig);
    }

    public TwitchKrakenBuilder withUserAgent(String userAgent) {
        return this.userAgent == userAgent ? this : new TwitchKrakenBuilder(this.clientId, this.clientSecret, userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.uploadTimeout, this.logLevel, this.proxyConfig);
    }

    public TwitchKrakenBuilder withRequestQueueSize(Integer requestQueueSize) {
        return this.requestQueueSize == requestQueueSize ? this : new TwitchKrakenBuilder(this.clientId, this.clientSecret, this.userAgent, requestQueueSize, this.baseUrl, this.timeout, this.uploadTimeout, this.logLevel, this.proxyConfig);
    }

    public TwitchKrakenBuilder withBaseUrl(String baseUrl) {
        return this.baseUrl == baseUrl ? this : new TwitchKrakenBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, baseUrl, this.timeout, this.uploadTimeout, this.logLevel, this.proxyConfig);
    }

    public TwitchKrakenBuilder withTimeout(Integer timeout) {
        return this.timeout == timeout ? this : new TwitchKrakenBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, timeout, this.uploadTimeout, this.logLevel, this.proxyConfig);
    }

    public TwitchKrakenBuilder withUploadTimeout(Integer uploadTimeout) {
        return this.uploadTimeout == uploadTimeout ? this : new TwitchKrakenBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, uploadTimeout, this.logLevel, this.proxyConfig);
    }

    public TwitchKrakenBuilder withLogLevel(Logger.Level logLevel) {
        return this.logLevel == logLevel ? this : new TwitchKrakenBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.uploadTimeout, logLevel, this.proxyConfig);
    }

    public TwitchKrakenBuilder withProxyConfig(ProxyConfig proxyConfig) {
        return this.proxyConfig == proxyConfig ? this : new TwitchKrakenBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.uploadTimeout, this.logLevel, proxyConfig);
    }
}

