/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.tmi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.config.Twitch4JGlobal;
import com.github.twitch4j.common.feign.interceptor.TwitchClientIdInterceptor;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.tmi.TwitchMessagingInterface;
import com.github.twitch4j.tmi.TwitchMessagingInterfaceErrorDecoder;
import com.netflix.config.ConfigurationManager;
import feign.Client;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.hystrix.HystrixFeign;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchMessagingInterfaceBuilder {
    private static final Logger log = LoggerFactory.getLogger(TwitchMessagingInterfaceBuilder.class);
    private String clientId = Twitch4JGlobal.clientId;
    private String clientSecret = Twitch4JGlobal.clientSecret;
    private String userAgent = Twitch4JGlobal.userAgent;
    private Integer requestQueueSize = -1;
    private String baseUrl = "https://tmi.twitch.tv";
    private Integer timeout = 5000;
    private Logger.Level logLevel = Logger.Level.NONE;
    private ProxyConfig proxyConfig = null;

    public static TwitchMessagingInterfaceBuilder builder() {
        return new TwitchMessagingInterfaceBuilder();
    }

    @Deprecated
    public TwitchMessagingInterface build() {
        log.debug("TMI: Initializing Module ...");
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.isolation.thread.timeoutInMilliseconds", (Object)this.timeout);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.requestCache.enabled", (Object)false);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.threadpool.default.maxQueueSize", (Object)this.getRequestQueueSize());
        ConfigurationManager.getConfigInstance().setProperty("hystrix.threadpool.default.queueSizeRejectionThreshold", (Object)this.getRequestQueueSize());
        if (this.logLevel == Logger.Level.HEADERS || this.logLevel == Logger.Level.FULL) {
            log.warn("TMI: The current feign loglevel will print sensitive information including your access token, please don't share this log!");
        }
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (this.proxyConfig != null) {
            this.proxyConfig.apply(clientBuilder);
        }
        ObjectMapper mapper = TypeConvert.getObjectMapper();
        TwitchMessagingInterface client = (TwitchMessagingInterface)HystrixFeign.builder().client((Client)new OkHttpClient(clientBuilder.build())).encoder((Encoder)new JacksonEncoder(mapper)).decoder((Decoder)new JacksonDecoder(mapper)).logger((feign.Logger)new Slf4jLogger()).logLevel(this.logLevel).errorDecoder((ErrorDecoder)new TwitchMessagingInterfaceErrorDecoder((Decoder)new JacksonDecoder())).requestInterceptor((RequestInterceptor)new TwitchClientIdInterceptor(this.clientId, this.userAgent)).retryer((Retryer)new Retryer.Default(1L, 10000L, 3)).options(new Request.Options(5000L, TimeUnit.MILLISECONDS, 15000L, TimeUnit.MILLISECONDS, true)).target(TwitchMessagingInterface.class, this.baseUrl);
        return client;
    }

    private TwitchMessagingInterfaceBuilder() {
    }

    private TwitchMessagingInterfaceBuilder(String clientId, String clientSecret, String userAgent, Integer requestQueueSize, String baseUrl, Integer timeout, Logger.Level logLevel, ProxyConfig proxyConfig) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.userAgent = userAgent;
        this.requestQueueSize = requestQueueSize;
        this.baseUrl = baseUrl;
        this.timeout = timeout;
        this.logLevel = logLevel;
        this.proxyConfig = proxyConfig;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Integer getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Logger.Level getLogLevel() {
        return this.logLevel;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public TwitchMessagingInterfaceBuilder withClientId(String clientId) {
        return this.clientId == clientId ? this : new TwitchMessagingInterfaceBuilder(clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig);
    }

    public TwitchMessagingInterfaceBuilder withClientSecret(String clientSecret) {
        return this.clientSecret == clientSecret ? this : new TwitchMessagingInterfaceBuilder(this.clientId, clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig);
    }

    public TwitchMessagingInterfaceBuilder withUserAgent(String userAgent) {
        return this.userAgent == userAgent ? this : new TwitchMessagingInterfaceBuilder(this.clientId, this.clientSecret, userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig);
    }

    public TwitchMessagingInterfaceBuilder withRequestQueueSize(Integer requestQueueSize) {
        return this.requestQueueSize == requestQueueSize ? this : new TwitchMessagingInterfaceBuilder(this.clientId, this.clientSecret, this.userAgent, requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig);
    }

    public TwitchMessagingInterfaceBuilder withTimeout(Integer timeout) {
        return this.timeout == timeout ? this : new TwitchMessagingInterfaceBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, timeout, this.logLevel, this.proxyConfig);
    }

    public TwitchMessagingInterfaceBuilder withLogLevel(Logger.Level logLevel) {
        return this.logLevel == logLevel ? this : new TwitchMessagingInterfaceBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, logLevel, this.proxyConfig);
    }

    public TwitchMessagingInterfaceBuilder withProxyConfig(ProxyConfig proxyConfig) {
        return this.proxyConfig == proxyConfig ? this : new TwitchMessagingInterfaceBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, proxyConfig);
    }
}

