/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub;

import com.github.philippheuer.events4j.api.service.IEventHandler;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.philippheuer.events4j.simple.SimpleEventHandler;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.util.EventManagerUtils;
import com.github.twitch4j.common.util.ThreadUtils;
import com.github.twitch4j.pubsub.TwitchPubSub;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchPubSubBuilder {
    private static final Logger log = LoggerFactory.getLogger(TwitchPubSubBuilder.class);
    private EventManager eventManager = null;
    private Class<? extends IEventHandler> defaultEventHandler = SimpleEventHandler.class;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = null;
    private ProxyConfig proxyConfig = null;
    private Collection<String> botOwnerIds = new HashSet<String>();

    public static TwitchPubSubBuilder builder() {
        return new TwitchPubSubBuilder();
    }

    public TwitchPubSub build() {
        log.debug("PubSub: Initializing Module ...");
        if (this.scheduledThreadPoolExecutor == null) {
            this.scheduledThreadPoolExecutor = ThreadUtils.getDefaultScheduledThreadPoolExecutor((String)("twitch4j-pubsub-" + RandomStringUtils.random((int)4, (boolean)true, (boolean)true)), (Integer)1);
        }
        this.eventManager = EventManagerUtils.validateOrInitializeEventManager((EventManager)this.eventManager, this.defaultEventHandler);
        return new TwitchPubSub(this.eventManager, this.scheduledThreadPoolExecutor, this.proxyConfig, this.botOwnerIds);
    }

    public TwitchPubSubBuilder withBotOwnerId(String userId) {
        this.botOwnerIds.add(userId);
        return this;
    }

    public TwitchPubSubBuilder withBotOwnerIds(Collection<String> botOwnerIds) {
        this.botOwnerIds.addAll(botOwnerIds);
        return this;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public Class<? extends IEventHandler> getDefaultEventHandler() {
        return this.defaultEventHandler;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public Collection<String> getBotOwnerIds() {
        return this.botOwnerIds;
    }

    private TwitchPubSubBuilder() {
    }

    private TwitchPubSubBuilder(EventManager eventManager, Class<? extends IEventHandler> defaultEventHandler, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, ProxyConfig proxyConfig, Collection<String> botOwnerIds) {
        this.eventManager = eventManager;
        this.defaultEventHandler = defaultEventHandler;
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        this.proxyConfig = proxyConfig;
        this.botOwnerIds = botOwnerIds;
    }

    public TwitchPubSubBuilder withEventManager(EventManager eventManager) {
        return this.eventManager == eventManager ? this : new TwitchPubSubBuilder(eventManager, this.defaultEventHandler, this.scheduledThreadPoolExecutor, this.proxyConfig, this.botOwnerIds);
    }

    public TwitchPubSubBuilder withDefaultEventHandler(Class<? extends IEventHandler> defaultEventHandler) {
        return this.defaultEventHandler == defaultEventHandler ? this : new TwitchPubSubBuilder(this.eventManager, defaultEventHandler, this.scheduledThreadPoolExecutor, this.proxyConfig, this.botOwnerIds);
    }

    public TwitchPubSubBuilder withScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        return this.scheduledThreadPoolExecutor == scheduledThreadPoolExecutor ? this : new TwitchPubSubBuilder(this.eventManager, this.defaultEventHandler, scheduledThreadPoolExecutor, this.proxyConfig, this.botOwnerIds);
    }

    public TwitchPubSubBuilder withProxyConfig(ProxyConfig proxyConfig) {
        return this.proxyConfig == proxyConfig ? this : new TwitchPubSubBuilder(this.eventManager, this.defaultEventHandler, this.scheduledThreadPoolExecutor, proxyConfig, this.botOwnerIds);
    }

    public TwitchPubSubBuilder setBotOwnerIds(Collection<String> botOwnerIds) {
        this.botOwnerIds = botOwnerIds;
        return this;
    }
}

