/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.twitch4j.common.events.TwitchEvent;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.pubsub.domain.HypeLevelUp;
import com.github.twitch4j.pubsub.domain.HypeProgression;
import com.github.twitch4j.pubsub.domain.HypeTrainApproaching;
import com.github.twitch4j.pubsub.domain.HypeTrainConductor;
import com.github.twitch4j.pubsub.domain.HypeTrainEnd;
import com.github.twitch4j.pubsub.domain.HypeTrainRewardsData;
import com.github.twitch4j.pubsub.domain.HypeTrainStart;
import com.github.twitch4j.pubsub.domain.SupportActivityFeedData;
import com.github.twitch4j.pubsub.events.HypeTrainApproachingEvent;
import com.github.twitch4j.pubsub.events.HypeTrainConductorUpdateEvent;
import com.github.twitch4j.pubsub.events.HypeTrainCooldownExpirationEvent;
import com.github.twitch4j.pubsub.events.HypeTrainEndEvent;
import com.github.twitch4j.pubsub.events.HypeTrainLevelUpEvent;
import com.github.twitch4j.pubsub.events.HypeTrainProgressionEvent;
import com.github.twitch4j.pubsub.events.HypeTrainRewardsEvent;
import com.github.twitch4j.pubsub.events.HypeTrainStartEvent;
import com.github.twitch4j.pubsub.events.SupportActivityFeedEvent;
import com.github.twitch4j.pubsub.handlers.TopicHandler;
import java.util.Arrays;
import java.util.Collection;

class TrainHandler
implements TopicHandler {
    TrainHandler() {
    }

    @Override
    public String topicName() {
        return "hype-train-events-v2";
    }

    @Override
    public Collection<String> topicNames() {
        return Arrays.asList(this.topicName(), "hype-train-events-v1");
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args) {
        String[] topicParts = args.getTopicParts();
        if (topicParts.length > 2 && "rewards".equals(topicParts[1])) {
            return new HypeTrainRewardsEvent((HypeTrainRewardsData)TypeConvert.convertValue((Object)args.getData(), HypeTrainRewardsData.class));
        }
        JsonNode msgData = args.getData();
        String lastTopicIdentifier = args.getLastTopicPart();
        switch (args.getType()) {
            case "hype-train-approaching": {
                HypeTrainApproaching approachData = (HypeTrainApproaching)TypeConvert.convertValue((Object)msgData, HypeTrainApproaching.class);
                return new HypeTrainApproachingEvent(approachData);
            }
            case "hype-train-start": {
                HypeTrainStart startData = (HypeTrainStart)TypeConvert.convertValue((Object)msgData, HypeTrainStart.class);
                return new HypeTrainStartEvent(lastTopicIdentifier, startData);
            }
            case "hype-train-progression": {
                HypeProgression progressionData = (HypeProgression)TypeConvert.convertValue((Object)msgData, HypeProgression.class);
                return new HypeTrainProgressionEvent(lastTopicIdentifier, progressionData);
            }
            case "hype-train-level-up": {
                HypeLevelUp levelUpData = (HypeLevelUp)TypeConvert.convertValue((Object)msgData, HypeLevelUp.class);
                return new HypeTrainLevelUpEvent(lastTopicIdentifier, levelUpData);
            }
            case "hype-train-end": {
                HypeTrainEnd endData = (HypeTrainEnd)TypeConvert.convertValue((Object)msgData, HypeTrainEnd.class);
                return new HypeTrainEndEvent(lastTopicIdentifier, endData);
            }
            case "hype-train-conductor-update": {
                HypeTrainConductor conductorData = (HypeTrainConductor)TypeConvert.convertValue((Object)msgData, HypeTrainConductor.class);
                return new HypeTrainConductorUpdateEvent(lastTopicIdentifier, conductorData);
            }
            case "hype-train-cooldown-expiration": {
                return new HypeTrainCooldownExpirationEvent(lastTopicIdentifier);
            }
            case "last-x-experiment-event": {
                SupportActivityFeedData lastData = (SupportActivityFeedData)TypeConvert.convertValue((Object)msgData, SupportActivityFeedData.class);
                return new SupportActivityFeedEvent(lastTopicIdentifier, lastData);
            }
        }
        return null;
    }
}

