/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub;

import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.pool.TwitchModuleConnectionPool;
import com.github.twitch4j.common.util.CryptoUtils;
import com.github.twitch4j.pubsub.ITwitchPubSub;
import com.github.twitch4j.pubsub.PubSubSubscription;
import com.github.twitch4j.pubsub.TwitchPubSub;
import com.github.twitch4j.pubsub.TwitchPubSubBuilder;
import com.github.twitch4j.pubsub.domain.PubSubRequest;
import com.github.twitch4j.pubsub.events.PubSubAuthRevokeEvent;
import com.github.twitch4j.pubsub.events.PubSubListenResponseEvent;
import com.github.twitch4j.util.IBackoffStrategy;
import java.util.Collection;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class TwitchPubSubConnectionPool
extends TwitchModuleConnectionPool<TwitchPubSub, PubSubRequest, PubSubSubscription, Boolean, TwitchPubSubBuilder>
implements ITwitchPubSub {
    private final String threadPrefix = "twitch4j-pool-" + CryptoUtils.generateNonce((int)4) + "-pubsub-";
    private IBackoffStrategy connectionBackoffStrategy;

    @Override
    public PubSubSubscription listenOnTopic(PubSubRequest request) {
        return this.subscribe(request);
    }

    @Override
    public boolean unsubscribeFromTopic(PubSubSubscription subscription) {
        return (Boolean)this.unsubscribe(subscription);
    }

    public PubSubSubscription subscribe(PubSubRequest pubSubRequest) {
        int topics = TwitchPubSubConnectionPool.getTopicCount(pubSubRequest);
        if (topics <= 0) {
            return null;
        }
        TwitchPubSubConnectionPool.injectNonce(pubSubRequest);
        return (PubSubSubscription)super.subscribe((Object)pubSubRequest);
    }

    protected TwitchPubSub createConnection() {
        if (this.closed.get()) {
            throw new IllegalStateException("PubSub connection cannot be created after pool was closed!");
        }
        TwitchPubSub client = ((TwitchPubSubBuilder)this.advancedConfiguration.apply(TwitchPubSubBuilder.builder().withEventManager(this.getConnectionEventManager()).withScheduledThreadPoolExecutor(this.getExecutor(this.threadPrefix + CryptoUtils.generateNonce((int)4), 1)).withProxyConfig((ProxyConfig)this.proxyConfig.get()).withConnectionBackoffStrategy(this.connectionBackoffStrategy))).build();
        client.getEventManager().onEvent("twitch4j-pubsub-pool-nonce-tracker", PubSubListenResponseEvent.class, e -> {
            if (e.hasError()) {
                e.getListenRequest().map(PubSubSubscription::new).ifPresent(arg_0 -> ((TwitchPubSubConnectionPool)this).unsubscribe(arg_0));
            }
        });
        client.getEventManager().onEvent(this.threadPrefix + "revocation-tracker", PubSubAuthRevokeEvent.class, e -> e.getRevokedListensByTopic().values().forEach(req -> this.unsubscribe(new PubSubSubscription((PubSubRequest)req))));
        return client;
    }

    protected void disposeConnection(TwitchPubSub connection) {
        connection.close();
    }

    protected PubSubSubscription handleSubscription(TwitchPubSub twitchPubSub, PubSubRequest pubSubRequest) {
        return twitchPubSub != null ? twitchPubSub.listenOnTopic(pubSubRequest) : null;
    }

    protected PubSubSubscription handleDuplicateSubscription(TwitchPubSub twitchPubSub, TwitchPubSub old, PubSubRequest pubSubRequest) {
        PubSubSubscription subscription = new PubSubSubscription(pubSubRequest);
        return twitchPubSub != null && twitchPubSub != old && twitchPubSub.unsubscribeFromTopic(subscription) ? subscription : null;
    }

    protected Boolean handleUnsubscription(TwitchPubSub twitchPubSub, PubSubSubscription pubSubSubscription) {
        return twitchPubSub != null ? Boolean.valueOf(twitchPubSub.unsubscribeFromTopic(pubSubSubscription)) : null;
    }

    protected PubSubRequest getRequestFromSubscription(PubSubSubscription subscription) {
        return subscription.getRequest();
    }

    protected int getSubscriptionSize(PubSubRequest pubSubRequest) {
        return TwitchPubSubConnectionPool.getTopicCount(pubSubRequest);
    }

    private static void injectNonce(PubSubRequest req) {
        if (StringUtils.isBlank((CharSequence)req.getNonce())) {
            req.setNonce(CryptoUtils.generateNonce((int)30));
        }
    }

    private static int getTopicCount(PubSubRequest req) {
        Object topics = req.getData().get("topics");
        if (topics instanceof Collection) {
            return ((Collection)topics).size();
        }
        if (topics instanceof Iterable) {
            return (int)StreamSupport.stream(((Iterable)topics).spliterator(), false).count();
        }
        if (topics instanceof Object[]) {
            return ((Object[])topics).length;
        }
        return -1;
    }

    @Override
    public long getLatency() {
        long sum = 0L;
        int count = 0;
        for (TwitchPubSub connection : this.getConnections()) {
            long latency = connection.getLatency();
            if (latency <= 0L) continue;
            sum += latency;
            ++count;
        }
        return count > 0 ? sum / (long)count : -1L;
    }

    @Generated
    private static IBackoffStrategy $default$connectionBackoffStrategy() {
        return null;
    }

    @Generated
    protected TwitchPubSubConnectionPool(TwitchPubSubConnectionPoolBuilder<?, ?> b) {
        super(b);
        this.connectionBackoffStrategy = ((TwitchPubSubConnectionPoolBuilder)b).connectionBackoffStrategy$set ? ((TwitchPubSubConnectionPoolBuilder)b).connectionBackoffStrategy$value : TwitchPubSubConnectionPool.$default$connectionBackoffStrategy();
    }

    @Generated
    public static TwitchPubSubConnectionPoolBuilder<?, ?> builder() {
        return new TwitchPubSubConnectionPoolBuilderImpl();
    }

    @Generated
    public static abstract class TwitchPubSubConnectionPoolBuilder<C extends TwitchPubSubConnectionPool, B extends TwitchPubSubConnectionPoolBuilder<C, B>>
    extends TwitchModuleConnectionPool.TwitchModuleConnectionPoolBuilder<TwitchPubSub, PubSubRequest, PubSubSubscription, Boolean, TwitchPubSubBuilder, C, B> {
        @Generated
        private boolean connectionBackoffStrategy$set;
        @Generated
        private IBackoffStrategy connectionBackoffStrategy$value;

        @Generated
        public B connectionBackoffStrategy(IBackoffStrategy connectionBackoffStrategy) {
            this.connectionBackoffStrategy$value = connectionBackoffStrategy;
            this.connectionBackoffStrategy$set = true;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TwitchPubSubConnectionPool.TwitchPubSubConnectionPoolBuilder(super=" + super.toString() + ", connectionBackoffStrategy$value=" + this.connectionBackoffStrategy$value + ")";
        }
    }

    @Generated
    private static final class TwitchPubSubConnectionPoolBuilderImpl
    extends TwitchPubSubConnectionPoolBuilder<TwitchPubSubConnectionPool, TwitchPubSubConnectionPoolBuilderImpl> {
        @Generated
        private TwitchPubSubConnectionPoolBuilderImpl() {
        }

        @Override
        @Generated
        protected TwitchPubSubConnectionPoolBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TwitchPubSubConnectionPool build() {
            return new TwitchPubSubConnectionPool(this);
        }
    }
}

