/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub.handlers;

import com.github.twitch4j.common.events.TwitchEvent;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.pubsub.domain.CreatedUnbanRequest;
import com.github.twitch4j.pubsub.domain.UpdatedUnbanRequest;
import com.github.twitch4j.pubsub.events.ChannelUnbanRequestCreateEvent;
import com.github.twitch4j.pubsub.events.ChannelUnbanRequestUpdateEvent;
import com.github.twitch4j.pubsub.handlers.TopicHandler;

class UnbanRequestHandler
implements TopicHandler {
    UnbanRequestHandler() {
    }

    @Override
    public String topicName() {
        return "channel-unban-requests";
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args) {
        String[] topicParts = args.getTopicParts();
        if (topicParts.length != 3) {
            return null;
        }
        String userId = topicParts[1];
        String channelId = topicParts[2];
        if ("create_unban_request".equals(args.getType())) {
            CreatedUnbanRequest request = (CreatedUnbanRequest)TypeConvert.convertValue((Object)args.getData(), CreatedUnbanRequest.class);
            return new ChannelUnbanRequestCreateEvent(userId, channelId, request);
        }
        if ("update_unban_request".equals(args.getType())) {
            UpdatedUnbanRequest request = (UpdatedUnbanRequest)TypeConvert.convertValue((Object)args.getData(), UpdatedUnbanRequest.class);
            return new ChannelUnbanRequestUpdateEvent(userId, channelId, request);
        }
        return null;
    }
}

