/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub.handlers;

import com.github.twitch4j.common.events.TwitchEvent;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.pubsub.domain.ClipsLeaderboard;
import com.github.twitch4j.pubsub.domain.Leaderboard;
import com.github.twitch4j.pubsub.events.BitsLeaderboardEvent;
import com.github.twitch4j.pubsub.events.ClipsLeaderboardEvent;
import com.github.twitch4j.pubsub.events.SubLeaderboardEvent;
import com.github.twitch4j.pubsub.handlers.TopicHandler;

class LeaderboardHandler
implements TopicHandler {
    LeaderboardHandler() {
    }

    @Override
    public String topicName() {
        return "leaderboard-events-v1";
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args) {
        if (args.getLastTopicPart().startsWith("clips-")) {
            ClipsLeaderboard clipsLeaderboard = (ClipsLeaderboard)TypeConvert.jsonToObject((String)args.getRawMessage(), ClipsLeaderboard.class);
            return new ClipsLeaderboardEvent(clipsLeaderboard);
        }
        Leaderboard leaderboard = (Leaderboard)TypeConvert.jsonToObject((String)args.getRawMessage(), Leaderboard.class);
        switch (leaderboard.getIdentifier().getDomain()) {
            case "bits-usage-by-channel-v1": {
                return new BitsLeaderboardEvent(leaderboard);
            }
            case "sub-gifts-sent": {
                return new SubLeaderboardEvent(leaderboard);
            }
        }
        return null;
    }
}

