/*
 * Decompiled with CFR 0.152.
 */
package com.github.ug_dbg;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.maven.plugins.annotations.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractMojo
extends org.apache.maven.plugin.AbstractMojo {
    @Parameter(property="log.handler", defaultValue="true")
    private boolean useLogHandler;
    @Parameter(property="log.level", defaultValue="INFO")
    private String logLevel;

    AbstractMojo() {
    }

    Level logLevel() {
        try {
            return Level.parse(this.logLevel);
        }
        catch (RuntimeException e) {
            this.getLog().warn((CharSequence)("Error reading log level [" + this.logLevel + "]. Using INFO."));
            return Level.INFO;
        }
    }

    protected boolean useLogHandler() {
        return this.useLogHandler;
    }

    protected static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    protected static CommandLine getCommand(String name, File home) {
        String cmdValue;
        String string = cmdValue = home == null ? name : new File(home, name).getAbsolutePath();
        if (AbstractMojo.isWindows()) {
            cmdValue = cmdValue + ".cmd";
            CommandLine cmd = new CommandLine("cmd");
            cmd.addArgument("/c");
            cmd.addArgument(cmdValue);
            return cmd;
        }
        return new CommandLine(cmdValue);
    }

    protected static List<String> parseArgument(String argument) {
        Pattern pattern = Pattern.compile("([^\"]\\S*|\".+?\")\\s*");
        Matcher matcher = pattern.matcher(argument);
        ArrayList<String> arguments = new ArrayList<String>();
        while (matcher.find()) {
            arguments.add(matcher.group(1));
        }
        return arguments;
    }
}

