/*
 * Decompiled with CFR 0.152.
 */
package com.github.ug_dbg;

import com.github.ug_dbg.AbstractMojo;
import com.github.ug_dbg.LogHandler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="exec-ng", threadSafe=true, defaultPhase=LifecyclePhase.COMPILE)
public class AngularMojo
extends AbstractMojo {
    @Parameter(property="ng.command")
    private String command;
    @Parameter(property="ng.args")
    private String[] args;
    @Parameter(property="ng.workingDir", defaultValue="${basedir}")
    private File workingDir;
    @Parameter(property="ng.home")
    private File ngHome;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (String arg : this.args) {
            CommandLine cmd = this.addCommand(this.getNGCommand());
            for (String parsedArgument : AngularMojo.parseArgument(arg)) {
                cmd = cmd.addArgument(parsedArgument);
            }
            this.getLog().info((CharSequence)("Executing [" + cmd.toString() + "] in [" + this.workingDir.toString() + "]"));
            this.execute(cmd);
        }
    }

    private void execute(CommandLine cmdLine) throws MojoExecutionException, MojoFailureException {
        try {
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(this.workingDir);
            if (this.useLogHandler()) {
                executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)((Object)new LogHandler.StdOut(this.getLog(), this.logLevel(), "ERROR", "WARNING", "DEBUG")), (OutputStream)((Object)new LogHandler.StdErr(this.getLog(), this.logLevel(), "ERROR", "WARNING", "DEBUG")), System.in));
            }
            executor.execute(cmdLine);
        }
        catch (ExecuteException e) {
            throw new MojoFailureException("Angular ng failure", (Throwable)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error executing Angular ng", (Exception)e);
        }
    }

    private CommandLine addCommand(CommandLine cmdLine) {
        return cmdLine.addArgument(this.command);
    }

    private CommandLine getNGCommand() {
        return AngularMojo.getCommand("ng", this.ngHome);
    }
}

