/*
 * Decompiled with CFR 0.152.
 */
package com.github.ug_dbg;

import com.github.ug_dbg.AbstractMojo;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="clean", threadSafe=true, defaultPhase=LifecyclePhase.CLEAN)
public class CleanMojo
extends AbstractMojo {
    @Parameter(property="npm.workingDir", defaultValue="${basedir}")
    private File workingDir;
    @Parameter(property="npm.distDir", defaultValue="dist")
    private String distDir;
    @Parameter(property="npm.nodeModulesDir", defaultValue="node_modules")
    private String nodeModulesDir;
    @Parameter(property="npm.packageLockFile", defaultValue="package-lock.json")
    private String packageLockFile;
    @Parameter(property="npm.deleteNodeModules", defaultValue="false")
    private boolean deleteNodeModules;
    @Parameter(property="npm.deletePackageLock", defaultValue="false")
    private boolean deletePackageLock;

    public void execute() {
        this.delete(new File(this.workingDir, this.distDir));
        if (this.deleteNodeModules && this.nodeModulesDir != null) {
            this.delete(new File(this.workingDir, this.nodeModulesDir));
        }
        if (this.deletePackageLock && this.packageLockFile != null) {
            this.delete(new File(this.workingDir, this.packageLockFile));
        }
    }

    private void delete(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        try {
            if (file.isDirectory()) {
                FileUtils.deleteDirectory((File)file);
                this.getLog().info((CharSequence)("Deleted directory [" + file.toString() + "] : [OK]"));
            } else {
                boolean status = file.delete();
                this.getLog().info((CharSequence)("Delete [" + file.toString() + "] : [" + (status ? "OK" : "KO") + "]"));
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("I/O Error deleting [" + file.toString() + "]"), (Throwable)e);
        }
        catch (RuntimeException e) {
            this.getLog().error((CharSequence)("Error deleting [" + file.toString() + "]"), (Throwable)e);
        }
    }
}

