/*
 * Decompiled with CFR 0.152.
 */
package com.github.ug_dbg;

import java.util.logging.Level;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

abstract class LogHandler
extends LogOutputStream {
    final Log logger;
    private String errPrefix;
    private String warnPrefix;
    private String debugPrefix;

    LogHandler(Log logger, Level logLevel, String errPrefix, String warnPrefix, String debugPrefix) {
        super(logLevel.intValue());
        this.logger = logger;
        this.errPrefix = errPrefix;
        this.warnPrefix = warnPrefix;
        this.debugPrefix = debugPrefix;
    }

    protected void processLine(String line, int logLevel) {
        if (this.isDebug(line)) {
            this.logger.debug((CharSequence)line);
        } else if (this.isWarn(line)) {
            this.logger.warn((CharSequence)line);
        } else if (this.isError(line)) {
            this.logger.error((CharSequence)line);
        } else {
            this.logDefault(line);
        }
    }

    abstract void logDefault(String var1);

    boolean isError(String line) {
        return StringUtils.startsWithIgnoreCase((CharSequence)line, (CharSequence)this.errPrefix);
    }

    boolean isWarn(String line) {
        return StringUtils.startsWithIgnoreCase((CharSequence)StringUtils.trim((String)line), (CharSequence)this.warnPrefix);
    }

    boolean isDebug(String line) {
        return StringUtils.startsWithIgnoreCase((CharSequence)StringUtils.trim((String)line), (CharSequence)this.debugPrefix);
    }

    static class StdOut
    extends LogHandler {
        StdOut(Log logger, Level logLevel, String errPrefix, String warnPrefix, String debugPrefix) {
            super(logger, logLevel, errPrefix, warnPrefix, debugPrefix);
        }

        void logDefault(String line) {
            this.logger.info((CharSequence)line);
        }
    }

    static class StdErr
    extends LogHandler {
        StdErr(Log logger, Level logLevel, String errPrefix, String warnPrefix, String debugPrefix) {
            super(logger, logLevel, errPrefix, warnPrefix, debugPrefix);
        }

        void logDefault(String line) {
            this.logger.warn((CharSequence)line);
        }
    }
}

