/*
 * Decompiled with CFR 0.152.
 */
package com.github.ug_dbg;

import com.github.ug_dbg.AbstractMojo;
import com.github.ug_dbg.LogHandler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="exec", threadSafe=true, defaultPhase=LifecyclePhase.COMPILE)
public class NpmMojo
extends AbstractMojo {
    @Parameter(property="npm.command")
    private String command;
    @Parameter(property="npm.args")
    private String[] args;
    @Parameter(property="npm.workingDir", defaultValue="${basedir}")
    private File workingDir;
    @Parameter(property="npm.home")
    private File npmHome;

    public void execute() throws MojoExecutionException, MojoFailureException {
        CommandLine cmd = this.addArguments(this.addCommand(this.getNpmCommand()));
        this.getLog().info((CharSequence)("Executing [" + cmd.toString() + "] in [" + this.workingDir.toString() + "]"));
        this.execute(cmd);
    }

    private void execute(CommandLine cmdLine) throws MojoFailureException, MojoExecutionException {
        NpmMojo.execute(cmdLine, this.workingDir, this.useLogHandler(), this.getLog(), this.logLevel());
    }

    protected static void execute(CommandLine cmdLine, File workingDir, boolean useLogHandler, Log log, Level level) throws MojoFailureException, MojoExecutionException {
        try {
            DefaultExecutor executor = new DefaultExecutor();
            executor.setWorkingDirectory(workingDir);
            if (useLogHandler) {
                executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)((Object)new LogHandler.StdOut(log, level, "npm ERR", "npm WARN", "npm notice")), (OutputStream)((Object)new LogHandler.StdErr(log, level, "npm ERR", "npm WARN", "npm notice")), System.in));
            }
            executor.execute(cmdLine);
        }
        catch (ExecuteException e) {
            throw new MojoFailureException("npm failure", (Throwable)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error executing NPM", (Exception)e);
        }
    }

    private CommandLine addCommand(CommandLine cmdLine) {
        return cmdLine.addArgument(this.command);
    }

    private CommandLine addArguments(CommandLine cmdLine) {
        return cmdLine.addArguments(this.args);
    }

    private CommandLine getNpmCommand() {
        return NpmMojo.getCommand("npm", this.npmHome);
    }
}

