/*
 * Decompiled with CFR 0.152.
 */
package com.github.ug_dbg;

import com.github.ug_dbg.AbstractMojo;
import com.github.ug_dbg.NpmMojo;
import java.io.File;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="exec-all", threadSafe=true, defaultPhase=LifecyclePhase.COMPILE)
public class NpmRunAllMojo
extends AbstractMojo {
    @Parameter(property="npm.command")
    private String command;
    @Parameter(property="npm.args")
    private String[] args;
    @Parameter(property="npm.workingDir", defaultValue="${basedir}")
    private File workingDir;
    @Parameter(property="npm.home")
    private File npmHome;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (String arg : this.args) {
            CommandLine cmd = this.addCommand(this.getNpmCommand());
            for (String parsedArgument : NpmRunAllMojo.parseArgument(arg)) {
                cmd = cmd.addArgument(parsedArgument);
            }
            this.getLog().info((CharSequence)("Executing [" + cmd.toString() + "] in [" + this.workingDir.toString() + "]"));
            this.execute(cmd);
        }
    }

    private void execute(CommandLine cmdLine) throws MojoFailureException, MojoExecutionException {
        NpmMojo.execute(cmdLine, this.workingDir, this.useLogHandler(), this.getLog(), this.logLevel());
    }

    private CommandLine addCommand(CommandLine cmdLine) {
        return StringUtils.isBlank((CharSequence)this.command) ? cmdLine : cmdLine.addArgument(this.command);
    }

    private CommandLine getNpmCommand() {
        return NpmRunAllMojo.getCommand("npm", this.npmHome);
    }
}

